/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.paperapi.entity;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.entity.Display;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Player;

public class ImplAxiomHiddenEntities {
    private static final Set<Marker> hiddenMarkers = Collections.newSetFromMap(new WeakHashMap());
    private static final Map<Object, UUID> hiddenDisplays = new WeakHashMap<Object, UUID>();
    private static final Set<UUID> lastSentHiddenDisplays = new HashSet<UUID>();
    private static boolean resendIgnoredDisplays = false;
    private static boolean hasSentIgnoredDisplaysToAPlayer = false;

    public static boolean isMarkerHidden(Marker marker) {
        return hiddenMarkers.contains(marker);
    }

    public static void hideMarkerGizmo(Marker marker) {
        hiddenMarkers.add(marker);
    }

    public static void hideDisplayGizmo(Display display) {
        hiddenDisplays.put(display, display.getUniqueId());
        if (hasSentIgnoredDisplaysToAPlayer && !lastSentHiddenDisplays.contains(display.getUniqueId())) {
            resendIgnoredDisplays = true;
        }
    }

    public static void hideCustomDisplayGizmo(Object object, UUID uuid) {
        hiddenDisplays.put(object, uuid);
        if (hasSentIgnoredDisplaysToAPlayer && !lastSentHiddenDisplays.contains(uuid)) {
            resendIgnoredDisplays = true;
        }
    }

    public static void tick() {
        if (resendIgnoredDisplays) {
            resendIgnoredDisplays = false;
            lastSentHiddenDisplays.clear();
            lastSentHiddenDisplays.addAll(hiddenDisplays.values());
            ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
            for (EntityPlayer player : MinecraftServer.getServer().ac().t()) {
                if (!AxiomPaper.PLUGIN.canUseAxiom((Player)player.getBukkitEntity())) continue;
                players.add(player);
            }
            if (players.isEmpty()) {
                hasSentIgnoredDisplaysToAPlayer = false;
            } else {
                ImplAxiomHiddenEntities.sendAll(players);
            }
        }
    }

    public static void sendAll(List<EntityPlayer> players) {
        if (players.isEmpty()) {
            return;
        }
        hasSentIgnoredDisplaysToAPlayer = true;
        if (!hiddenDisplays.isEmpty()) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.a(hiddenDisplays.values(), (buffer, uuid) -> buffer.a(uuid));
            VersionHelper.sendCustomPayloadToAll(players, "axiom:ignore_display_entities", ByteBufUtil.getBytes((ByteBuf)buf));
        }
    }
}

