/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.paperapi.display;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.paperapi.AxiomAlreadyRegisteredException;
import com.moulberry.axiom.paperapi.display.AxiomCustomDisplayBuilder;
import com.moulberry.axiom.paperapi.display.ImplAxiomCustomDisplay;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ImplServerCustomDisplays {
    private static final Map<MinecraftKey, ImplAxiomCustomDisplay> registeredDisplays = new LinkedHashMap<MinecraftKey, ImplAxiomCustomDisplay>();
    private static final Map<Plugin, List<MinecraftKey>> byPlugin = new HashMap<Plugin, List<MinecraftKey>>();
    private static boolean pendingReregisterAll = false;
    private static boolean hasRegisteredToAPlayer = false;

    public static void register(Plugin plugin, AxiomCustomDisplayBuilder customDisplayBuilder) throws AxiomAlreadyRegisteredException {
        if (!MinecraftServer.getServer().bl()) {
            throw new Error("Wrong thread");
        }
        ImplAxiomCustomDisplay customDisplay = customDisplayBuilder.build();
        if (registeredDisplays.containsKey(customDisplay.id())) {
            throw new AxiomAlreadyRegisteredException("Custom display is already registered with id " + customDisplay.id());
        }
        registeredDisplays.put(customDisplay.id(), customDisplay);
        byPlugin.computeIfAbsent(plugin, k -> new ArrayList()).add(customDisplay.id());
        if (hasRegisteredToAPlayer) {
            pendingReregisterAll = true;
        }
    }

    private static void write(PacketDataSerializer registryFriendlyByteBuf) {
        registryFriendlyByteBuf.d(registeredDisplays.size());
        for (ImplAxiomCustomDisplay value : registeredDisplays.values()) {
            value.write(registryFriendlyByteBuf);
        }
    }

    public static void unregisterAll(Plugin plugin) {
        List<MinecraftKey> remove = byPlugin.remove(plugin);
        if (remove == null || remove.isEmpty()) {
            return;
        }
        if (hasRegisteredToAPlayer) {
            pendingReregisterAll = true;
        }
        for (MinecraftKey id : remove) {
            registeredDisplays.remove(id);
        }
    }

    public static void tick() {
        if (pendingReregisterAll) {
            pendingReregisterAll = false;
            ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
            for (EntityPlayer player : MinecraftServer.getServer().ac().t()) {
                int playerProtocolVersion;
                if (!AxiomPaper.PLUGIN.canUseAxiom((Player)player.getBukkitEntity()) || (playerProtocolVersion = AxiomPaper.PLUGIN.getProtocolVersionFor(player.ct())) != SharedConstants.c()) continue;
                players.add(player);
            }
            if (players.isEmpty()) {
                hasRegisteredToAPlayer = false;
            } else {
                IRegistryCustom.Dimension registryAccess = MinecraftServer.getServer().aV();
                ImplServerCustomDisplays.sendAll(players, (IRegistryCustom)registryAccess);
            }
        }
    }

    private static void sendAll(List<EntityPlayer> players, IRegistryCustom registryAccess) {
        if (players.isEmpty()) {
            return;
        }
        hasRegisteredToAPlayer = true;
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        ImplServerCustomDisplays.write(buf);
        VersionHelper.sendCustomPayloadToAll(players, "axiom:register_custom_items", ByteBufUtil.getBytes((ByteBuf)buf));
    }

    public static void sendAll(EntityPlayer player) {
        hasRegisteredToAPlayer = true;
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        ImplServerCustomDisplays.write(buf);
        VersionHelper.sendCustomPayload(player, "axiom:register_custom_items", ByteBufUtil.getBytes((ByteBuf)buf));
    }
}

