/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.paperapi.block;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.paperapi.AxiomAlreadyRegisteredException;
import com.moulberry.axiom.paperapi.block.AxiomCustomBlockBuilder;
import com.moulberry.axiom.paperapi.block.AxiomProperty;
import com.moulberry.axiom.paperapi.block.ImplAxiomCustomBlock;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ImplServerCustomBlocks {
    private static final Map<MinecraftKey, ImplAxiomCustomBlock> registeredBlocks = new LinkedHashMap<MinecraftKey, ImplAxiomCustomBlock>();
    private static final Map<IBlockData, MinecraftKey> registeredBlockStates = new HashMap<IBlockData, MinecraftKey>();
    private static final Map<Plugin, List<MinecraftKey>> byPlugin = new HashMap<Plugin, List<MinecraftKey>>();
    private static boolean pendingReregisterAll = false;
    private static boolean hasRegisteredToAPlayer = false;

    public static void register(Plugin plugin, AxiomCustomBlockBuilder customBlockBuilder) throws AxiomAlreadyRegisteredException {
        if (!MinecraftServer.getServer().bl()) {
            throw new Error("Wrong thread");
        }
        ImplAxiomCustomBlock customBlock = customBlockBuilder.build();
        ImplServerCustomBlocks.validateCorrectNumberOfStates(customBlock.properties(), customBlock.blocks().size());
        HashSet<IBlockData> blockStateSet = new HashSet<IBlockData>(customBlock.blocks());
        ImplServerCustomBlocks.checkMappingContainedInSet(customBlock.rotateYMappings(), blockStateSet, "customRotateY");
        ImplServerCustomBlocks.checkMappingContainedInSet(customBlock.flipXMappings(), blockStateSet, "customFlipX");
        ImplServerCustomBlocks.checkMappingContainedInSet(customBlock.flipYMappings(), blockStateSet, "customFlipY");
        ImplServerCustomBlocks.checkMappingContainedInSet(customBlock.flipZMappings(), blockStateSet, "customFlipZ");
        if (registeredBlocks.containsKey(customBlock.id())) {
            throw new AxiomAlreadyRegisteredException("Custom block is already registered with id " + customBlock.id());
        }
        for (IBlockData block : customBlock.blocks()) {
            MinecraftKey existingId = registeredBlockStates.get(block);
            if (existingId == null) continue;
            throw new AxiomAlreadyRegisteredException("BlockState " + block + " is already used by " + existingId);
        }
        registeredBlocks.put(customBlock.id(), customBlock);
        for (IBlockData block : customBlock.blocks()) {
            registeredBlockStates.put(block, customBlock.id());
        }
        byPlugin.computeIfAbsent(plugin, k -> new ArrayList()).add(customBlock.id());
        if (!pendingReregisterAll && hasRegisteredToAPlayer) {
            byte[] registerPacketData = null;
            byte[] registerPacketDataMismatch = null;
            for (EntityPlayer player : MinecraftServer.getServer().ac().t()) {
                PacketDataSerializer buf;
                boolean protocolMismatch;
                if (!AxiomPaper.PLUGIN.canUseAxiom((Player)player.getBukkitEntity())) continue;
                int playerProtocolVersion = AxiomPaper.PLUGIN.getProtocolVersionFor(player.ct());
                boolean bl = protocolMismatch = playerProtocolVersion != SharedConstants.c();
                if (!protocolMismatch) {
                    if (registerPacketDataMismatch == null) {
                        buf = new PacketDataSerializer(Unpooled.buffer());
                        customBlock.write(buf, true);
                        registerPacketDataMismatch = ByteBufUtil.getBytes((ByteBuf)buf);
                    }
                    VersionHelper.sendCustomPayload(player, "axiom:register_custom_block_v2", registerPacketDataMismatch);
                    continue;
                }
                if (registerPacketData == null) {
                    buf = new PacketDataSerializer(Unpooled.buffer());
                    customBlock.write(buf, false);
                    registerPacketData = ByteBufUtil.getBytes((ByteBuf)buf);
                }
                VersionHelper.sendCustomPayload(player, "axiom:register_custom_block_v2", registerPacketData);
            }
        }
    }

    public static void unregisterAll(Plugin plugin) {
        List<MinecraftKey> remove = byPlugin.remove(plugin);
        if (remove == null || remove.isEmpty()) {
            return;
        }
        if (hasRegisteredToAPlayer) {
            pendingReregisterAll = true;
        }
        for (MinecraftKey id : remove) {
            ImplAxiomCustomBlock block = registeredBlocks.remove(id);
            for (IBlockData blockState : block.blocks()) {
                registeredBlockStates.remove(blockState);
            }
        }
    }

    public static void tick() {
        if (pendingReregisterAll) {
            pendingReregisterAll = false;
            ArrayList<EntityPlayer> playersWithCorrectProtocol = new ArrayList<EntityPlayer>();
            ArrayList<EntityPlayer> playersWithMismatchProtocol = new ArrayList<EntityPlayer>();
            for (EntityPlayer player : MinecraftServer.getServer().ac().t()) {
                boolean protocolMismatch;
                if (!AxiomPaper.PLUGIN.canUseAxiom((Player)player.getBukkitEntity())) continue;
                int playerProtocolVersion = AxiomPaper.PLUGIN.getProtocolVersionFor(player.ct());
                boolean bl = protocolMismatch = playerProtocolVersion != SharedConstants.c();
                if (protocolMismatch) {
                    playersWithMismatchProtocol.add(player);
                    continue;
                }
                playersWithCorrectProtocol.add(player);
            }
            if (playersWithCorrectProtocol.isEmpty() && playersWithMismatchProtocol.isEmpty()) {
                hasRegisteredToAPlayer = false;
            } else {
                IRegistryCustom.Dimension registryAccess = MinecraftServer.getServer().aV();
                ImplServerCustomBlocks.sendAll(playersWithCorrectProtocol, (IRegistryCustom)registryAccess, false);
                ImplServerCustomBlocks.sendAll(playersWithMismatchProtocol, (IRegistryCustom)registryAccess, true);
            }
        }
    }

    private static void sendAll(List<EntityPlayer> players, IRegistryCustom registryAccess, boolean protocolMismatch) {
        if (players.isEmpty()) {
            return;
        }
        hasRegisteredToAPlayer = true;
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.d(0);
        VersionHelper.sendCustomPayloadToAll(players, "axiom:custom_blocks", ByteBufUtil.getBytes((ByteBuf)buf));
        for (ImplAxiomCustomBlock customBlock : registeredBlocks.values()) {
            buf.clear();
            customBlock.write(buf, protocolMismatch);
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
            VersionHelper.sendCustomPayloadToAll(players, "axiom:register_custom_block_v2", bytes);
        }
    }

    public static void sendAll(EntityPlayer player) {
        hasRegisteredToAPlayer = true;
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.d(0);
        VersionHelper.sendCustomPayload(player, "axiom:custom_blocks", ByteBufUtil.getBytes((ByteBuf)buf));
        int playerProtocolVersion = AxiomPaper.PLUGIN.getProtocolVersionFor(player.ct());
        boolean protocolMismatch = playerProtocolVersion != SharedConstants.c();
        for (ImplAxiomCustomBlock customBlock : registeredBlocks.values()) {
            buf.clear();
            customBlock.write(buf, protocolMismatch);
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
            VersionHelper.sendCustomPayload(player, "axiom:register_custom_block_v2", bytes);
        }
    }

    private static void checkMappingContainedInSet(Map<IBlockData, IBlockData> mappings, Set<IBlockData> vanillaStatesSet, String name) {
        for (Map.Entry<IBlockData, IBlockData> entry : mappings.entrySet()) {
            if (vanillaStatesSet.contains(entry.getKey()) || vanillaStatesSet.contains(entry.getValue())) continue;
            throw new RuntimeException(name + " mapping either key or value must be part of custom block");
        }
    }

    private static void validateCorrectNumberOfStates(List<AxiomProperty> properties, int numBlocks) {
        int expectedStates = 1;
        for (AxiomProperty property : properties) {
            expectedStates *= property.numValues();
        }
        if (expectedStates != numBlocks) {
            StringBuilder error = new StringBuilder();
            error.append("Incorrect number of blocks provided, needed ");
            error.append(expectedStates);
            error.append(", got ");
            error.append(numBlocks);
            error.append(": ");
            if (properties.isEmpty()) {
                error.append("no properties ");
            } else {
                boolean first = true;
                for (AxiomProperty property : properties) {
                    if (first) {
                        first = false;
                    } else {
                        error.append("* ");
                    }
                    error.append(property.name());
                    error.append(" (");
                    error.append(property.numValues());
                    error.append(") ");
                }
            }
            error.append(" = ").append(expectedStates).append(" block(s)");
            throw new RuntimeException(error.toString());
        }
    }
}

