/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.paperapi.block;

import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.paperapi.block.AxiomPlacementLogic;
import com.moulberry.axiom.paperapi.block.AxiomProperty;
import com.moulberry.axiom.paperapi.block.ImplAxiomProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.Registry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ImplAxiomCustomBlock(MinecraftKey id, String translationKey, List<AxiomProperty> properties, List<IBlockData> blocks, @Nullable net.minecraft.world.item.ItemStack itemStack, Set<AxiomPlacementLogic> placementLogics, boolean sendServerPickBlockIfPossible, boolean preventRightClickInteraction, boolean preventShapeUpdates, boolean automaticRotationAndMirroring, Map<IBlockData, IBlockData> rotateYMappings, Map<IBlockData, IBlockData> flipXMappings, Map<IBlockData, IBlockData> flipYMappings, Map<IBlockData, IBlockData> flipZMappings) {
    public ImplAxiomCustomBlock(Key key, String translationKey, List<AxiomProperty> properties, List<BlockData> blocks, @Nullable ItemStack itemStack, Set<AxiomPlacementLogic> placementLogics, boolean sendServerPickBlockIfPossible, boolean preventRightClickInteraction, boolean preventShapeUpdates, boolean automaticRotationAndMirroring, Map<BlockData, BlockData> rotateYMappings, Map<BlockData, BlockData> flipXMappings, Map<BlockData, BlockData> flipYMappings, Map<BlockData, BlockData> flipZMappings) {
        this(ImplAxiomCustomBlock.convertKey(key), translationKey, properties, ImplAxiomCustomBlock.convertBlockDataToBlockStates(blocks), itemStack == null ? null : CraftItemStack.asNMSCopy((ItemStack)itemStack), placementLogics, sendServerPickBlockIfPossible, preventRightClickInteraction, preventShapeUpdates, automaticRotationAndMirroring, ImplAxiomCustomBlock.convertBlockDataToBlockStates(rotateYMappings), ImplAxiomCustomBlock.convertBlockDataToBlockStates(flipXMappings), ImplAxiomCustomBlock.convertBlockDataToBlockStates(flipYMappings), ImplAxiomCustomBlock.convertBlockDataToBlockStates(flipZMappings));
    }

    private static MinecraftKey convertKey(Key key) {
        return VersionHelper.createResourceLocation(key.namespace(), key.value());
    }

    private static List<IBlockData> convertBlockDataToBlockStates(List<BlockData> blockData) {
        ArrayList<IBlockData> blockStates = new ArrayList<IBlockData>(blockData.size());
        for (BlockData blockDatum : blockData) {
            blockStates.add(((CraftBlockData)blockDatum).getState());
        }
        return blockStates;
    }

    private static Map<IBlockData, IBlockData> convertBlockDataToBlockStates(Map<BlockData, BlockData> blockData) {
        HashMap<IBlockData, IBlockData> blockStates = new HashMap<IBlockData, IBlockData>(blockData.size());
        for (Map.Entry<BlockData, BlockData> entry : blockData.entrySet()) {
            blockStates.put(((CraftBlockData)entry.getKey()).getState(), ((CraftBlockData)entry.getValue()).getState());
        }
        return blockStates;
    }

    public void write(PacketDataSerializer friendlyByteBuf, boolean protocolMismatch) {
        PacketDataSerializer.b writeBlockState = protocolMismatch ? ImplAxiomCustomBlock::writeBlockStateString : ImplAxiomCustomBlock::writeBlockStateId;
        friendlyByteBuf.a(this.id);
        friendlyByteBuf.a(this.translationKey);
        friendlyByteBuf.a(this.properties, ImplAxiomCustomBlock::writeProperty);
        friendlyByteBuf.a(this.blocks, writeBlockState);
        if (this.itemStack != null && !protocolMismatch) {
            friendlyByteBuf.writeBoolean(true);
            friendlyByteBuf.a(this.itemStack);
        } else {
            friendlyByteBuf.writeBoolean(false);
        }
        friendlyByteBuf.writeBoolean(this.sendServerPickBlockIfPossible);
        friendlyByteBuf.writeBoolean(this.preventRightClickInteraction);
        friendlyByteBuf.writeBoolean(this.preventShapeUpdates);
        friendlyByteBuf.d(this.placementLogics.size());
        for (AxiomPlacementLogic placementLogic : this.placementLogics) {
            String id = switch (placementLogic) {
                default -> throw new IncompatibleClassChangeError();
                case AxiomPlacementLogic.AXIS -> "axiom:axis";
                case AxiomPlacementLogic.FACING -> "axiom:facing";
                case AxiomPlacementLogic.FACING_OPPOSITE -> "axiom:facing_opposite";
                case AxiomPlacementLogic.FACING_CLICKED -> "axiom:facing_clicked";
                case AxiomPlacementLogic.FACING_CLICKED_OPPOSITE -> "axiom:facing_clicked_opposite";
                case AxiomPlacementLogic.WATERLOGGED -> "axiom:waterlogged";
                case AxiomPlacementLogic.HALF -> "axiom:half";
            };
            friendlyByteBuf.a(id);
        }
        friendlyByteBuf.writeBoolean(this.automaticRotationAndMirroring);
        friendlyByteBuf.a(this.rotateYMappings, writeBlockState, writeBlockState);
        friendlyByteBuf.a(this.flipXMappings, writeBlockState, writeBlockState);
        friendlyByteBuf.a(this.flipYMappings, writeBlockState, writeBlockState);
        friendlyByteBuf.a(this.flipZMappings, writeBlockState, writeBlockState);
        friendlyByteBuf.d(0);
    }

    private static void writeBlockStateId(PacketDataSerializer buf, IBlockData blockState) {
        buf.a((Registry)Block.o, (Object)blockState);
    }

    private static void writeBlockStateString(PacketDataSerializer buf, IBlockData blockState) {
        buf.d(-1);
        buf.a(ArgumentBlock.a((IBlockData)blockState));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeProperty(PacketDataSerializer friendlyByteBuf, AxiomProperty property) {
        if (property instanceof ImplAxiomProperties.NmsAxiomProperty) {
            ImplAxiomProperties.NmsAxiomProperty nmsAxiomProperty = (ImplAxiomProperties.NmsAxiomProperty)property;
            IBlockState<?> inner = nmsAxiomProperty.property();
            if (inner == BlockProperties.I) {
                friendlyByteBuf.writeByte(3);
                return;
            } else if (inner == BlockProperties.H) {
                friendlyByteBuf.writeByte(4);
                return;
            } else if (inner == BlockProperties.P) {
                friendlyByteBuf.writeByte(5);
                return;
            } else if (inner == BlockProperties.R) {
                friendlyByteBuf.writeByte(6);
                return;
            } else if (inner == BlockProperties.J) {
                friendlyByteBuf.writeByte(7);
                return;
            } else if (inner == BlockProperties.K) {
                friendlyByteBuf.writeByte(8);
                return;
            } else if (inner == BlockProperties.L) {
                friendlyByteBuf.writeByte(9);
                return;
            } else if (inner == BlockProperties.M) {
                friendlyByteBuf.writeByte(10);
                return;
            } else if (inner == BlockProperties.N) {
                friendlyByteBuf.writeByte(11);
                return;
            } else if (inner == BlockProperties.O) {
                friendlyByteBuf.writeByte(12);
                return;
            } else if (inner == BlockProperties.C) {
                friendlyByteBuf.writeByte(13);
                return;
            } else if (inner == BlockProperties.af) {
                friendlyByteBuf.writeByte(14);
                return;
            } else if (inner == BlockProperties.bm) {
                friendlyByteBuf.writeByte(15);
                return;
            } else if (inner instanceof BlockStateBoolean) {
                friendlyByteBuf.writeByte(0);
                friendlyByteBuf.a(inner.f());
                return;
            } else if (inner instanceof BlockStateInteger) {
                BlockStateInteger integerProperty = (BlockStateInteger)inner;
                friendlyByteBuf.writeByte(1);
                friendlyByteBuf.a(inner.f());
                friendlyByteBuf.writeInt(integerProperty.b);
                friendlyByteBuf.writeInt(integerProperty.c);
                return;
            } else {
                if (!(inner instanceof BlockStateEnum)) throw new UnsupportedOperationException("Unknown property type: " + property.getClass());
                BlockStateEnum enumProperty = (BlockStateEnum)inner;
                friendlyByteBuf.writeByte(2);
                friendlyByteBuf.a(inner.f());
                friendlyByteBuf.a(enumProperty.a(), (buf, e) -> buf.a(((INamable)e).c()));
            }
            return;
        } else {
            if (!(property instanceof ImplAxiomProperties.StringProperty)) throw new Error("Don't know how to serialize " + property.getClass());
            ImplAxiomProperties.StringProperty stringProperty = (ImplAxiomProperties.StringProperty)property;
            friendlyByteBuf.writeByte(2);
            friendlyByteBuf.a(stringProperty.name());
            friendlyByteBuf.a(stringProperty.values(), PacketDataSerializer::a);
        }
    }
}

