/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.paperapi.block;

import com.moulberry.axiom.paperapi.block.ImplAxiomProperties;
import java.util.List;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AxiomProperty {
    public String name();

    public int numValues();

    public static AxiomProperty customBoolean(String name) {
        return AxiomProperty.fromNms(BlockStateBoolean.a((String)name));
    }

    public static AxiomProperty customInt(String name, int min, int max) {
        return AxiomProperty.fromNms(BlockStateInteger.a((String)name, (int)min, (int)max));
    }

    public static AxiomProperty customString(String name, List<String> values) {
        return new ImplAxiomProperties.StringProperty(name, values);
    }

    public static AxiomProperty fromNms(IBlockState<?> property) {
        return new ImplAxiomProperties.NmsAxiomProperty(property);
    }

    public static AxiomProperty axis() {
        return ImplAxiomProperties.PROPERTY_AXIS;
    }

    public static AxiomProperty horizontalAxis() {
        return ImplAxiomProperties.PROPERTY_HORIZONTAL_AXIS;
    }

    public static AxiomProperty facing() {
        return ImplAxiomProperties.PROPERTY_FACING;
    }

    public static AxiomProperty horizontalFacing() {
        return ImplAxiomProperties.PROPERTY_HORIZONTAL_FACING;
    }

    public static AxiomProperty up() {
        return ImplAxiomProperties.PROPERTY_UP;
    }

    public static AxiomProperty down() {
        return ImplAxiomProperties.PROPERTY_DOWN;
    }

    public static AxiomProperty north() {
        return ImplAxiomProperties.PROPERTY_NORTH;
    }

    public static AxiomProperty east() {
        return ImplAxiomProperties.PROPERTY_EAST;
    }

    public static AxiomProperty south() {
        return ImplAxiomProperties.PROPERTY_SOUTH;
    }

    public static AxiomProperty west() {
        return ImplAxiomProperties.PROPERTY_WEST;
    }

    public static AxiomProperty waterlogged() {
        return ImplAxiomProperties.PROPERTY_WATERLOGGED;
    }

    public static AxiomProperty half() {
        return ImplAxiomProperties.PROPERTY_HALF;
    }

    public static AxiomProperty verticalDirection() {
        return ImplAxiomProperties.PROPERTY_VERTICAL_DIRECTION;
    }
}

