/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet.impl;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.blueprint.RawBlueprint;
import com.moulberry.axiom.blueprint.ServerBlueprintManager;
import com.moulberry.axiom.blueprint.ServerBlueprintRegistry;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.restrictions.AxiomPermission;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.kyori.adventure.text.Component;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class UploadBlueprintPacketListener
implements PacketHandler {
    private final AxiomPaper plugin;

    public UploadBlueprintPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean handleAsync() {
        return true;
    }

    @Override
    public void onReceive(Player player, PacketDataSerializer friendlyByteBuf) {
        if (!this.plugin.canUseAxiom(player, AxiomPermission.BLUEPRINT_UPLOAD)) {
            friendlyByteBuf.writerIndex(friendlyByteBuf.readerIndex());
            return;
        }
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (this.plugin.isMismatchedDataVersion(serverPlayer.ct())) {
            serverPlayer.cI().execute(() -> serverPlayer.a((IChatBaseComponent)IChatBaseComponent.b((String)"Axiom+ViaVersion: This feature isn't supported. Switch your client version to 1.20.1 to use this")));
            friendlyByteBuf.writerIndex(friendlyByteBuf.readerIndex());
            return;
        }
        ServerBlueprintRegistry registry = ServerBlueprintManager.getRegistry();
        if (registry == null || this.plugin.blueprintFolder == null) {
            friendlyByteBuf.writerIndex(friendlyByteBuf.readerIndex());
            return;
        }
        String pathStr = friendlyByteBuf.s();
        RawBlueprint rawBlueprint = RawBlueprint.read(friendlyByteBuf);
        if (!(pathStr = pathStr.replace("\\", "/")).endsWith(".bp") || pathStr.contains("..") || !pathStr.startsWith("/")) {
            return;
        }
        Path relative = Path.of(pathStr = pathStr.substring(1), new String[0]).normalize();
        if (relative.isAbsolute()) {
            return;
        }
        String pathName = pathStr.substring(0, pathStr.length() - 3);
        serverPlayer.cI().execute(() -> {
            try {
                Path path = this.plugin.blueprintFolder.resolve(relative);
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    return;
                }
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                    BlueprintIo.writeRaw(outputStream, rawBlueprint);
                }
                catch (IOException e) {
                    return;
                }
                registry.blueprints().put("/" + pathName, rawBlueprint);
                ServerBlueprintManager.sendManifest(serverPlayer.cI().ac().t());
            }
            catch (Throwable t) {
                serverPlayer.getBukkitEntity().kick((Component)Component.text((String)("An error occured while uploading blueprint: " + t.getMessage())));
            }
        });
    }
}

