/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet.impl;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.annotations.AnnotationUpdateAction;
import com.moulberry.axiom.annotations.ServerAnnotations;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.restrictions.AxiomPermission;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class UpdateAnnotationPacketListener
implements PacketHandler {
    private final AxiomPaper plugin;

    public UpdateAnnotationPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onReceive(Player player, PacketDataSerializer friendlyByteBuf) {
        if (!this.plugin.allowAnnotations || !this.plugin.canUseAxiom(player, AxiomPermission.ANNOTATION_CREATE)) {
            friendlyByteBuf.writerIndex(friendlyByteBuf.readerIndex());
            return;
        }
        if (!this.plugin.canModifyWorld(player, player.getWorld())) {
            return;
        }
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        int length = friendlyByteBuf.m();
        ArrayList<AnnotationUpdateAction> actions = new ArrayList<AnnotationUpdateAction>(Math.min(256, length));
        for (int i = 0; i < length; ++i) {
            AnnotationUpdateAction action = AnnotationUpdateAction.read(friendlyByteBuf);
            if (action == null) continue;
            actions.add(action);
        }
        serverPlayer.cI().execute(() -> {
            try {
                ServerAnnotations.handleUpdates((World)serverPlayer.x().getWorld(), actions);
            }
            catch (Throwable t) {
                serverPlayer.getBukkitEntity().kick((Component)Component.text((String)("An error occured while updating annotations: " + t.getMessage())));
            }
        });
    }
}

