/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet.impl;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.NbtSanitization;
import com.moulberry.axiom.event.AxiomSpawnEntityEvent;
import com.moulberry.axiom.integration.Integration;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.viaversion.UnknownVersionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public class SpawnEntityPacketListener
implements PacketHandler {
    private final AxiomPaper plugin;
    private static final EnumBlockRotation[] ROTATION_VALUES = EnumBlockRotation.values();

    public SpawnEntityPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onReceive(Player player, PacketDataSerializer friendlyByteBuf) {
        if (!this.plugin.canUseAxiom(player, AxiomPermission.ENTITY_SPAWN)) {
            return;
        }
        if (!this.plugin.canModifyWorld(player, player.getWorld())) {
            return;
        }
        List entries = (List)friendlyByteBuf.a(this.plugin.limitCollection(ArrayList::new), buf -> new SpawnEntry(buf.o(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), (UUID)buf.c(PacketDataSerializer::o), UnknownVersionHelper.readTagUnknown(buf, player)));
        WorldServer serverLevel = ((CraftWorld)player.getWorld()).getHandle();
        for (SpawnEntry entry : entries) {
            AtomicBoolean useNewUuid;
            net.minecraft.world.entity.Entity spawned;
            NBTTagCompound compoundTag;
            net.minecraft.world.entity.Entity entityCopyFrom;
            Vec3D position = new Vec3D(entry.x, entry.y, entry.z);
            BlockPosition blockPos = BlockPosition.a((IPosition)position);
            if (!World.k((BlockPosition)blockPos) || !Integration.canPlaceBlock(player, new Location(player.getWorld(), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w())) || serverLevel.a(entry.newUuid) != null) continue;
            NBTTagCompound tag = entry.tag == null ? new NBTTagCompound() : entry.tag;
            NbtSanitization.sanitizeEntity(tag);
            if (entry.copyFrom != null && (entityCopyFrom = serverLevel.a(entry.copyFrom)) != null && entityCopyFrom.d(compoundTag = new NBTTagCompound())) {
                compoundTag.r("Dimension");
                tag = tag.a(compoundTag);
            }
            if (!tag.e("id") || (spawned = EntityTypes.a((NBTTagCompound)tag, (World)serverLevel, arg_0 -> this.lambda$onReceive$1(useNewUuid = new AtomicBoolean(true), entry, position, arg_0))) == null || !serverLevel.e(spawned)) continue;
            AxiomSpawnEntityEvent spawnEntityEvent = new AxiomSpawnEntityEvent(player, (Entity)spawned.getBukkitEntity());
            Bukkit.getPluginManager().callEvent((Event)spawnEntityEvent);
            if (!spawnEntityEvent.isCancelled() && !spawned.dD()) continue;
            for (net.minecraft.world.entity.Entity passenger : spawned.cR()) {
                passenger.ai();
            }
            spawned.ai();
        }
    }

    private /* synthetic */ net.minecraft.world.entity.Entity lambda$onReceive$1(AtomicBoolean useNewUuid, SpawnEntry entry, Vec3D position, net.minecraft.world.entity.Entity entity) {
        if (!this.plugin.canEntityBeManipulated(entity.ae())) {
            return null;
        }
        if (useNewUuid.getAndSet(false)) {
            entity.a_(entry.newUuid);
        } else {
            entity.a_(UUID.randomUUID());
        }
        if (entity instanceof EntityHanging) {
            EntityItemFrame itemFrame;
            EntityHanging hangingEntity = (EntityHanging)entity;
            float changedYaw = entry.yaw - entity.dy();
            int rotations = Math.round(changedYaw / 90.0f);
            hangingEntity.a(ROTATION_VALUES[rotations & 3]);
            if (entity instanceof EntityItemFrame && (itemFrame = (EntityItemFrame)entity).cB().o() == EnumDirection.EnumAxis.b) {
                itemFrame.b(itemFrame.D() - Math.round(changedYaw / 45.0f));
            }
        }
        entity.b(position.c, position.d, position.e, entry.yaw, entry.pitch);
        entity.n(entity.dy());
        return entity;
    }

    private record SpawnEntry(UUID newUuid, double x, double y, double z, float yaw, float pitch, @Nullable UUID copyFrom, NBTTagCompound tag) {
    }
}

