/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet.impl;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.integration.plotsquared.PlotSquaredIntegration;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertiesRegistry;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertyHolder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.entity.Player;

public class SetWorldPropertyListener
implements PacketHandler {
    private final AxiomPaper plugin;

    public SetWorldPropertyListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onReceive(Player player, PacketDataSerializer friendlyByteBuf) {
        if (!this.plugin.canUseAxiom(player, AxiomPermission.WORLD_PROPERTY)) {
            return;
        }
        MinecraftKey id = friendlyByteBuf.t();
        int type = friendlyByteBuf.m();
        byte[] data = friendlyByteBuf.b();
        int updateId = friendlyByteBuf.m();
        if (!this.plugin.canModifyWorld(player, player.getWorld())) {
            this.sendAck(player, updateId);
            return;
        }
        if (PlotSquaredIntegration.isPlotWorld(player.getWorld())) {
            this.sendAck(player, updateId);
            return;
        }
        ServerWorldPropertiesRegistry registry = AxiomPaper.PLUGIN.getOrCreateWorldProperties(player.getWorld());
        if (registry == null) {
            this.sendAck(player, updateId);
            return;
        }
        ServerWorldPropertyHolder<?> property = registry.getById(id);
        if (property != null && property.getType().getTypeId() == type) {
            property.update(player, player.getWorld(), data);
        }
        this.sendAck(player, updateId);
    }

    private void sendAck(Player player, int updateId) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.d(updateId);
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
        VersionHelper.sendCustomPayload(player, "axiom:ack_world_properties", bytes);
    }
}

