/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet.impl;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.event.AxiomTimeChangeEvent;
import com.moulberry.axiom.integration.plotsquared.PlotSquaredIntegration;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.restrictions.AxiomPermission;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GameRules;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class SetTimePacketListener
implements PacketHandler {
    private final AxiomPaper plugin;

    public SetTimePacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onReceive(Player player, PacketDataSerializer friendlyByteBuf) {
        if (!this.plugin.canUseAxiom(player, AxiomPermission.WORLD_TIME)) {
            return;
        }
        ResourceKey key = friendlyByteBuf.a(Registries.aH);
        Integer time = (Integer)friendlyByteBuf.c(PacketDataSerializer::readInt);
        Boolean freezeTime = (Boolean)friendlyByteBuf.c(PacketDataSerializer::readBoolean);
        if (time == null && freezeTime == null) {
            return;
        }
        WorldServer level = ((CraftWorld)player.getWorld()).getHandle();
        if (!level.ac().equals(key)) {
            return;
        }
        if (PlotSquaredIntegration.isPlotWorld(player.getWorld())) {
            return;
        }
        if (!this.plugin.canModifyWorld(player, player.getWorld())) {
            return;
        }
        AxiomTimeChangeEvent timeChangeEvent = new AxiomTimeChangeEvent(player, time, freezeTime);
        Bukkit.getPluginManager().callEvent((Event)timeChangeEvent);
        if (timeChangeEvent.isCancelled()) {
            return;
        }
        if (time != null) {
            level.b((long)time.intValue());
        }
        if (freezeTime != null) {
            ((GameRules.GameRuleBoolean)level.X().a(GameRules.k)).set(freezeTime == false, null);
        }
    }
}

