/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.AxiomReflection;
import com.moulberry.axiom.integration.Integration;
import com.moulberry.axiom.integration.coreprotect.CoreProtectIntegration;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.restrictions.AxiomPermission;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SetBlockPacketListener
implements PacketHandler {
    public static final int REASON_REPLACEMODE = 1;
    public static final int REASON_ANGEL = 128;
    private final AxiomPaper plugin;

    public SetBlockPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onReceive(Player bukkitPlayer, PacketDataSerializer friendlyByteBuf) {
        BlockPosition clickedPos;
        if (!this.plugin.canUseAxiom(bukkitPlayer, AxiomPermission.BUILD_PLACE)) {
            return;
        }
        if (!this.plugin.canModifyWorld(bukkitPlayer, bukkitPlayer.getWorld())) {
            return;
        }
        IntFunction<Map> mapFunction = this.plugin.limitCollection(Maps::newLinkedHashMapWithExpectedSize);
        RegistryBlockID<IBlockData> registry = this.plugin.getBlockRegistry(bukkitPlayer.getUniqueId());
        Map blocks = friendlyByteBuf.a(mapFunction, PacketDataSerializer::f, buf -> (IBlockData)buf.a((Registry)registry));
        boolean updateNeighbors = friendlyByteBuf.readBoolean();
        Set preventUpdatesAt = Set.of();
        if (updateNeighbors) {
            IntFunction<Set> setFunction = this.plugin.limitCollection(Sets::newHashSetWithExpectedSize);
            preventUpdatesAt = (Set)friendlyByteBuf.a(setFunction, buf -> buf.f());
        }
        if (this.plugin.logLargeBlockBufferChanges() && blocks.size() > 64) {
            this.plugin.getLogger().info("Player " + bukkitPlayer.getUniqueId() + " modified " + blocks.size() + " individual blocks with axiom");
        }
        int reason = friendlyByteBuf.m();
        boolean breaking = friendlyByteBuf.readBoolean();
        MovingObjectPositionBlock blockHit = friendlyByteBuf.x();
        EnumHand hand = (EnumHand)friendlyByteBuf.b(EnumHand.class);
        int sequenceId = friendlyByteBuf.m();
        EntityPlayer player = ((CraftPlayer)bukkitPlayer).getHandle();
        CraftWorld world = player.dI().getWorld();
        if (sequenceId >= 0) {
            player.c.a(sequenceId);
        }
        BlockActionContext blockPlaceContext = new BlockActionContext((EntityHuman)player, hand, player.b(hand), blockHit);
        if ((reason & 1) == 0 && (reason & 0x80) == 0 && !SetBlockPacketListener.fireBukkitEvents(bukkitPlayer, blockHit, breaking, blocks, player, world, hand)) {
            return;
        }
        if (updateNeighbors) {
            if (preventUpdatesAt.isEmpty()) {
                for (Map.Entry entry : blocks.entrySet()) {
                    IBlockData old;
                    blockPos = (BlockPosition)entry.getKey();
                    blockState = (IBlockData)entry.getValue();
                    if (!SetBlockPacketListener.canBreakOrPlace(bukkitPlayer, (IBlockData)blockState, world, blockPos)) continue;
                    boolean bl = false;
                    if (CoreProtectIntegration.isEnabled() && (old = player.dI().a_(blockPos)) != blockState) {
                        CoreProtectIntegration.logRemoval(bukkitPlayer.getName(), old, world, blockPos);
                        bl = true;
                    }
                    player.dI().a(blockPos, (IBlockData)blockState, 3);
                    if (!bl) continue;
                    CoreProtectIntegration.logPlacement(bukkitPlayer.getName(), (IBlockData)blockState, world, blockPos);
                }
            } else {
                EnumDirection[] directions = EnumDirection.values();
                BlockPosition.MutableBlockPosition mutable = new BlockPosition.MutableBlockPosition();
                LinkedHashMap<BlockPosition, IBlockData> delayedSetWithoutUpdates = new LinkedHashMap<BlockPosition, IBlockData>(Math.min(blocks.size(), preventUpdatesAt.size()));
                for (Map.Entry entry : blocks.entrySet()) {
                    IBlockData old;
                    BlockPosition blockPos = (BlockPosition)entry.getKey();
                    IBlockData blockState = (IBlockData)entry.getValue();
                    if (!SetBlockPacketListener.canBreakOrPlace(bukkitPlayer, blockState, world, blockPos)) continue;
                    boolean updateNeighborsForThisBlock = true;
                    for (EnumDirection direction : directions) {
                        if (!preventUpdatesAt.contains(mutable.a((BaseBlockPosition)blockPos, direction))) continue;
                        updateNeighborsForThisBlock = false;
                        break;
                    }
                    if (preventUpdatesAt.contains(blockPos)) {
                        delayedSetWithoutUpdates.put(blockPos, blockState);
                        if (!updateNeighborsForThisBlock) continue;
                    }
                    boolean logPlacement = false;
                    if (CoreProtectIntegration.isEnabled() && (old = player.dI().a_(blockPos)) != blockState) {
                        CoreProtectIntegration.logRemoval(bukkitPlayer.getName(), old, world, blockPos);
                        logPlacement = true;
                    }
                    player.dI().a(blockPos, blockState, updateNeighborsForThisBlock ? 3 : 18);
                    if (!logPlacement) continue;
                    CoreProtectIntegration.logPlacement(bukkitPlayer.getName(), blockState, world, blockPos);
                }
                for (Map.Entry entry : delayedSetWithoutUpdates.entrySet()) {
                    this.setWithoutUpdates(bukkitPlayer, (IBlockData)entry.getValue(), world, (BlockPosition)entry.getKey(), player);
                }
            }
        } else {
            for (Map.Entry entry : blocks.entrySet()) {
                blockPos = (BlockPosition)entry.getKey();
                blockState = (IBlockData)entry.getValue();
                this.setWithoutUpdates(bukkitPlayer, (IBlockData)blockState, world, blockPos, player);
            }
        }
        if (!breaking && blocks.containsKey(clickedPos = blockPlaceContext.a())) {
            if (!player.dI().o(clickedPos)) {
                return;
            }
            IBlockData desiredBlockState = (IBlockData)blocks.get(clickedPos);
            IBlockData actualBlockState = player.dI().a_(clickedPos);
            Block actualBlock = actualBlockState.b();
            if (desiredBlockState == null || desiredBlockState.i() || actualBlockState.i()) {
                return;
            }
            if (desiredBlockState.b() != actualBlock) {
                return;
            }
            if (!Integration.canPlaceBlock(bukkitPlayer, new Location((org.bukkit.World)world, (double)clickedPos.u(), (double)clickedPos.v(), (double)clickedPos.w()))) {
                return;
            }
            net.minecraft.world.item.ItemStack itemStack = player.b(hand);
            ItemBlock.a((World)player.dI(), (EntityHuman)player, (BlockPosition)clickedPos, (net.minecraft.world.item.ItemStack)itemStack);
            if (!(actualBlock instanceof BlockBed || actualBlock instanceof BlockTallPlant || actualBlock instanceof BlockDoor)) {
                actualBlock.a(player.dI(), clickedPos, actualBlockState, (EntityLiving)player, itemStack);
            }
        }
    }

    private static boolean fireBukkitEvents(Player bukkitPlayer, MovingObjectPositionBlock blockHit, boolean breaking, Map<BlockPosition, IBlockData> blocks, EntityPlayer player, CraftWorld world, EnumHand hand) {
        BlockFace blockFace;
        org.bukkit.block.Block blockClicked;
        ItemStack heldItem;
        PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(bukkitPlayer, breaking ? Action.LEFT_CLICK_BLOCK : Action.RIGHT_CLICK_BLOCK, heldItem = hand == EnumHand.a ? bukkitPlayer.getInventory().getItemInMainHand() : bukkitPlayer.getInventory().getItemInOffHand(), blockClicked = bukkitPlayer.getWorld().getBlockAt(blockHit.a().u(), blockHit.a().v(), blockHit.a().w()), blockFace = CraftBlock.notchToBlockFace((EnumDirection)blockHit.b()));
        if (!playerInteractEvent.callEvent()) {
            return false;
        }
        if (!breaking) {
            Object event;
            ArrayList<AxiomPlacingCraftBlockState> blockStates = new ArrayList<AxiomPlacingCraftBlockState>();
            for (Map.Entry<BlockPosition, IBlockData> entry : blocks.entrySet()) {
                IBlockData existing = player.x().a_(entry.getKey());
                if (!existing.r()) continue;
                blockStates.add(new AxiomPlacingCraftBlockState((org.bukkit.World)world, entry.getKey(), entry.getValue()));
            }
            if (!blockStates.isEmpty() && (event = blockStates.size() > 1 ? CraftEventFactory.callBlockMultiPlaceEvent((WorldServer)player.x(), (EntityHuman)player, (EnumHand)hand, blockStates, (int)blockHit.a().u(), (int)blockHit.a().v(), (int)blockHit.a().w()) : CraftEventFactory.callBlockPlaceEvent((WorldServer)player.x(), (EntityHuman)player, (EnumHand)hand, (BlockState)((BlockState)blockStates.get(0)), (int)blockHit.a().u(), (int)blockHit.a().v(), (int)blockHit.a().w())).isCancelled()) {
                return false;
            }
        }
        return true;
    }

    private void setWithoutUpdates(Player bukkitPlayer, IBlockData blockState, CraftWorld world, BlockPosition blockPos, EntityPlayer player) {
        boolean nowHasOnlyAir;
        if (!SetBlockPacketListener.canBreakOrPlace(bukkitPlayer, blockState, world, blockPos)) {
            return;
        }
        int bx = blockPos.u();
        int by = blockPos.v();
        int bz = blockPos.w();
        int x = bx & 0xF;
        int y = by & 0xF;
        int z = bz & 0xF;
        int cx = bx >> 4;
        int cy = by >> 4;
        int cz = bz >> 4;
        WorldServer level = player.x();
        Chunk chunk = level.getChunkIfLoaded(cx, cz);
        if (chunk == null) {
            return;
        }
        chunk.a(true);
        int sectionIndex = level.f(cy);
        if (sectionIndex < 0 || sectionIndex >= level.ak()) {
            return;
        }
        ChunkSection section = chunk.b(sectionIndex);
        boolean hasOnlyAir = section.c();
        HeightMap worldSurface = null;
        HeightMap oceanFloor = null;
        HeightMap motionBlocking = null;
        HeightMap motionBlockingNoLeaves = null;
        for (Map.Entry heightmap : chunk.e()) {
            switch ((HeightMap.Type)heightmap.getKey()) {
                case b: {
                    worldSurface = (HeightMap)heightmap.getValue();
                    break;
                }
                case d: {
                    oceanFloor = (HeightMap)heightmap.getValue();
                    break;
                }
                case e: {
                    motionBlocking = (HeightMap)heightmap.getValue();
                    break;
                }
                case f: {
                    motionBlockingNoLeaves = (HeightMap)heightmap.getValue();
                    break;
                }
            }
        }
        IBlockData old = section.a(x, y, z, blockState, true);
        if (blockState != old) {
            Block block = blockState.b();
            motionBlocking.a(x, by, z, blockState);
            motionBlockingNoLeaves.a(x, by, z, blockState);
            oceanFloor.a(x, by, z, blockState);
            worldSurface.a(x, by, z, blockState);
            if (blockState.t()) {
                TileEntity blockEntity = chunk.a(blockPos, Chunk.EnumTileEntityState.c);
                if (blockEntity == null) {
                    blockEntity = ((ITileEntity)block).a(blockPos, blockState);
                    if (blockEntity != null) {
                        chunk.b(blockEntity);
                    }
                } else if (blockEntity.u().a(blockState)) {
                    blockEntity.b(blockState);
                    AxiomReflection.updateBlockEntityTicker(chunk, blockEntity);
                } else {
                    chunk.d(blockPos);
                    blockEntity = ((ITileEntity)block).a(blockPos, blockState);
                    if (blockEntity != null) {
                        chunk.b(blockEntity);
                    }
                }
            } else if (old.t()) {
                chunk.d(blockPos);
            }
            level.k().a(blockPos);
            if (LightEngine.a((IBlockAccess)chunk, (BlockPosition)blockPos, (IBlockData)old, (IBlockData)blockState)) {
                level.k().a().a(blockPos);
            }
            Optional newPoi = PoiTypes.a((IBlockData)blockState);
            Optional oldPoi = PoiTypes.a((IBlockData)old);
            if (!Objects.equals(oldPoi, newPoi)) {
                if (oldPoi.isPresent()) {
                    level.w().a(blockPos);
                }
                if (newPoi.isPresent()) {
                    level.w().a(blockPos, (Holder)newPoi.get());
                }
            }
            if (CoreProtectIntegration.isEnabled()) {
                String changedBy = player.getBukkitEntity().getName();
                BlockPosition changedPos = new BlockPosition(bx, by, bz);
                CoreProtectIntegration.logRemoval(changedBy, old, world, changedPos);
                CoreProtectIntegration.logPlacement(changedBy, blockState, world, changedPos);
            }
        }
        if (hasOnlyAir != (nowHasOnlyAir = section.c())) {
            level.k().a().a(SectionPosition.a((int)cx, (int)cy, (int)cz), nowHasOnlyAir);
        }
    }

    private static boolean canBreakOrPlace(Player bukkitPlayer, IBlockData blockState, CraftWorld world, BlockPosition blockPos) {
        if (blockState == null) {
            return false;
        }
        if (!world.isChunkLoaded(blockPos.u() >> 4, blockPos.w() >> 4)) {
            return false;
        }
        if (blockState.i()) {
            return Integration.canBreakBlock(bukkitPlayer, world.getBlockAt(blockPos.u(), blockPos.v(), blockPos.w()));
        }
        return Integration.canPlaceBlock(bukkitPlayer, new Location((org.bukkit.World)world, (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w()));
    }

    public static class AxiomPlacingCraftBlockState
    extends CraftBlockState {
        public AxiomPlacingCraftBlockState(@Nullable org.bukkit.World world, BlockPosition blockPosition, IBlockData blockData) {
            super(world, blockPosition, blockData);
        }
    }
}

