/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet.impl;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.buffer.BiomeBuffer;
import com.moulberry.axiom.buffer.BlockBuffer;
import com.moulberry.axiom.integration.Integration;
import com.moulberry.axiom.operations.SetBlockBufferOperation;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.restrictions.AxiomPermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class SetBlockBufferPacketListener
implements PacketHandler {
    private final AxiomPaper plugin;

    public SetBlockBufferPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean handleAsync() {
        return true;
    }

    @Override
    public void onReceive(Player player, PacketDataSerializer friendlyByteBuf) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        MinecraftServer server = serverPlayer.cI();
        if (server == null) {
            return;
        }
        ResourceKey worldKey = friendlyByteBuf.a(Registries.aH);
        friendlyByteBuf.o();
        byte type = friendlyByteBuf.readByte();
        if (type == 0) {
            BlockBuffer buffer = BlockBuffer.load(friendlyByteBuf, this.plugin.getBlockRegistry(serverPlayer.ct()), (Player)serverPlayer.getBukkitEntity());
            int clientAvailableDispatchSends = friendlyByteBuf.m();
            this.applyBlockBuffer(serverPlayer, server, buffer, (ResourceKey<World>)worldKey, clientAvailableDispatchSends);
        } else if (type == 1) {
            BiomeBuffer buffer = BiomeBuffer.load(friendlyByteBuf);
            int clientAvailableDispatchSends = friendlyByteBuf.m();
            this.applyBiomeBuffer(serverPlayer, server, buffer, (ResourceKey<World>)worldKey, clientAvailableDispatchSends);
        } else {
            throw new RuntimeException("Unknown buffer type: " + type);
        }
    }

    private void applyBlockBuffer(EntityPlayer player, MinecraftServer server, BlockBuffer buffer, ResourceKey<World> worldKey, int clientAvailableDispatchSends) {
        server.execute(() -> {
            try {
                if (this.plugin.logLargeBlockBufferChanges()) {
                    this.plugin.getLogger().info("Player " + player.ct() + " modified " + buffer.getSectionCount() + " chunk sections (blocks)");
                    if (buffer.getTotalBlockEntities() > 0L) {
                        this.plugin.getLogger().info("Player " + player.ct() + " modified " + buffer.getTotalBlockEntities() + " block entities, compressed bytes = " + buffer.getTotalBlockEntityBytes());
                    }
                }
                if (!this.plugin.consumeDispatchSends((Player)player.getBukkitEntity(), buffer.getSectionCount(), clientAvailableDispatchSends)) {
                    return;
                }
                if (!this.plugin.canUseAxiom((Player)player.getBukkitEntity(), AxiomPermission.BUILD_SECTION)) {
                    return;
                }
                WorldServer world = player.x();
                if (!world.ac().equals(worldKey) || !this.plugin.canModifyWorld((Player)player.getBukkitEntity(), (org.bukkit.World)world.getWorld())) {
                    return;
                }
                boolean allowNbt = this.plugin.hasPermission((Player)player.getBukkitEntity(), AxiomPermission.BUILD_NBT);
                this.plugin.addPendingOperation(world, new SetBlockBufferOperation(player, buffer, allowNbt));
            }
            catch (Throwable t) {
                player.getBukkitEntity().kick((Component)Component.text((String)("An error occured while processing block change: " + t.getMessage())));
            }
        });
    }

    private void applyBiomeBuffer(EntityPlayer player, MinecraftServer server, BiomeBuffer biomeBuffer, ResourceKey<World> worldKey, int clientAvailableDispatchSends) {
        server.execute(() -> {
            try {
                if (this.plugin.logLargeBlockBufferChanges()) {
                    this.plugin.getLogger().info("Player " + player.ct() + " modified " + biomeBuffer.getSectionCount() + " chunk sections (biomes)");
                }
                if (!this.plugin.consumeDispatchSends((Player)player.getBukkitEntity(), biomeBuffer.getSectionCount(), clientAvailableDispatchSends)) {
                    return;
                }
                if (!this.plugin.canUseAxiom((Player)player.getBukkitEntity(), AxiomPermission.BUILD_SECTION)) {
                    return;
                }
                WorldServer world = player.x();
                if (!world.ac().equals(worldKey) || !this.plugin.canModifyWorld((Player)player.getBukkitEntity(), (org.bukkit.World)world.getWorld())) {
                    return;
                }
                HashSet changedChunks = new HashSet();
                int minSection = world.al();
                int maxSection = world.am();
                Optional registryOptional = world.B_().c(Registries.ap);
                if (registryOptional.isEmpty()) {
                    return;
                }
                IRegistry registry = (IRegistry)registryOptional.get();
                biomeBuffer.forEachEntry((x, y, z, biome) -> {
                    int cy = y >> 2;
                    if (cy < minSection || cy >= maxSection) {
                        return;
                    }
                    Optional holder = registry.b(biome);
                    if (holder.isPresent()) {
                        Chunk chunk = (Chunk)world.a(x >> 2, z >> 2, ChunkStatus.n, false);
                        if (chunk == null) {
                            return;
                        }
                        ChunkSection section = chunk.b(cy - minSection);
                        DataPaletteBlock container = (DataPaletteBlock)section.i();
                        if (!Integration.canPlaceBlock((Player)player.getBukkitEntity(), new Location(player.getBukkitEntity().getWorld(), (double)((x << 2) + 1), (double)((y << 2) + 1), (double)((z << 2) + 1)))) {
                            return;
                        }
                        container.c(x & 3, y & 3, z & 3, (Object)((Holder)holder.get()));
                        changedChunks.add(chunk);
                    }
                });
                PlayerChunkMap chunkMap = world.k().a;
                HashMap<EntityPlayer, List> map = new HashMap<EntityPlayer, List>();
                for (Chunk chunk : changedChunks) {
                    chunk.a(true);
                    ChunkCoordIntPair chunkPos = chunk.f();
                    for (EntityPlayer serverPlayer2 : chunkMap.a(chunkPos, false)) {
                        map.computeIfAbsent(serverPlayer2, serverPlayer -> new ArrayList()).add(chunk);
                    }
                }
                map.forEach((serverPlayer, list) -> serverPlayer.c.a((Packet)ClientboundChunksBiomesPacket.a((List)list)));
            }
            catch (Throwable t) {
                player.getBukkitEntity().kick((Component)Component.text((String)("An error occured while processing biome change: " + t.getMessage())));
            }
        });
    }
}

