/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet.impl;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.integration.Integration;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.restrictions.AxiomPermission;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class RequestEntityDataPacketListener
implements PacketHandler {
    public static final MinecraftKey RESPONSE_ID = VersionHelper.createResourceLocation("axiom:response_entity_data");
    private final AxiomPaper plugin;

    public RequestEntityDataPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onReceive(Player bukkitPlayer, PacketDataSerializer friendlyByteBuf) {
        EntityPlayer player = ((CraftPlayer)bukkitPlayer).getHandle();
        long id = friendlyByteBuf.readLong();
        if (!this.plugin.canUseAxiom(bukkitPlayer, AxiomPermission.ENTITY_REQUESTDATA) || this.plugin.isMismatchedDataVersion(bukkitPlayer.getUniqueId())) {
            RequestEntityDataPacketListener.sendResponse(player, id, true, Map.of());
            return;
        }
        if (!this.plugin.canModifyWorld(bukkitPlayer, bukkitPlayer.getWorld())) {
            RequestEntityDataPacketListener.sendResponse(player, id, true, Map.of());
            return;
        }
        List request = (List)friendlyByteBuf.a(this.plugin.limitCollection(ArrayList::new), buf -> buf.o());
        WorldServer serverLevel = player.x();
        int maxPacketSize = 0x100000;
        int remainingBytes = 0x100000;
        HashMap<UUID, NBTTagCompound> entityData = new HashMap<UUID, NBTTagCompound>();
        HashSet<UUID> visitedEntities = new HashSet<UUID>();
        for (UUID uuid : request) {
            NBTTagCompound entityTag;
            Entity entity;
            if (!visitedEntities.add(uuid) || (entity = serverLevel.a(uuid)) == null || entity instanceof EntityHuman || !this.plugin.canEntityBeManipulated(entity.ae()) || !Integration.canPlaceBlock(bukkitPlayer, new Location(bukkitPlayer.getWorld(), (double)entity.dm(), (double)entity.do(), (double)entity.ds())) || !entity.e(entityTag = new NBTTagCompound())) continue;
            int size = entityTag.a();
            if (size >= 0x100000) {
                RequestEntityDataPacketListener.sendResponse(player, id, false, Map.of(uuid, entityTag));
                continue;
            }
            if (remainingBytes - size < 0) {
                RequestEntityDataPacketListener.sendResponse(player, id, false, entityData);
                entityData.clear();
                remainingBytes = 0x100000;
            }
            entityData.put(uuid, entityTag);
            remainingBytes -= size;
        }
        RequestEntityDataPacketListener.sendResponse(player, id, true, entityData);
    }

    private static void sendResponse(EntityPlayer player, long id, boolean finished, Map<UUID, NBTTagCompound> map) {
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
        friendlyByteBuf.writeLong(id);
        friendlyByteBuf.writeBoolean(finished);
        friendlyByteBuf.a(map, (buf, uuid) -> buf.a(uuid), (buf, nbt) -> buf.a(nbt));
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)friendlyByteBuf);
        VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
    }
}

