/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet.impl;

import com.moulberry.axiom.AxiomConstants;
import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.buffer.CompressedBlockEntity;
import com.moulberry.axiom.operations.RequestChunksOperation;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.restrictions.AxiomPermission;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class RequestChunkDataPacketListener
implements PacketHandler {
    private static final MinecraftKey RESPONSE_ID = VersionHelper.createResourceLocation("axiom:response_chunk_data");
    private final AxiomPaper plugin;

    public RequestChunkDataPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onReceive(Player bukkitPlayer, PacketDataSerializer friendlyByteBuf) {
        EntityPlayer player = ((CraftPlayer)bukkitPlayer).getHandle();
        long id = friendlyByteBuf.readLong();
        if (!this.plugin.canUseAxiom(bukkitPlayer, AxiomPermission.CHUNK_REQUEST) || this.plugin.isMismatchedDataVersion(bukkitPlayer.getUniqueId())) {
            this.sendEmptyResponse(player, id);
            friendlyByteBuf.readerIndex(friendlyByteBuf.writerIndex());
            return;
        }
        if (!this.plugin.canModifyWorld(bukkitPlayer, bukkitPlayer.getWorld())) {
            this.sendEmptyResponse(player, id);
            friendlyByteBuf.readerIndex(friendlyByteBuf.writerIndex());
            return;
        }
        MinecraftServer server = player.cI();
        if (server == null) {
            this.sendEmptyResponse(player, id);
            friendlyByteBuf.readerIndex(friendlyByteBuf.writerIndex());
            return;
        }
        ResourceKey worldKey = friendlyByteBuf.a(Registries.aH);
        WorldServer level = server.a(worldKey);
        if (level == null || level != player.x()) {
            this.sendEmptyResponse(player, id);
            friendlyByteBuf.readerIndex(friendlyByteBuf.writerIndex());
            return;
        }
        boolean shouldSendBlockEntities = this.plugin.hasPermission(bukkitPlayer, AxiomPermission.CHUNK_REQUESTBLOCKENTITY);
        boolean sendBlockEntitiesInChunks = friendlyByteBuf.readBoolean() && shouldSendBlockEntities;
        int maxChunkLoadDistance = this.plugin.getMaxChunkLoadDistance((World)level.getWorld());
        if (!shouldSendBlockEntities && maxChunkLoadDistance <= 0) {
            this.sendEmptyResponse(player, id);
            friendlyByteBuf.readerIndex(friendlyByteBuf.writerIndex());
            return;
        }
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        int playerSectionX = player.dm() >> 4;
        int playerSectionZ = player.ds() >> 4;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Long2ObjectOpenHashMap sendingSections = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap sendingBlockEntities = new Long2ObjectOpenHashMap();
        LongOpenHashSet chunkFutures = new LongOpenHashSet();
        Long2ObjectOpenHashMap sendBlockEntityForPendingChunks = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap sendSectionsForPendingChunks = new Long2ObjectOpenHashMap();
        int blockEntityCount = friendlyByteBuf.m();
        if (!shouldSendBlockEntities) {
            friendlyByteBuf.skipBytes(8 * blockEntityCount);
        } else {
            for (int i = 0; i < blockEntityCount; ++i) {
                boolean canLoad;
                long pos = friendlyByteBuf.readLong();
                mutableBlockPos.f(pos);
                if (level.r((BlockPosition)mutableBlockPos)) continue;
                int chunkX = mutableBlockPos.u() >> 4;
                int chunkZ = mutableBlockPos.w() >> 4;
                int distance = Math.abs(playerSectionX - chunkX) + Math.abs(playerSectionZ - chunkZ);
                boolean bl = canLoad = distance < maxChunkLoadDistance;
                if (!canLoad) {
                    TileEntity blockEntity;
                    Chunk chunk = level.getChunkIfLoaded(chunkX, chunkZ);
                    if (chunk == null || (blockEntity = chunk.a((BlockPosition)mutableBlockPos, Chunk.EnumTileEntityState.c)) == null) continue;
                    NBTTagCompound tag = blockEntity.o();
                    sendingBlockEntities.put(pos, (Object)CompressedBlockEntity.compress(tag, baos));
                    continue;
                }
                long chunkPosLong = ChunkCoordIntPair.c((int)chunkX, (int)chunkZ);
                LongList blockEntitiesInChunk = (LongList)sendBlockEntityForPendingChunks.get(chunkPosLong);
                if (blockEntitiesInChunk != null) {
                    blockEntitiesInChunk.add(pos);
                    continue;
                }
                chunkFutures.add(ChunkCoordIntPair.c((int)chunkX, (int)chunkZ));
                blockEntitiesInChunk = new LongArrayList();
                blockEntitiesInChunk.add(pos);
                sendBlockEntityForPendingChunks.put(chunkPosLong, (Object)blockEntitiesInChunk);
            }
        }
        int chunkCount = friendlyByteBuf.m();
        if (maxChunkLoadDistance <= 0) {
            friendlyByteBuf.skipBytes(8 * chunkCount);
        } else {
            for (int i = 0; i < chunkCount; ++i) {
                boolean canLoad;
                long pos = friendlyByteBuf.readLong();
                int sx = BlockPosition.a((long)pos);
                int sy = BlockPosition.b((long)pos);
                int sz = BlockPosition.c((long)pos);
                int distance = Math.abs(playerSectionX - sx) + Math.abs(playerSectionZ - sz);
                boolean bl = canLoad = distance < maxChunkLoadDistance;
                if (!canLoad) {
                    ObjectIterator iterator;
                    int sectionIndex;
                    Chunk chunk = level.getChunkIfLoaded(sx, sz);
                    if (chunk == null || (sectionIndex = chunk.f(sy)) < 0 || sectionIndex >= chunk.ak()) continue;
                    ChunkSection section = chunk.b(sectionIndex);
                    if (section.c()) {
                        sendingSections.put(pos, null);
                        continue;
                    }
                    DataPaletteBlock container = section.h();
                    sendingSections.put(pos, (Object)container);
                    if (!sendBlockEntitiesInChunks) continue;
                    Set entrySet = chunk.k.entrySet();
                    if (entrySet instanceof Object2ObjectMap.FastEntrySet) {
                        Object2ObjectMap.FastEntrySet fastEntrySet = (Object2ObjectMap.FastEntrySet)entrySet;
                        iterator = fastEntrySet.fastIterator();
                    } else {
                        iterator = entrySet.iterator();
                    }
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        BlockPosition blockPos = (BlockPosition)entry.getKey();
                        int sectionY = blockPos.v() >> 4;
                        if (sectionY != sy) continue;
                        NBTTagCompound tag = ((TileEntity)entry.getValue()).o();
                        sendingBlockEntities.put(blockPos.a(), (Object)CompressedBlockEntity.compress(tag, baos));
                    }
                    continue;
                }
                long chunkPosLong = ChunkCoordIntPair.c((int)sx, (int)sz);
                IntList sendSections = (IntList)sendSectionsForPendingChunks.get(chunkPosLong);
                if (sendSections != null) {
                    sendSections.add(sy);
                    continue;
                }
                chunkFutures.add(ChunkCoordIntPair.c((int)sx, (int)sz));
                sendSections = new IntArrayList();
                sendSections.add(sy);
                sendSectionsForPendingChunks.put(chunkPosLong, (Object)sendSections);
            }
        }
        if (chunkFutures.isEmpty()) {
            RequestChunkDataPacketListener.sendResponse(player, id, (Long2ObjectOpenHashMap<CompressedBlockEntity>)sendingBlockEntities, (Long2ObjectOpenHashMap<DataPaletteBlock<IBlockData>>)sendingSections);
        } else {
            this.plugin.addPendingOperation(level, new RequestChunksOperation(player, id, (LongSet)chunkFutures, (Long2ObjectMap<LongList>)sendBlockEntityForPendingChunks, (Long2ObjectMap<IntList>)sendSectionsForPendingChunks, sendBlockEntitiesInChunks, (Long2ObjectOpenHashMap<DataPaletteBlock<IBlockData>>)sendingSections, (Long2ObjectOpenHashMap<CompressedBlockEntity>)sendingBlockEntities, baos));
        }
    }

    public static void sendResponse(EntityPlayer player, long id, Long2ObjectOpenHashMap<CompressedBlockEntity> sendingBlockEntities, Long2ObjectOpenHashMap<DataPaletteBlock<IBlockData>> sendingSections) {
        boolean firstPart = true;
        int maxSize = 1048512;
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.writeLong(id);
        ObjectIterator blockEntityIterator = sendingBlockEntities.long2ObjectEntrySet().fastIterator();
        while (blockEntityIterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)blockEntityIterator.next();
            int beforeWriterIndex = buf.writerIndex();
            buf.writeLong(entry.getLongKey());
            ((CompressedBlockEntity)entry.getValue()).write(buf);
            if (buf.writerIndex() >= maxSize) {
                if (firstPart) {
                    buf.writeLong(AxiomConstants.MIN_POSITION_LONG);
                    buf.writeLong(AxiomConstants.MIN_POSITION_LONG);
                    buf.writeBoolean(false);
                    byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
                    VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
                    buf.clear();
                    buf.writeLong(id);
                    continue;
                }
                int copiedSize = buf.writerIndex() - beforeWriterIndex;
                byte[] copied = new byte[copiedSize];
                buf.getBytes(beforeWriterIndex, copied);
                buf.writerIndex(beforeWriterIndex);
                buf.writeLong(AxiomConstants.MIN_POSITION_LONG);
                buf.writeLong(AxiomConstants.MIN_POSITION_LONG);
                buf.writeBoolean(false);
                byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
                VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
                buf.clear();
                buf.writeLong(id);
                buf.writeBytes(copied);
                firstPart = true;
                continue;
            }
            firstPart = false;
        }
        buf.writeLong(AxiomConstants.MIN_POSITION_LONG);
        ObjectIterator sectionIterator = sendingSections.long2ObjectEntrySet().fastIterator();
        while (sectionIterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)sectionIterator.next();
            int beforeWriterIndex = buf.writerIndex();
            buf.writeLong(entry.getLongKey());
            DataPaletteBlock container = (DataPaletteBlock)entry.getValue();
            if (container == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                ((DataPaletteBlock)entry.getValue()).b(buf);
            }
            if (buf.writerIndex() >= maxSize) {
                if (firstPart) {
                    buf.writeLong(AxiomConstants.MIN_POSITION_LONG);
                    buf.writeBoolean(false);
                    byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
                    VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
                    buf.clear();
                    buf.writeLong(id);
                    buf.writeLong(AxiomConstants.MIN_POSITION_LONG);
                    continue;
                }
                int copiedSize = buf.writerIndex() - beforeWriterIndex;
                byte[] copied = new byte[copiedSize];
                buf.getBytes(beforeWriterIndex, copied);
                buf.writerIndex(beforeWriterIndex);
                buf.writeLong(AxiomConstants.MIN_POSITION_LONG);
                buf.writeBoolean(false);
                byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
                VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
                buf.clear();
                buf.writeLong(id);
                buf.writeLong(AxiomConstants.MIN_POSITION_LONG);
                buf.writeBytes(copied);
                firstPart = true;
                continue;
            }
            firstPart = false;
        }
        buf.writeLong(AxiomConstants.MIN_POSITION_LONG);
        buf.writeBoolean(true);
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
        VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
    }

    private void sendEmptyResponse(EntityPlayer player, long id) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer((int)16));
        buf.writeLong(id);
        buf.writeLong(AxiomConstants.MIN_POSITION_LONG);
        buf.writeLong(AxiomConstants.MIN_POSITION_LONG);
        buf.writeBoolean(true);
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
        VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
    }
}

