/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet.impl;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.NbtSanitization;
import com.moulberry.axiom.event.AxiomAfterManipulateEntityEvent;
import com.moulberry.axiom.event.AxiomManipulateEntityEvent;
import com.moulberry.axiom.integration.Integration;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.viaversion.UnknownVersionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class ManipulateEntityPacketListener
implements PacketHandler {
    private final AxiomPaper plugin;
    private static final EnumBlockRotation[] ROTATION_VALUES = EnumBlockRotation.values();

    public ManipulateEntityPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onReceive(Player player, PacketDataSerializer friendlyByteBuf) {
        if (!this.plugin.canUseAxiom(player, AxiomPermission.ENTITY_MANIPULATE)) {
            return;
        }
        if (!this.plugin.canModifyWorld(player, player.getWorld())) {
            return;
        }
        List entries = (List)friendlyByteBuf.a(this.plugin.limitCollection(ArrayList::new), buf -> ManipulateEntry.read(buf, player, this.plugin));
        WorldServer serverLevel = ((CraftWorld)player.getWorld()).getHandle();
        for (ManipulateEntry entry : entries) {
            AxiomManipulateEntityEvent manipulateEvent;
            net.minecraft.world.entity.Entity entity = serverLevel.a(entry.uuid);
            if (entity == null || entity instanceof EntityHuman || entity.a(ManipulateEntityPacketListener::isPlayer) || !this.plugin.canEntityBeManipulated(entity.ae())) continue;
            Vec3D position = entity.dg();
            BlockPosition containing = BlockPosition.a((double)position.c, (double)position.d, (double)position.e);
            if (!Integration.canPlaceBlock(player, new Location(player.getWorld(), (double)containing.u(), (double)containing.v(), (double)containing.w())) || !(manipulateEvent = new AxiomManipulateEntityEvent(player, (Entity)entity.getBukkitEntity())).callEvent()) continue;
            if (entry.merge != null && !entry.merge.g()) {
                NbtSanitization.sanitizeEntity(entry.merge);
                NBTTagCompound compoundTag = entity.f(new NBTTagCompound());
                compoundTag = ManipulateEntityPacketListener.merge(compoundTag, entry.merge);
                entity.g(compoundTag);
            }
            entity.p(position.c, position.d, position.e);
            Vec3D entryPos = entry.position();
            if (entryPos != null && entry.relativeMovementSet != null) {
                float newPitch;
                double newX = entry.relativeMovementSet.contains(RelativeMovement.a) ? entity.dg().c + entryPos.c : entryPos.c;
                double newY = entry.relativeMovementSet.contains(RelativeMovement.b) ? entity.dg().d + entryPos.d : entryPos.d;
                double newZ = entry.relativeMovementSet.contains(RelativeMovement.c) ? entity.dg().e + entryPos.e : entryPos.e;
                float newYaw = entry.relativeMovementSet.contains(RelativeMovement.d) ? entity.dy() + entry.yaw : entry.yaw;
                float f = newPitch = entry.relativeMovementSet.contains(RelativeMovement.e) ? entity.dA() + entry.pitch : entry.pitch;
                if (entity instanceof EntityHanging) {
                    EntityItemFrame itemFrame;
                    EntityHanging hangingEntity = (EntityHanging)entity;
                    float changedYaw = newYaw - entity.dy();
                    int rotations = Math.round(changedYaw / 90.0f);
                    hangingEntity.a(ROTATION_VALUES[rotations & 3]);
                    if (entity instanceof EntityItemFrame && (itemFrame = (EntityItemFrame)entity).cB().o() == EnumDirection.EnumAxis.b) {
                        itemFrame.b(itemFrame.D() - Math.round(changedYaw / 45.0f));
                    }
                }
                containing = BlockPosition.a((double)newX, (double)newY, (double)newZ);
                if (Integration.canPlaceBlock(player, new Location(player.getWorld(), (double)containing.u(), (double)containing.v(), (double)containing.w()))) {
                    entity.a(serverLevel, newX, newY, newZ, Set.of(), newYaw, newPitch);
                }
                entity.n(newYaw);
            }
            if (ManipulateEntityPacketListener.canManipulatePassengers(entity)) {
                switch (entry.passengerManipulation) {
                    case NONE: {
                        break;
                    }
                    case REMOVE_ALL: {
                        entity.bz();
                        break;
                    }
                    case ADD_LIST: {
                        for (UUID passengerUuid : entry.passengers) {
                            net.minecraft.world.entity.Entity passenger = serverLevel.a(passengerUuid);
                            if (passenger == null || passenger.bM() || !ManipulateEntityPacketListener.canManipulatePassengers(passenger) || passenger.a(ManipulateEntityPacketListener::cannotManipulatePassengers) || !this.plugin.canEntityBeManipulated(passenger.ae()) || passenger.cP().anyMatch(entity2 -> entity2 == entity)) continue;
                            position = passenger.dg();
                            containing = BlockPosition.a((double)position.c, (double)position.d, (double)position.e);
                            if (!Integration.canPlaceBlock(player, new Location(player.getWorld(), (double)containing.u(), (double)containing.v(), (double)containing.w()))) continue;
                            passenger.a(entity, true);
                        }
                        break;
                    }
                    case REMOVE_LIST: {
                        for (UUID passengerUuid : entry.passengers) {
                            net.minecraft.world.entity.Entity vehicle;
                            net.minecraft.world.entity.Entity passenger = serverLevel.a(passengerUuid);
                            if (passenger == null || passenger == entity || !ManipulateEntityPacketListener.canManipulatePassengers(passenger) || passenger.a(ManipulateEntityPacketListener::cannotManipulatePassengers) || !this.plugin.canEntityBeManipulated(passenger.ae()) || (vehicle = passenger.cW()) != entity) continue;
                            passenger.Y();
                        }
                        break;
                    }
                }
            }
            AxiomAfterManipulateEntityEvent afterManipulateEvent = new AxiomAfterManipulateEntityEvent(player, (Entity)entity.getBukkitEntity());
            afterManipulateEvent.callEvent();
        }
    }

    private static NBTTagCompound merge(NBTTagCompound left, NBTTagCompound right) {
        if (right.e("axiom:modify")) {
            right.r("axiom:modify");
            return right;
        }
        for (String key : right.e()) {
            NBTBase tag = right.c(key);
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compound = (NBTTagCompound)tag;
                if (compound.g()) {
                    left.r(key);
                    continue;
                }
                if (left.b(key, 10)) {
                    NBTTagCompound child = left.p(key);
                    child = ManipulateEntityPacketListener.merge(child, compound);
                    left.a(key, (NBTBase)child);
                    continue;
                }
                NBTTagCompound copied = compound.h();
                if (copied.e("axiom:modify")) {
                    copied.r("axiom:modify");
                }
                left.a(key, (NBTBase)copied);
                continue;
            }
            left.a(key, tag.d());
        }
        return left;
    }

    private static boolean canManipulatePassengers(net.minecraft.world.entity.Entity entity) {
        return entity != null && entity.ae().b() && !(entity instanceof EntityHuman) && !(entity instanceof Marker);
    }

    private static boolean cannotManipulatePassengers(net.minecraft.world.entity.Entity entity) {
        return !ManipulateEntityPacketListener.canManipulatePassengers(entity);
    }

    private static boolean isPlayer(net.minecraft.world.entity.Entity entity) {
        return entity instanceof EntityHuman;
    }

    public record ManipulateEntry(UUID uuid, @Nullable Set<RelativeMovement> relativeMovementSet, @Nullable Vec3D position, float yaw, float pitch, NBTTagCompound merge, PassengerManipulation passengerManipulation, List<UUID> passengers) {
        public static ManipulateEntry read(PacketDataSerializer friendlyByteBuf, Player player, AxiomPaper plugin) {
            UUID uuid = friendlyByteBuf.o();
            byte flags = friendlyByteBuf.readByte();
            Set relativeMovementSet = null;
            Vec3D position = null;
            float yaw = 0.0f;
            float pitch = 0.0f;
            if (flags >= 0) {
                relativeMovementSet = RelativeMovement.a((int)flags);
                position = new Vec3D(friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble());
                yaw = friendlyByteBuf.readFloat();
                pitch = friendlyByteBuf.readFloat();
            }
            NBTTagCompound nbt = UnknownVersionHelper.readTagUnknown(friendlyByteBuf, player);
            PassengerManipulation passengerManipulation = (PassengerManipulation)friendlyByteBuf.b(PassengerManipulation.class);
            List passengers = List.of();
            if (passengerManipulation == PassengerManipulation.ADD_LIST || passengerManipulation == PassengerManipulation.REMOVE_LIST) {
                passengers = (List)friendlyByteBuf.a(plugin.limitCollection(ArrayList::new), PacketDataSerializer::o);
            }
            return new ManipulateEntry(uuid, relativeMovementSet, position, yaw, pitch, nbt, passengerManipulation, passengers);
        }
    }

    public static enum PassengerManipulation {
        NONE,
        REMOVE_ALL,
        ADD_LIST,
        REMOVE_LIST;

    }
}

