/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet.impl;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.ServerHeightmaps;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.WorldExtension;
import com.moulberry.axiom.blueprint.ServerBlueprintManager;
import com.moulberry.axiom.event.AxiomHandshakeEvent;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.paperapi.block.ImplServerCustomBlocks;
import com.moulberry.axiom.paperapi.display.ImplServerCustomDisplays;
import com.moulberry.axiom.paperapi.entity.ImplAxiomHiddenEntities;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.viaversion.ViaVersionHelper;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertiesRegistry;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.SharedConstants;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class HelloPacketListener
implements PacketHandler {
    private final AxiomPaper plugin;

    public HelloPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onReceive(Player player, PacketDataSerializer friendlyByteBuf) {
        if (!this.plugin.hasPermission(player, AxiomPermission.USE)) {
            this.plugin.failedPermissionAxiomPlayers.add(player.getUniqueId());
            return;
        }
        int apiVersion = friendlyByteBuf.m();
        if (apiVersion != 9) {
            String versions = " (C=" + apiVersion + " S=9)";
            TextComponent text = apiVersion < 9 ? Component.text((String)("Unable to use Axiom, you're on an outdated version! Please update to the latest version of Axiom to use it on this server." + versions)) : Component.text((String)("Unable to use Axiom, server hasn't updated Axiom yet." + versions));
            String unsupportedAxiomVersion = this.plugin.configuration.getString("unsupported-axiom-version");
            if (unsupportedAxiomVersion == null) {
                unsupportedAxiomVersion = "kick";
            }
            if (unsupportedAxiomVersion.equals("warn")) {
                player.sendMessage(text.color((TextColor)NamedTextColor.RED));
                return;
            }
            if (!unsupportedAxiomVersion.equals("ignore")) {
                player.kick((Component)text);
                return;
            }
        }
        int dataVersion = friendlyByteBuf.m();
        int protocolVersion = friendlyByteBuf.m();
        int serverDataVersion = SharedConstants.b().d().c();
        if (protocolVersion != SharedConstants.c()) {
            String incompatibleDataVersion = this.plugin.configuration.getString("incompatible-data-version");
            if (incompatibleDataVersion == null) {
                incompatibleDataVersion = "warn";
            }
            TextComponent incompatibleWarning = Component.text((String)("Axiom: Incompatible data version detected (client " + dataVersion + ", server " + serverDataVersion + ")"));
            if (!Bukkit.getPluginManager().isPluginEnabled("ViaVersion")) {
                if (incompatibleDataVersion.equals("warn")) {
                    player.sendMessage(incompatibleWarning.color((TextColor)NamedTextColor.RED));
                    return;
                }
                if (!incompatibleDataVersion.equals("ignore")) {
                    player.kick((Component)incompatibleWarning);
                    return;
                }
            } else {
                RegistryBlockID<IBlockData> mapper;
                try {
                    mapper = ViaVersionHelper.getBlockRegistryForVersion(this.plugin.allowedBlockRegistry, protocolVersion);
                }
                catch (Exception e) {
                    String clientDescription = "client: " + ProtocolVersion.getProtocol((int)protocolVersion);
                    String serverDescription = "server: " + ProtocolVersion.getProtocol((int)SharedConstants.c());
                    String description = clientDescription + " <-> " + serverDescription;
                    TextComponent text = Component.text((String)("Axiom+ViaVersion: " + e.getMessage() + " (" + description + ")"));
                    if (incompatibleDataVersion.equals("warn")) {
                        player.sendMessage(text.color((TextColor)NamedTextColor.RED));
                    } else {
                        player.kick((Component)text);
                    }
                    return;
                }
                this.plugin.playerBlockRegistry.put(player.getUniqueId(), mapper);
                this.plugin.playerProtocolVersion.put(player.getUniqueId(), protocolVersion);
                TextComponent text = Component.text((String)"Axiom: Warning, client and server versions don't match. Axiom will try to use ViaVersion conversions, but this process may cause problems");
                player.sendMessage(text.color((TextColor)NamedTextColor.RED));
            }
        }
        int maxBufferSize = this.plugin.configuration.getInt("max-block-buffer-packet-size");
        AxiomHandshakeEvent handshakeEvent = new AxiomHandshakeEvent(player, maxBufferSize);
        Bukkit.getPluginManager().callEvent((Event)handshakeEvent);
        if (handshakeEvent.isCancelled()) {
            return;
        }
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.writeBoolean(true);
        buf.writeInt(handshakeEvent.getMaxBufferSize());
        buf.d(2);
        buf.d(0);
        buf.d(0);
        byte[] enableBytes = ByteBufUtil.getBytes((ByteBuf)buf);
        VersionHelper.sendCustomPayload(player, "axiom:enable", enableBytes);
        this.plugin.onAxiomActive(player);
        World world = player.getWorld();
        ServerWorldPropertiesRegistry properties = this.plugin.getOrCreateWorldProperties(world);
        if (properties == null) {
            VersionHelper.sendCustomPayload(player, "axiom:register_world_properties", new byte[]{0});
        } else {
            properties.registerFor((Plugin)this.plugin, player);
        }
        WorldExtension.onPlayerJoin(world, player);
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        ServerBlueprintManager.sendManifest(List.of(serverPlayer));
        ServerHeightmaps.sendTo(player);
        ImplServerCustomBlocks.sendAll(serverPlayer);
        ImplServerCustomDisplays.sendAll(serverPlayer);
        ImplAxiomHiddenEntities.sendAll(List.of(serverPlayer));
        if (!player.isOp() && !player.hasPermission("*") && player.hasPermission("axiom.*")) {
            TextComponent text = Component.text((String)"Axiom: Using deprecated axiom.* permission. Please switch to axiom.default for public servers, or axiom.all for private servers");
            player.sendMessage(text.color((TextColor)NamedTextColor.YELLOW));
        }
        if (player.isOp() && (this.plugin.configAddedEntries != 0 || this.plugin.configRemovedEntries != 0)) {
            StringBuilder builder = new StringBuilder("Axiom: Plugin config is outdated (");
            if (this.plugin.configAddedEntries != 0) {
                builder.append(this.plugin.configAddedEntries).append(" new entries");
            }
            if (this.plugin.configRemovedEntries != 0) {
                if (this.plugin.configAddedEntries != 0) {
                    builder.append(", ");
                }
                builder.append(this.plugin.configRemovedEntries).append(" removed entries");
            }
            builder.append(")");
            TextComponent text = Component.text((String)builder.toString());
            player.sendMessage(text.color((TextColor)NamedTextColor.YELLOW));
            Component click = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"CLICK HERE").color((TextColor)NamedTextColor.GREEN)).decorate(TextDecoration.BOLD)).hoverEvent((HoverEventSource)Component.text((String)"/axiompapermigrateconfig"))).clickEvent(ClickEvent.runCommand((String)"axiompapermigrateconfig"));
            player.sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append(click)).append(Component.text((String)" to migrate the config").color((TextColor)NamedTextColor.YELLOW)));
        }
    }
}

