/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet.impl;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.blueprint.RawBlueprint;
import com.moulberry.axiom.blueprint.ServerBlueprintManager;
import com.moulberry.axiom.blueprint.ServerBlueprintRegistry;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.restrictions.AxiomPermission;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import net.kyori.adventure.text.Component;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class BlueprintRequestPacketListener
implements PacketHandler {
    private final AxiomPaper plugin;
    private static final MinecraftKey RESPONSE_PACKET_IDENTIFIER = VersionHelper.createResourceLocation("axiom:response_blueprint");

    public BlueprintRequestPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onReceive(Player player, PacketDataSerializer friendlyByteBuf) {
        if (!this.plugin.canUseAxiom(player, AxiomPermission.BLUEPRINT_REQUEST)) {
            return;
        }
        if (this.plugin.isMismatchedDataVersion(player.getUniqueId())) {
            player.sendMessage((Component)Component.text((String)"Axiom+ViaVersion: This feature isn't supported. Switch your client version to 1.20.1 to use this"));
            return;
        }
        String path = friendlyByteBuf.s();
        ServerBlueprintRegistry registry = ServerBlueprintManager.getRegistry();
        if (registry == null) {
            return;
        }
        RawBlueprint rawBlueprint = registry.blueprints().get(path);
        if (rawBlueprint != null) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.a(path);
            RawBlueprint.write(buf, rawBlueprint);
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
            VersionHelper.sendCustomPayload(((CraftPlayer)player).getHandle(), RESPONSE_PACKET_IDENTIFIER, bytes);
        }
    }
}

