/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.packet.PacketHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.papermc.paper.network.ConnectionEvent;
import java.util.List;
import java.util.Map;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerKickEvent;

public class AxiomBigPayloadHandler
extends MessageToMessageDecoder<ByteBuf> {
    private final int payloadId;
    private final NetworkManager connection;
    private final Map<String, PacketHandler> packetHandlers;
    private boolean handleUserEvents;

    public AxiomBigPayloadHandler(int payloadId, NetworkManager connection, Map<String, PacketHandler> packetHandlers, boolean handleUserEvents) {
        this.payloadId = payloadId;
        this.connection = connection;
        this.packetHandlers = packetHandlers;
        this.handleUserEvents = handleUserEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() == 0 || !ctx.channel().isActive()) {
            out.add(in.retain());
            return;
        }
        EntityPlayer player = this.connection.getPlayer();
        if (player == null || player.t() || !AxiomPaper.PLUGIN.canUseAxiom((Player)player.getBukkitEntity())) {
            out.add(in.retain());
            return;
        }
        int readerIndex = in.readerIndex();
        boolean success = false;
        boolean allowIndexOutOfBounds = true;
        try {
            PacketDataSerializer buf = new PacketDataSerializer(in);
            int packetId = buf.m();
            if (packetId == this.payloadId) {
                String identifier = buf.e(Short.MAX_VALUE);
                allowIndexOutOfBounds = false;
                PacketHandler handler = this.packetHandlers.get(identifier);
                if (handler != null) {
                    if (handler.handleAsync()) {
                        AxiomBigPayloadHandler.callReceive(handler, player, buf, identifier);
                    } else {
                        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
                        player.cI().execute(() -> {
                            PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])bytes));
                            AxiomBigPayloadHandler.callReceive(handler, player, friendlyByteBuf, identifier);
                        });
                    }
                    success = true;
                    in.readerIndex(in.writerIndex());
                    return;
                }
            }
        }
        catch (Throwable t) {
            if (!(t instanceof IndexOutOfBoundsException) || !allowIndexOutOfBounds) {
                success = true;
                in.skipBytes(in.readableBytes());
                throw t;
            }
        }
        finally {
            if (!success) {
                in.readerIndex(readerIndex);
            }
        }
        out.add(in.retain());
    }

    private static void callReceive(PacketHandler handler, EntityPlayer player, PacketDataSerializer friendlyByteBuf, String identifier) {
        if (player.t()) {
            return;
        }
        try {
            handler.onReceive((Player)player.getBukkitEntity(), friendlyByteBuf);
        }
        catch (Throwable t) {
            player.d.execute(() -> player.c.disconnect((IChatBaseComponent)IChatBaseComponent.b((String)("Error while processing Axiom packet " + identifier + ": " + t.getMessage())), PlayerKickEvent.Cause.UNKNOWN));
            player.c.h.l();
        }
    }

    public static void apply(ChannelPipeline pipeline, AxiomBigPayloadHandler handler) {
        if (pipeline.get("axiom-big-payload-handler") != null) {
            pipeline.remove("axiom-big-payload-handler");
        }
        pipeline.addBefore("decoder", "axiom-big-payload-handler", (ChannelHandler)handler);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (this.handleUserEvents && (evt == ConnectionEvent.COMPRESSION_THRESHOLD_SET || evt == ConnectionEvent.COMPRESSION_DISABLED)) {
            AxiomBigPayloadHandler handler = new AxiomBigPayloadHandler(this.payloadId, this.connection, this.packetHandlers, false);
            AxiomBigPayloadHandler.apply(ctx.pipeline(), handler);
            super.userEventTriggered(ctx, evt);
            handler.handleUserEvents = true;
            return;
        }
        super.userEventTriggered(ctx, evt);
    }
}

