/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.AxiomReflection;
import com.moulberry.axiom.WorldExtension;
import com.moulberry.axiom.buffer.BlockBuffer;
import com.moulberry.axiom.buffer.CompressedBlockEntity;
import com.moulberry.axiom.integration.Integration;
import com.moulberry.axiom.integration.SectionPermissionChecker;
import com.moulberry.axiom.integration.coreprotect.CoreProtectIntegration;
import com.moulberry.axiom.operations.PendingOperation;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongComparators;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LightEngine;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftChunk;
import org.bukkit.entity.Player;

public class SetBlockBufferOperation
implements PendingOperation {
    private static final int MAX_CHUNK_FUTURES = 256;
    private final EntityPlayer player;
    private final BlockBuffer buffer;
    private final boolean allowNbt;
    private Long2ObjectOpenHashMap<List<Long2ObjectMap.Entry<DataPaletteBlock<IBlockData>>>> sectionsForChunks = null;
    private LongArrayList getChunkFutures = null;
    private List<CompletableFuture<Chunk>> chunkFutures = new ArrayList<CompletableFuture<Chunk>>();
    private boolean sendGameMasterBlockWarning = false;
    private boolean finished = false;

    public SetBlockBufferOperation(EntityPlayer player, BlockBuffer buffer, boolean allowNbt) {
        this.player = player;
        this.buffer = buffer;
        this.allowNbt = allowNbt;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public EntityPlayer executor() {
        return this.player;
    }

    @Override
    public void tick(WorldServer level) {
        BlockPosition.MutableBlockPosition blockPos = new BlockPosition.MutableBlockPosition();
        WorldExtension extension = WorldExtension.get(level);
        IBlockData emptyState = BlockBuffer.EMPTY_STATE;
        if (this.sectionsForChunks == null) {
            this.sectionsForChunks = new Long2ObjectOpenHashMap();
            for (Long2ObjectMap.Entry entry : this.buffer.entrySet()) {
                long pos = entry.getLongKey();
                int posX = BlockPosition.a((long)pos);
                int posZ = BlockPosition.c((long)pos);
                long chunkPos = ChunkCoordIntPair.c((int)posX, (int)posZ);
                ((List)this.sectionsForChunks.computeIfAbsent(chunkPos, k -> new ArrayList())).add(entry);
            }
            this.getChunkFutures = new LongArrayList((LongCollection)this.sectionsForChunks.keySet());
            this.getChunkFutures.sort(LongComparators.NATURAL_COMPARATOR);
        }
        if (!this.getChunkFutures.isEmpty()) {
            int maxChunkLoadDistance = AxiomPaper.PLUGIN.getMaxChunkLoadDistance((World)level.getWorld());
            int playerSectionX = this.player.dm() >> 4;
            int playerSectionZ = this.player.ds() >> 4;
            LongIterator newFutureIterator = this.getChunkFutures.longIterator();
            while (this.chunkFutures.size() < 256 && newFutureIterator.hasNext()) {
                boolean canLoad;
                long chunkPos = newFutureIterator.nextLong();
                newFutureIterator.remove();
                int x = ChunkCoordIntPair.a((long)chunkPos);
                int z = ChunkCoordIntPair.b((long)chunkPos);
                int distance = Math.abs(playerSectionX - x) + Math.abs(playerSectionZ - z);
                boolean bl = canLoad = distance < maxChunkLoadDistance;
                if (!canLoad) {
                    Chunk chunk2 = level.getChunkIfLoaded(x, z);
                    if (chunk2 == null) continue;
                    this.chunkFutures.add(CompletableFuture.completedFuture(chunk2));
                    continue;
                }
                this.chunkFutures.add((CompletableFuture<Chunk>)level.getWorld().getChunkAtAsync(x, z).thenApply(chunk -> (Chunk)((CraftChunk)chunk).getHandle(ChunkStatus.n)));
            }
        }
        Iterator<CompletableFuture<Chunk>> chunkFutureIterator = this.chunkFutures.iterator();
        while (chunkFutureIterator.hasNext()) {
            CompletableFuture<Chunk> future = chunkFutureIterator.next();
            if (!future.isDone()) {
                return;
            }
            chunkFutureIterator.remove();
            Chunk chunk3 = future.join();
            HeightMap worldSurface = null;
            HeightMap oceanFloor = null;
            HeightMap motionBlocking = null;
            HeightMap motionBlockingNoLeaves = null;
            for (Map.Entry heightmap : chunk3.e()) {
                switch ((HeightMap.Type)heightmap.getKey()) {
                    case b: {
                        worldSurface = (HeightMap)heightmap.getValue();
                        break;
                    }
                    case d: {
                        oceanFloor = (HeightMap)heightmap.getValue();
                        break;
                    }
                    case e: {
                        motionBlocking = (HeightMap)heightmap.getValue();
                        break;
                    }
                    case f: {
                        motionBlockingNoLeaves = (HeightMap)heightmap.getValue();
                        break;
                    }
                }
            }
            boolean chunkChanged = false;
            boolean chunkLightChanged = false;
            long chunkPosLong = ChunkCoordIntPair.c((int)chunk3.locX, (int)chunk3.locZ);
            List sections = (List)this.sectionsForChunks.get(chunkPosLong);
            for (Long2ObjectMap.Entry entry : sections) {
                SectionPermissionChecker checker;
                int cx = BlockPosition.a((long)entry.getLongKey());
                int cy = BlockPosition.b((long)entry.getLongKey());
                int cz = BlockPosition.c((long)entry.getLongKey());
                DataPaletteBlock container = (DataPaletteBlock)entry.getValue();
                if (cy < level.al() || cy >= level.am() || (checker = Integration.checkSection((Player)this.player.getBukkitEntity(), (World)level.getWorld(), cx, cy, cz)) != null && checker.noneAllowed()) continue;
                ChunkSection section = chunk3.b(level.f(cy));
                boolean hasOnlyAir = section.c();
                boolean containerMaybeHasPoi = container.a(PoiTypes::b);
                boolean sectionMaybeHasPoi = section.a(PoiTypes::b);
                Short2ObjectMap<CompressedBlockEntity> blockEntityChunkMap = this.allowNbt ? this.buffer.getBlockEntityChunkMap(entry.getLongKey()) : null;
                int minX = 0;
                int minY = 0;
                int minZ = 0;
                int maxX = 15;
                int maxY = 15;
                int maxZ = 15;
                if (checker != null) {
                    minX = checker.bounds().minX();
                    minY = checker.bounds().minY();
                    minZ = checker.bounds().minZ();
                    maxX = checker.bounds().maxX();
                    maxY = checker.bounds().maxY();
                    maxZ = checker.bounds().maxZ();
                    if (checker.allAllowed()) {
                        checker = null;
                    }
                }
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            IBlockData blockState = (IBlockData)container.a(x, y, z);
                            if (blockState == emptyState) continue;
                            int bx = cx * 16 + x;
                            int by = cy * 16 + y;
                            int bz = cz * 16 + z;
                            if (hasOnlyAir && blockState.i() || checker != null && !checker.allowed(x, y, z)) continue;
                            Block block = blockState.b();
                            IBlockData old = section.a(x, y, z, blockState, true);
                            if (blockState != old) {
                                Optional oldPoi;
                                chunkChanged = true;
                                blockPos.d(bx, by, bz);
                                motionBlocking.a(x, by, z, blockState);
                                motionBlockingNoLeaves.a(x, by, z, blockState);
                                oceanFloor.a(x, by, z, blockState);
                                worldSurface.a(x, by, z, blockState);
                                chunkLightChanged |= LightEngine.a((IBlockAccess)chunk3, (BlockPosition)blockPos, (IBlockData)old, (IBlockData)blockState);
                                Optional newPoi = containerMaybeHasPoi ? PoiTypes.a((IBlockData)blockState) : Optional.empty();
                                Optional optional = oldPoi = sectionMaybeHasPoi ? PoiTypes.a((IBlockData)old) : Optional.empty();
                                if (!Objects.equals(oldPoi, newPoi)) {
                                    if (oldPoi.isPresent()) {
                                        level.w().a((BlockPosition)blockPos);
                                    }
                                    if (newPoi.isPresent()) {
                                        level.w().a((BlockPosition)blockPos, (Holder)newPoi.get());
                                    }
                                }
                            }
                            if (blockState.t()) {
                                blockPos.d(bx, by, bz);
                                TileEntity blockEntity = chunk3.a((BlockPosition)blockPos, Chunk.EnumTileEntityState.c);
                                if (blockEntity == null) {
                                    blockEntity = ((ITileEntity)block).a((BlockPosition)blockPos, blockState);
                                    if (blockEntity != null) {
                                        chunk3.b(blockEntity);
                                    }
                                } else if (blockEntity.u().a(blockState)) {
                                    blockEntity.b(blockState);
                                    AxiomReflection.updateBlockEntityTicker(chunk3, blockEntity);
                                } else {
                                    chunk3.d((BlockPosition)blockPos);
                                    blockEntity = ((ITileEntity)block).a((BlockPosition)blockPos, blockState);
                                    if (blockEntity != null) {
                                        chunk3.b(blockEntity);
                                    }
                                }
                                if (blockEntity != null && blockEntityChunkMap != null) {
                                    if (blockEntity instanceof GameMasterBlock && !this.player.l(2)) {
                                        this.sendGameMasterBlockWarning = true;
                                    } else {
                                        int key = x | y << 4 | z << 8;
                                        CompressedBlockEntity savedBlockEntity = (CompressedBlockEntity)blockEntityChunkMap.get((short)key);
                                        if (savedBlockEntity != null) {
                                            blockEntity.a(savedBlockEntity.decompress());
                                            chunkChanged = true;
                                        }
                                    }
                                }
                            } else if (old.t()) {
                                chunk3.d((BlockPosition)blockPos);
                            }
                            if (!CoreProtectIntegration.isEnabled() || old == blockState) continue;
                            String changedBy = this.player.getBukkitEntity().getName();
                            BlockPosition changedPos = new BlockPosition(bx, by, bz);
                            CoreProtectIntegration.logRemoval(changedBy, old, level.getWorld(), changedPos);
                            CoreProtectIntegration.logPlacement(changedBy, blockState, level.getWorld(), changedPos);
                        }
                    }
                }
                boolean nowHasOnlyAir = section.c();
                if (hasOnlyAir == nowHasOnlyAir) continue;
                level.k().a().a(SectionPosition.a((int)cx, (int)cy, (int)cz), nowHasOnlyAir);
            }
            if (chunkChanged) {
                extension.sendChunk(chunk3.locX, chunk3.locZ);
                chunk3.a(true);
            }
            if (!chunkLightChanged) continue;
            extension.lightChunk(chunk3.locX, chunk3.locZ);
        }
        if (!this.getChunkFutures.isEmpty()) {
            return;
        }
        if (this.sendGameMasterBlockWarning) {
            this.player.a((IChatBaseComponent)IChatBaseComponent.b((String)"Unable to set data for Game Master block since you don't have op").a(EnumChatFormat.m));
        }
        this.finished = true;
    }
}

