/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.buffer.CompressedBlockEntity;
import com.moulberry.axiom.operations.PendingOperation;
import com.moulberry.axiom.packet.impl.RequestChunkDataPacketListener;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongComparators;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import org.bukkit.craftbukkit.v1_20_R1.CraftChunk;

public class RequestChunksOperation
implements PendingOperation {
    private static final int MAX_CHUNK_FUTURES = 256;
    private boolean finished = false;
    private final BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
    private final EntityPlayer serverPlayer;
    private final long id;
    private final LongArrayList getChunkFutures;
    private List<CompletableFuture<org.bukkit.Chunk>> chunkFutures = new ArrayList<CompletableFuture<org.bukkit.Chunk>>();
    private final Long2ObjectMap<LongList> sendBlockEntityForPendingChunks;
    private final Long2ObjectMap<IntList> sendSectionsForPendingChunks;
    private final boolean sendBlockEntitiesInChunks;
    private final Long2ObjectOpenHashMap<DataPaletteBlock<IBlockData>> sendingSections;
    private final Long2ObjectOpenHashMap<CompressedBlockEntity> sendingBlockEntities;
    private final ByteArrayOutputStream baos;

    public RequestChunksOperation(EntityPlayer serverPlayer, long id, LongSet chunkFutures, Long2ObjectMap<LongList> sendBlockEntityForPendingChunks, Long2ObjectMap<IntList> sendSectionsForPendingChunks, boolean sendBlockEntitiesInChunks, Long2ObjectOpenHashMap<DataPaletteBlock<IBlockData>> sendingSections, Long2ObjectOpenHashMap<CompressedBlockEntity> sendingBlockEntities, ByteArrayOutputStream baos) {
        this.serverPlayer = serverPlayer;
        this.id = id;
        this.sendBlockEntityForPendingChunks = sendBlockEntityForPendingChunks;
        this.sendSectionsForPendingChunks = sendSectionsForPendingChunks;
        this.sendBlockEntitiesInChunks = sendBlockEntitiesInChunks;
        this.sendingSections = sendingSections;
        this.sendingBlockEntities = sendingBlockEntities;
        this.baos = baos;
        LongArrayList getChunkFutures = new LongArrayList((LongCollection)chunkFutures);
        getChunkFutures.unstableSort(LongComparators.NATURAL_COMPARATOR);
        this.getChunkFutures = getChunkFutures;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public EntityPlayer executor() {
        return this.serverPlayer;
    }

    @Override
    public void tick(WorldServer level) {
        if (this.finished) {
            return;
        }
        if (this.serverPlayer.t()) {
            this.finished = true;
            return;
        }
        if (!this.getChunkFutures.isEmpty()) {
            int count = this.chunkFutures.size();
            LongIterator newFutureIterator = this.getChunkFutures.longIterator();
            while (count++ < 256 && newFutureIterator.hasNext()) {
                long chunkPos = newFutureIterator.nextLong();
                newFutureIterator.remove();
                int x = ChunkCoordIntPair.a((long)chunkPos);
                int z = ChunkCoordIntPair.b((long)chunkPos);
                this.chunkFutures.add(level.getWorld().getChunkAtAsync(x, z));
            }
        }
        Iterator<CompletableFuture<org.bukkit.Chunk>> chunkFutureIterator = this.chunkFutures.iterator();
        while (chunkFutureIterator.hasNext()) {
            ObjectIterator iterator;
            IntList sendSectionsInChunk;
            CompletableFuture<org.bukkit.Chunk> future = chunkFutureIterator.next();
            if (!future.isDone()) {
                return;
            }
            chunkFutureIterator.remove();
            Chunk chunk = (Chunk)((CraftChunk)future.join()).getHandle(ChunkStatus.n);
            long chunkPosLong = ChunkCoordIntPair.c((int)chunk.locX, (int)chunk.locZ);
            LongList blockEntitiesInChunk = (LongList)this.sendBlockEntityForPendingChunks.get(chunkPosLong);
            if (blockEntitiesInChunk != null) {
                LongIterator iterator2 = blockEntitiesInChunk.longIterator();
                while (iterator2.hasNext()) {
                    long blockEntityPos = iterator2.nextLong();
                    this.mutableBlockPos.f(blockEntityPos);
                    TileEntity blockEntity = chunk.a((BlockPosition)this.mutableBlockPos, Chunk.EnumTileEntityState.c);
                    if (blockEntity == null) continue;
                    NBTTagCompound tag = blockEntity.o();
                    this.sendingBlockEntities.put(blockEntityPos, (Object)CompressedBlockEntity.compress(tag, this.baos));
                }
            }
            if ((sendSectionsInChunk = (IntList)this.sendSectionsForPendingChunks.get(chunkPosLong)) == null) continue;
            boolean hasNonAirSectionInChunk = false;
            IntIterator sectionIterator = sendSectionsInChunk.intIterator();
            while (sectionIterator.hasNext()) {
                int sy = sectionIterator.nextInt();
                int sectionIndex = chunk.f(sy);
                if (sectionIndex < 0 || sectionIndex >= chunk.ak()) continue;
                ChunkSection section = chunk.b(sectionIndex);
                if (section.c()) {
                    this.sendingSections.put(BlockPosition.a((int)chunk.locX, (int)sy, (int)chunk.locZ), null);
                    continue;
                }
                DataPaletteBlock container = section.h();
                this.sendingSections.put(BlockPosition.a((int)chunk.locX, (int)sy, (int)chunk.locZ), (Object)container);
                hasNonAirSectionInChunk = true;
            }
            if (!this.sendBlockEntitiesInChunks || !hasNonAirSectionInChunk) continue;
            Set entrySet = chunk.k.entrySet();
            if (entrySet instanceof Object2ObjectMap.FastEntrySet) {
                Object2ObjectMap.FastEntrySet fastEntrySet = (Object2ObjectMap.FastEntrySet)entrySet;
                iterator = fastEntrySet.fastIterator();
            } else {
                iterator = entrySet.iterator();
            }
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                BlockPosition blockPos = (BlockPosition)entry.getKey();
                int sectionY = blockPos.v() >> 4;
                if (!sendSectionsInChunk.contains(sectionY)) continue;
                NBTTagCompound tag = ((TileEntity)entry.getValue()).o();
                this.sendingBlockEntities.put(blockPos.a(), (Object)CompressedBlockEntity.compress(tag, this.baos));
            }
        }
        if (!this.getChunkFutures.isEmpty()) {
            return;
        }
        RequestChunkDataPacketListener.sendResponse(this.serverPlayer, this.id, this.sendingBlockEntities, this.sendingSections);
        this.finished = true;
    }
}

