/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.operations.PendingOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.kyori.adventure.text.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;

public class OperationQueue {
    private final Lock queueLock = new ReentrantLock();
    private final Map<WorldServer, List<PendingOperation>> newPendingOperations = new HashMap<WorldServer, List<PendingOperation>>();
    private final Lock executionLock = new ReentrantLock();
    private final Map<WorldServer, List<PendingOperation>> pendingOperations = new HashMap<WorldServer, List<PendingOperation>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (!MinecraftServer.getServer().bl()) {
            throw new Error("Wrong thread");
        }
        this.executionLock.lock();
        try {
            this.queueLock.lock();
            try {
                for (Map.Entry<WorldServer, List<PendingOperation>> entry : this.newPendingOperations.entrySet()) {
                    List<PendingOperation> currentOperations = this.pendingOperations.get(entry.getKey());
                    if (currentOperations != null) {
                        currentOperations.addAll((Collection<PendingOperation>)entry.getValue());
                        continue;
                    }
                    this.pendingOperations.put(entry.getKey(), entry.getValue());
                }
                this.newPendingOperations.clear();
            }
            finally {
                this.queueLock.unlock();
            }
            Iterator<Map.Entry<WorldServer, List<PendingOperation>>> worldIterator = this.pendingOperations.entrySet().iterator();
            while (worldIterator.hasNext()) {
                Map.Entry<WorldServer, List<PendingOperation>> perWorldOperations = worldIterator.next();
                Iterator<PendingOperation> perWorldIterator = perWorldOperations.getValue().iterator();
                while (perWorldIterator.hasNext()) {
                    PendingOperation operation = perWorldIterator.next();
                    try {
                        operation.tick(perWorldOperations.getKey());
                        if (!operation.isFinished()) break;
                        perWorldIterator.remove();
                    }
                    catch (Throwable t) {
                        EntityPlayer executor = operation.executor();
                        executor.getBukkitEntity().kick((Component)Component.text((String)("An error occurred while processing operation: " + t.getMessage())));
                        perWorldIterator.remove();
                    }
                }
                if (!perWorldOperations.getValue().isEmpty()) continue;
                worldIterator.remove();
            }
        }
        finally {
            this.executionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(WorldServer level, PendingOperation operation) {
        this.queueLock.lock();
        try {
            List operations = this.newPendingOperations.computeIfAbsent(level, k -> new ArrayList());
            if (operations.isEmpty() && MinecraftServer.getServer().bl() && this.executionLock.tryLock()) {
                try {
                    List<PendingOperation> currentOperations = this.pendingOperations.get(level);
                    if (currentOperations == null || currentOperations.isEmpty()) {
                        operation.tick(level);
                        if (operation.isFinished()) {
                            return;
                        }
                    }
                }
                finally {
                    this.executionLock.unlock();
                }
            }
            operations.add(operation);
        }
        finally {
            this.queueLock.unlock();
        }
    }
}

