/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.marker;

import com.moulberry.axiom.VersionHelper;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.reflectionremapper.ReflectionRemapper;

public record MarkerData(UUID uuid, Vec3D position, @Nullable String name, @Nullable Vec3D minRegion, @Nullable Vec3D maxRegion, int lineArgb, float lineThickness, int faceArgb) {
    private static final Field dataField;

    public static MarkerData read(PacketDataSerializer friendlyByteBuf) {
        UUID uuid = friendlyByteBuf.o();
        Vec3D position = new Vec3D(friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble());
        String name = (String)friendlyByteBuf.c(PacketDataSerializer::s);
        Vec3D minRegion = null;
        Vec3D maxRegion = null;
        int lineArgb = 0;
        float lineThickness = 0.0f;
        int faceArgb = 0;
        byte flags = friendlyByteBuf.readByte();
        if (flags != 0) {
            minRegion = new Vec3D(friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble());
            maxRegion = new Vec3D(friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble());
            if ((flags & 2) != 0) {
                lineArgb = friendlyByteBuf.readInt();
            }
            if ((flags & 4) != 0) {
                lineThickness = friendlyByteBuf.readFloat();
            }
            if ((flags & 8) != 0) {
                faceArgb = friendlyByteBuf.readInt();
            }
        }
        return new MarkerData(uuid, position, name, minRegion, maxRegion, lineArgb, lineThickness, faceArgb);
    }

    public static void write(PacketDataSerializer friendlyByteBuf, MarkerData markerData) {
        friendlyByteBuf.a(markerData.uuid);
        friendlyByteBuf.writeDouble(markerData.position.c);
        friendlyByteBuf.writeDouble(markerData.position.d);
        friendlyByteBuf.writeDouble(markerData.position.e);
        friendlyByteBuf.a((Object)markerData.name, PacketDataSerializer::a);
        if (markerData.minRegion != null && markerData.maxRegion != null) {
            int flags = 1;
            if (markerData.lineArgb != 0) {
                flags = (byte)(flags | 2);
            }
            if (markerData.lineThickness != 0.0f) {
                flags = (byte)(flags | 4);
            }
            if (markerData.faceArgb != 0) {
                flags = (byte)(flags | 8);
            }
            friendlyByteBuf.writeByte(flags);
            friendlyByteBuf.writeDouble(markerData.minRegion.c);
            friendlyByteBuf.writeDouble(markerData.minRegion.d);
            friendlyByteBuf.writeDouble(markerData.minRegion.e);
            friendlyByteBuf.writeDouble(markerData.maxRegion.c);
            friendlyByteBuf.writeDouble(markerData.maxRegion.d);
            friendlyByteBuf.writeDouble(markerData.maxRegion.e);
            if (markerData.lineArgb != 0) {
                friendlyByteBuf.writeInt(markerData.lineArgb);
            }
            if (markerData.lineThickness != 0.0f) {
                friendlyByteBuf.writeFloat(markerData.lineThickness);
            }
            if (markerData.faceArgb != 0) {
                friendlyByteBuf.writeInt(markerData.faceArgb);
            }
        } else {
            friendlyByteBuf.writeByte(0);
        }
    }

    public static NBTTagCompound getData(Marker marker) {
        try {
            return (NBTTagCompound)dataField.get(marker);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static MarkerData createFrom(Marker marker) {
        Vec3D position = marker.dg();
        NBTTagCompound data = MarkerData.getData(marker);
        String name = data.l("name").trim();
        if (name.isEmpty()) {
            name = null;
        }
        Vec3D minRegion = null;
        Vec3D maxRegion = null;
        int lineArgb = 0;
        float lineThickness = 0.0f;
        int faceArgb = 0;
        if (data.e("min") && data.e("max")) {
            double maxZ;
            double maxY;
            double maxX;
            NBTTagList max;
            NBTTagList min = VersionHelper.getList(data, "min", 6);
            if (min.size() == 3) {
                double minX = min.h(0);
                double minY = min.h(1);
                double minZ = min.h(2);
                minRegion = new Vec3D(minX, minY, minZ);
            }
            if ((max = VersionHelper.getList(data, "max", 6)).size() == 3) {
                maxX = max.h(0);
                maxY = max.h(1);
                maxZ = max.h(2);
                maxRegion = new Vec3D(maxX, maxY, maxZ);
            }
            if (minRegion == null && (min = VersionHelper.getList(data, "min", 8)).size() == 3) {
                double minX = MarkerData.calculateCoordinate(min.j(0), position.c);
                double minY = MarkerData.calculateCoordinate(min.j(1), position.d);
                double minZ = MarkerData.calculateCoordinate(min.j(2), position.e);
                if (Double.isFinite(minX) && Double.isFinite(minY) && Double.isFinite(minZ)) {
                    minRegion = new Vec3D(minX, minY, minZ);
                }
            }
            if (maxRegion == null && (max = VersionHelper.getList(data, "max", 8)).size() == 3) {
                maxX = MarkerData.calculateCoordinate(max.j(0), position.c);
                maxY = MarkerData.calculateCoordinate(max.j(1), position.d);
                maxZ = MarkerData.calculateCoordinate(max.j(2), position.e);
                if (Double.isFinite(maxX) && Double.isFinite(maxY) && Double.isFinite(maxZ)) {
                    maxRegion = new Vec3D(maxX, maxY, maxZ);
                }
            }
            if (minRegion != null && maxRegion != null) {
                lineArgb = data.h("line_argb");
                lineThickness = data.h("line_thickness");
                faceArgb = data.h("face_argb");
            }
        }
        return new MarkerData(marker.ct(), position, name, minRegion, maxRegion, lineArgb, lineThickness, faceArgb);
    }

    private static double calculateCoordinate(String coordinate, double position) {
        boolean relative = (coordinate = coordinate.trim()).startsWith("~");
        if (relative) {
            coordinate = coordinate.substring(1).trim();
        }
        try {
            double value = Double.parseDouble(coordinate);
            if (relative) {
                return position + value;
            }
            return value;
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    static {
        ReflectionRemapper reflectionRemapper = ReflectionRemapper.forReobfMappingsInPaperJar();
        String fieldName = reflectionRemapper.remapFieldName(Marker.class, "data");
        try {
            dataField = Marker.class.getDeclaredField(fieldName);
            dataField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

