/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.integration.worldguard;

import com.google.common.collect.Iterables;
import com.moulberry.axiom.integration.Box;
import com.moulberry.axiom.integration.BoxWithBoolean;
import com.moulberry.axiom.integration.SectionPermissionChecker;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.internal.platform.WorldGuardPlatform;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.FlagValueCalculator;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.GlobalProtectedRegion;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class WorldGuardIntegrationImpl {
    static boolean canBreakBlock(Player player, Location loc) {
        return WorldGuardIntegrationImpl.testBuild(player, loc, Flags.BLOCK_BREAK);
    }

    static boolean canPlaceBlock(Player player, Location loc) {
        return WorldGuardIntegrationImpl.testBuild(player, loc, Flags.BLOCK_PLACE);
    }

    private static boolean testBuild(Player player, Location loc, StateFlag flag) {
        WorldGuardPlatform platform = WorldGuard.getInstance().getPlatform();
        World worldEditWorld = BukkitAdapter.adapt((org.bukkit.World)loc.getWorld());
        LocalPlayer worldGuardPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        if (platform.getSessionManager().hasBypass(worldGuardPlayer, worldEditWorld)) {
            return true;
        }
        RegionContainer regionContainer = platform.getRegionContainer();
        if (regionContainer == null) {
            return true;
        }
        RegionQuery query = regionContainer.createQuery();
        return query.testBuild(BukkitAdapter.adapt((Location)loc), worldGuardPlayer, new StateFlag[]{flag});
    }

    static SectionPermissionChecker checkSection(Player player, org.bukkit.World world, int cx, int cy, int cz) {
        int minX = cx * 16;
        int minY = cy * 16;
        int minZ = cz * 16;
        int maxX = cx * 16 + 15;
        int maxY = cy * 16 + 15;
        int maxZ = cz * 16 + 15;
        WorldGuardPlatform platform = WorldGuard.getInstance().getPlatform();
        RegionContainer regionContainer = platform.getRegionContainer();
        if (regionContainer == null) {
            return SectionPermissionChecker.ALL_ALLOWED;
        }
        World worldEditWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        LocalPlayer worldGuardPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        if (platform.getSessionManager().hasBypass(worldGuardPlayer, worldEditWorld)) {
            return SectionPermissionChecker.ALL_ALLOWED;
        }
        RegionManager regionManager = regionContainer.get(worldEditWorld);
        if (regionManager == null) {
            return SectionPermissionChecker.ALL_ALLOWED;
        }
        BlockVector3 min = BlockVector3.at((int)minX, (int)minY, (int)minZ);
        BlockVector3 max = BlockVector3.at((int)maxX, (int)maxY, (int)maxZ);
        ProtectedCuboidRegion test = new ProtectedCuboidRegion("dummy", min, max);
        ApplicableRegionSet regions = regionManager.getApplicableRegions((ProtectedRegion)test, RegionQuery.QueryOption.COMPUTE_PARENTS);
        ProtectedRegion globalRegion = regionManager.getRegion("__global__");
        regions = globalRegion == null ? regions : Iterables.concat((Iterable)regions, Collections.singletonList(globalRegion));
        Box sectionBox = new Box(0, 0, 0, 15, 15, 15);
        int lastPriority = Integer.MIN_VALUE;
        ArrayList<Box> denyRegions = new ArrayList<Box>();
        ArrayList<Box> allowRegions = new ArrayList<Box>();
        ArrayList<BoxWithBoolean> finalRegions = new ArrayList<BoxWithBoolean>();
        for (ProtectedRegion region : regions) {
            StateFlag.State value;
            int priority = FlagValueCalculator.getPriorityOf((ProtectedRegion)region);
            if (priority != lastPriority) {
                lastPriority = priority;
                if (WorldGuardIntegrationImpl.addRegions(sectionBox, denyRegions, allowRegions, finalRegions)) break;
            }
            if ((value = (StateFlag.State)FlagValueCalculator.getEffectiveFlagOf((ProtectedRegion)region, (Flag)Flags.BUILD, (RegionAssociable)worldGuardPlayer)) == null) continue;
            if (region instanceof GlobalProtectedRegion) {
                if (value == StateFlag.State.DENY) {
                    if (finalRegions.isEmpty()) {
                        return SectionPermissionChecker.NONE_ALLOWED;
                    }
                    denyRegions.add(sectionBox);
                    continue;
                }
                if (value != StateFlag.State.ALLOW) continue;
                allowRegions.add(sectionBox);
                continue;
            }
            if (!(region instanceof ProtectedCuboidRegion) && value != StateFlag.State.DENY) continue;
            BlockVector3 regionMin = region.getMinimumPoint();
            BlockVector3 regionMax = region.getMaximumPoint();
            int regionMinX = Math.max(regionMin.getX(), cx * 16) - minX;
            int regionMinY = Math.max(regionMin.getY(), cy * 16) - minY;
            int regionMinZ = Math.max(regionMin.getZ(), cz * 16) - minZ;
            int regionMaxX = Math.min(regionMax.getX(), cx * 16 + 15) - minX;
            int regionMaxY = Math.min(regionMax.getY(), cy * 16 + 15) - minY;
            int regionMaxZ = Math.min(regionMax.getZ(), cz * 16 + 15) - minZ;
            Box box = new Box(regionMinX, regionMinY, regionMinZ, regionMaxX, regionMaxY, regionMaxZ);
            if (value == StateFlag.State.DENY) {
                denyRegions.add(box);
                continue;
            }
            allowRegions.add(box);
        }
        WorldGuardIntegrationImpl.addRegions(sectionBox, denyRegions, allowRegions, finalRegions);
        return SectionPermissionChecker.fromBoxWithBooleans(finalRegions, Flags.BUILD.getDefault() == StateFlag.State.ALLOW);
    }

    private static boolean addRegions(Box sectionBox, List<Box> denyRegions, List<Box> allowRegions, List<BoxWithBoolean> finalRegions) {
        ArrayList<Box> denyRegionsCopy = new ArrayList<Box>(denyRegions);
        denyRegions.clear();
        ArrayList<Box> allowRegionsCopy = new ArrayList<Box>(allowRegions);
        allowRegions.clear();
        if (!denyRegionsCopy.isEmpty()) {
            Box.combineAll(denyRegionsCopy);
            for (Box denyRegion : denyRegionsCopy) {
                finalRegions.add(new BoxWithBoolean(denyRegion, false));
                if (!denyRegion.completelyOverlaps(sectionBox)) continue;
                return true;
            }
        }
        if (!allowRegionsCopy.isEmpty()) {
            Box.combineAll(allowRegionsCopy);
            for (Box allowRegion : allowRegionsCopy) {
                finalRegions.add(new BoxWithBoolean(allowRegion, true));
                if (!allowRegion.completelyOverlaps(sectionBox)) continue;
                return true;
            }
        }
        return false;
    }
}

