/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.integration.plotsquared;

import com.moulberry.axiom.integration.Box;
import com.moulberry.axiom.integration.SectionPermissionChecker;
import com.moulberry.axiom.integration.plotsquared.PlotSquaredIntegration;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.flag.implementations.BreakFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.types.BlockTypeWrapper;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPosition;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class PlotSquaredIntegrationImpl {
    private static final WeakHashMap<World, Boolean> plotWorldCache = new WeakHashMap();

    static boolean canBreakBlock(Player player, Block block) {
        Location location = BukkitUtil.adapt((org.bukkit.Location)block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return true;
        }
        Plot plot = area.getPlot(location);
        if (plot != null) {
            BukkitPlayer plotPlayer = BukkitUtil.adapt((Player)player);
            if (block.getY() == area.getMinGenHeight() && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_GROUNDLEVEL, true)) {
                return false;
            }
            if (area.notifyIfOutsideBuildArea((PlotPlayer)plotPlayer, location.getY())) {
                return false;
            }
            if (!plot.hasOwner()) {
                return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_UNOWNED, true);
            }
            if (!plot.isAdded(plotPlayer.getUUID())) {
                List destroy = (List)plot.getFlag(BreakFlag.class);
                BlockType blockType = BukkitAdapter.asBlockType((Material)block.getType());
                for (BlockTypeWrapper blockTypeWrapper : destroy) {
                    if (!blockTypeWrapper.accepts(blockType)) continue;
                    return true;
                }
                return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_OTHER, true);
            }
            if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot)) {
                return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER, true);
            }
            return true;
        }
        BukkitPlayer pp = BukkitUtil.adapt((Player)player);
        return pp.hasPermission(Permission.PERMISSION_ADMIN_DESTROY_ROAD, true);
    }

    static boolean canPlaceBlock(Player player, org.bukkit.Location loc) {
        Location location = BukkitUtil.adapt((org.bukkit.Location)loc);
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return true;
        }
        BukkitPlayer pp = BukkitUtil.adapt((Player)player);
        Plot plot = area.getPlot(location);
        if (plot != null) {
            if (area.notifyIfOutsideBuildArea((PlotPlayer)pp, location.getY())) {
                return false;
            }
            if (!plot.hasOwner()) {
                return pp.hasPermission(Permission.PERMISSION_ADMIN_BUILD_UNOWNED, true);
            }
            if (!plot.isAdded(pp.getUUID())) {
                return pp.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER, true);
            }
            if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot)) {
                return pp.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER, true);
            }
            return true;
        }
        return pp.hasPermission(Permission.PERMISSION_ADMIN_BUILD_ROAD, true);
    }

    static boolean isPlotWorld(World world) {
        if (plotWorldCache.containsKey(world)) {
            return plotWorldCache.get(world);
        }
        String worldName = world.getName();
        PlotArea[] plotAreas = PlotSquared.get().getPlotAreaManager().getPlotAreas(worldName, null);
        boolean isPlotWorld = plotAreas.length > 0;
        plotWorldCache.put(world, isPlotWorld);
        return isPlotWorld;
    }

    static PlotSquaredIntegration.PlotBounds getCurrentEditablePlot(Player player) {
        org.bukkit.Location loc = player.getLocation();
        Location location = BukkitUtil.adapt((org.bukkit.Location)loc);
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return null;
        }
        BukkitPlayer pp = BukkitUtil.adapt((Player)player);
        Plot plot = area.getPlot(location);
        if (plot != null) {
            if (!plot.hasOwner()) {
                if (!pp.hasPermission(Permission.PERMISSION_ADMIN_BUILD_UNOWNED, false)) {
                    return null;
                }
                return PlotSquaredIntegrationImpl.createBounds(plot, player.getWorld().getName());
            }
            if (!plot.isAdded(pp.getUUID())) {
                if (!pp.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER, false)) {
                    return null;
                }
                return PlotSquaredIntegrationImpl.createBounds(plot, player.getWorld().getName());
            }
            if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot)) {
                if (!pp.hasPermission(Permission.PERMISSION_ADMIN_BUILD_OTHER, false)) {
                    return null;
                }
                return PlotSquaredIntegrationImpl.createBounds(plot, player.getWorld().getName());
            }
            return PlotSquaredIntegrationImpl.createBounds(plot, player.getWorld().getName());
        }
        return null;
    }

    private static PlotSquaredIntegration.PlotBounds createBounds(Plot plot, String worldName) {
        LinkedHashSet<PlotSquaredIntegration.PlotBox> boxes = new LinkedHashSet<PlotSquaredIntegration.PlotBox>();
        for (CuboidRegion region : plot.getRegions()) {
            BlockPosition min = new BlockPosition(region.getMinimumPoint().getBlockX(), region.getMinimumPoint().getBlockY(), region.getMinimumPoint().getBlockZ());
            BlockPosition max = new BlockPosition(region.getMaximumPoint().getBlockX(), region.getMaximumPoint().getBlockY(), region.getMaximumPoint().getBlockZ());
            boxes.add(new PlotSquaredIntegration.PlotBox(min, max));
        }
        return new PlotSquaredIntegration.PlotBounds(boxes, worldName);
    }

    static SectionPermissionChecker checkSection(Player player, World world, int sectionX, int sectionY, int sectionZ) {
        int minX = sectionX * 16;
        int minY = sectionY * 16;
        int minZ = sectionZ * 16;
        int maxX = sectionX * 16 + 15;
        int maxY = sectionY * 16 + 15;
        int maxZ = sectionZ * 16 + 15;
        PlotArea[] plotAreas = PlotSquared.get().getPlotAreaManager().getPlotAreas(world.getName(), new CuboidRegion(BlockVector3.at((int)minX, (int)minY, (int)minZ), BlockVector3.at((int)maxX, (int)maxY, (int)maxZ)));
        if (plotAreas.length == 0) {
            return SectionPermissionChecker.ALL_ALLOWED;
        }
        HashSet<Plot> checkedPlots = new HashSet<Plot>();
        ArrayList<Box> allowed = new ArrayList<Box>();
        for (PlotArea plotArea : plotAreas) {
            for (int px = minX; px <= maxX; px += 15) {
                for (int py = minY; py <= maxY; py += 15) {
                    for (int pz = minZ; pz <= maxZ; pz += 15) {
                        Plot plot;
                        PlotId pid = plotArea.getPlotManager().getPlotId(px, py, pz);
                        if (pid == null || (plot = plotArea.getOwnedPlot(pid)) == null || !checkedPlots.add(plot) || !plot.hasOwner() || !plot.isAdded(player.getUniqueId()) || Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot)) continue;
                        for (CuboidRegion region : plot.getRegions()) {
                            BlockVector3 minPoint = region.getMinimumPoint();
                            BlockVector3 maxPoint = region.getMaximumPoint();
                            int minPlotX = Math.max(minPoint.getX(), minX);
                            int minPlotY = Math.max(minPoint.getY(), minY);
                            int minPlotZ = Math.max(minPoint.getZ(), minZ);
                            int maxPlotX = Math.min(maxPoint.getX(), maxX);
                            int maxPlotY = Math.min(maxPoint.getY(), maxY);
                            int maxPlotZ = Math.min(maxPoint.getZ(), maxZ);
                            if (minPlotX > maxPlotX || minPlotY > maxPlotY || minPlotZ > maxPlotZ) continue;
                            if (minPlotX <= minX && minPlotY <= minY && minPlotZ <= minZ && maxPlotX >= maxX && maxPlotY >= maxY && maxPlotZ >= maxZ) {
                                return SectionPermissionChecker.ALL_ALLOWED;
                            }
                            allowed.add(new Box(minPlotX - minX, minPlotY - minY, minPlotZ - minZ, maxPlotX - minX, maxPlotY - minY, maxPlotZ - minZ));
                        }
                    }
                }
            }
        }
        Box.combineAll(allowed);
        return SectionPermissionChecker.fromAllowedBoxes(allowed);
    }
}

