/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.integration;

import com.moulberry.axiom.integration.Box;
import com.moulberry.axiom.integration.BoxWithBoolean;
import java.util.List;

public interface SectionPermissionChecker {
    public static final Box FULL_BOUNDS = new Box(0, 0, 0, 15, 15, 15);
    public static final SectionPermissionChecker ALL_ALLOWED = new SectionPermissionChecker(){

        @Override
        public boolean allAllowed() {
            return true;
        }

        @Override
        public boolean noneAllowed() {
            return false;
        }

        @Override
        public boolean allowed(int x, int y, int z) {
            return true;
        }

        @Override
        public Box bounds() {
            return FULL_BOUNDS;
        }
    };
    public static final Box EMPTY_BOUNDS = new Box(0, 0, 0, 0, 0, 0);
    public static final SectionPermissionChecker NONE_ALLOWED = new SectionPermissionChecker(){

        @Override
        public boolean allAllowed() {
            return false;
        }

        @Override
        public boolean noneAllowed() {
            return true;
        }

        @Override
        public boolean allowed(int x, int y, int z) {
            return false;
        }

        @Override
        public Box bounds() {
            return EMPTY_BOUNDS;
        }
    };

    public boolean allAllowed();

    public boolean noneAllowed();

    public boolean allowed(int var1, int var2, int var3);

    public Box bounds();

    public static SectionPermissionChecker combine(final SectionPermissionChecker first, final SectionPermissionChecker second) {
        if (first.noneAllowed() || second.noneAllowed()) {
            return NONE_ALLOWED;
        }
        if (first == ALL_ALLOWED) {
            return second;
        }
        if (second == ALL_ALLOWED) {
            return first;
        }
        final Box intersect = Box.intersection(first.bounds(), second.bounds());
        if (intersect == null) {
            return NONE_ALLOWED;
        }
        if (first.allAllowed() && second.allAllowed()) {
            return new AllAllowedInBox(intersect);
        }
        return new SectionPermissionChecker(){

            @Override
            public boolean allAllowed() {
                return false;
            }

            @Override
            public boolean noneAllowed() {
                return false;
            }

            @Override
            public boolean allowed(int x, int y, int z) {
                return first.allowed(x, y, z) && second.allowed(x, y, z);
            }

            @Override
            public Box bounds() {
                return intersect;
            }
        };
    }

    public static SectionPermissionChecker fromAllowedBoxes(List<Box> allowed) {
        if (allowed.isEmpty()) {
            return NONE_ALLOWED;
        }
        if (allowed.size() == 1) {
            Box allowedBox = allowed.get(0);
            if (allowedBox.completelyOverlaps(FULL_BOUNDS)) {
                return ALL_ALLOWED;
            }
            return new AllAllowedInBox(allowedBox);
        }
        int minBoundsX = 15;
        int minBoundsY = 15;
        int minBoundsZ = 15;
        int maxBoundsX = 0;
        int maxBoundsY = 0;
        int maxBoundsZ = 0;
        for (Box box : allowed) {
            minBoundsX = Math.min(box.minX(), minBoundsX);
            minBoundsY = Math.min(box.minY(), minBoundsY);
            minBoundsZ = Math.min(box.minZ(), minBoundsZ);
            maxBoundsX = Math.max(box.maxX(), maxBoundsX);
            maxBoundsY = Math.max(box.maxY(), maxBoundsY);
            maxBoundsZ = Math.max(box.maxZ(), maxBoundsZ);
        }
        return new AllAllowedBoxes(new Box(minBoundsX, minBoundsY, minBoundsZ, maxBoundsX, maxBoundsY, maxBoundsZ), allowed);
    }

    public static SectionPermissionChecker fromBoxWithBooleans(List<BoxWithBoolean> boxes, boolean defaultValue) {
        if (boxes.isEmpty()) {
            return defaultValue ? ALL_ALLOWED : NONE_ALLOWED;
        }
        if (boxes.size() == 1) {
            BoxWithBoolean boxWithBoolean = boxes.get(0);
            if (boxWithBoolean.value()) {
                if (defaultValue) {
                    return ALL_ALLOWED;
                }
                if (boxWithBoolean.box().completelyOverlaps(FULL_BOUNDS)) {
                    return ALL_ALLOWED;
                }
                return new AllAllowedInBox(boxWithBoolean.box());
            }
            if (!defaultValue) {
                return NONE_ALLOWED;
            }
            if (boxWithBoolean.box().completelyOverlaps(FULL_BOUNDS)) {
                return NONE_ALLOWED;
            }
        }
        if (defaultValue) {
            return new BooleanBoxes(FULL_BOUNDS, boxes, true);
        }
        int minBoundsX = 15;
        int minBoundsY = 15;
        int minBoundsZ = 15;
        int maxBoundsX = 0;
        int maxBoundsY = 0;
        int maxBoundsZ = 0;
        for (BoxWithBoolean boxWithBoolean : boxes) {
            if (!boxWithBoolean.value()) continue;
            Box box = boxWithBoolean.box();
            minBoundsX = Math.min(box.minX(), minBoundsX);
            minBoundsY = Math.min(box.minY(), minBoundsY);
            minBoundsZ = Math.min(box.minZ(), minBoundsZ);
            maxBoundsX = Math.max(box.maxX(), maxBoundsX);
            maxBoundsY = Math.max(box.maxY(), maxBoundsY);
            maxBoundsZ = Math.max(box.maxZ(), maxBoundsZ);
        }
        Box bounds = new Box(minBoundsX, minBoundsY, minBoundsZ, maxBoundsX, maxBoundsY, maxBoundsZ);
        return new BooleanBoxes(bounds, boxes, false);
    }

    public record AllAllowedInBox(Box box) implements SectionPermissionChecker
    {
        @Override
        public boolean allAllowed() {
            return true;
        }

        @Override
        public boolean noneAllowed() {
            return false;
        }

        @Override
        public boolean allowed(int x, int y, int z) {
            return true;
        }

        @Override
        public Box bounds() {
            return this.box;
        }
    }

    public record AllAllowedBoxes(Box bounds, List<Box> allowed) implements SectionPermissionChecker
    {
        @Override
        public boolean allAllowed() {
            return false;
        }

        @Override
        public boolean noneAllowed() {
            return false;
        }

        @Override
        public boolean allowed(int x, int y, int z) {
            for (Box box : this.allowed) {
                if (!box.contains(x, y, z)) continue;
                return true;
            }
            return false;
        }
    }

    public record BooleanBoxes(Box bounds, List<BoxWithBoolean> boxes, boolean defaultValue) implements SectionPermissionChecker
    {
        @Override
        public boolean allAllowed() {
            return false;
        }

        @Override
        public boolean noneAllowed() {
            return false;
        }

        @Override
        public boolean allowed(int x, int y, int z) {
            for (BoxWithBoolean boxWithBoolean : this.boxes) {
                if (!boxWithBoolean.box().contains(x, y, z)) continue;
                return boxWithBoolean.value();
            }
            return this.defaultValue;
        }
    }
}

