/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buffer;

import com.moulberry.axiom.AxiomConstants;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.function.LongFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;

public class Position2ByteMap {
    private final byte defaultValue;
    private final LongFunction<byte[]> defaultFunction;
    private final Long2ObjectMap<byte[]> map = new Long2ObjectOpenHashMap();
    private long lastChunkPos = AxiomConstants.MIN_POSITION_LONG;
    private byte[] lastChunk = null;

    public Position2ByteMap() {
        this(0);
    }

    public Position2ByteMap(byte defaultValue) {
        this.defaultValue = defaultValue;
        this.defaultFunction = defaultValue == 0 ? k -> new byte[4096] : k -> {
            byte[] array = new byte[4096];
            Arrays.fill(array, defaultValue);
            return array;
        };
    }

    public int size() {
        return this.map.size();
    }

    public void save(PacketDataSerializer friendlyByteBuf) {
        friendlyByteBuf.writeByte((int)this.defaultValue);
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            friendlyByteBuf.writeLong(entry.getLongKey());
            friendlyByteBuf.writeBytes((byte[])entry.getValue());
        }
        friendlyByteBuf.writeLong(AxiomConstants.MIN_POSITION_LONG);
    }

    public static Position2ByteMap load(PacketDataSerializer friendlyByteBuf) {
        long pos;
        Position2ByteMap map = new Position2ByteMap(friendlyByteBuf.readByte());
        while ((pos = friendlyByteBuf.readLong()) != AxiomConstants.MIN_POSITION_LONG) {
            byte[] bytes = new byte[4096];
            friendlyByteBuf.readBytes(bytes);
            map.map.put(pos, (Object)bytes);
        }
        return map;
    }

    public void clear() {
        this.map.clear();
        this.lastChunkPos = AxiomConstants.MIN_POSITION_LONG;
        this.lastChunk = null;
    }

    public byte get(int x, int y, int z) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        byte[] array = this.getChunk(xC, yC, zC);
        if (array == null) {
            return this.defaultValue;
        }
        return array[(x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16];
    }

    public void put(int x, int y, int z, byte v) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        byte[] array = this.getOrCreateChunk(xC, yC, zC);
        array[(x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16] = v;
    }

    public byte add(int x, int y, int z, byte v) {
        if (v == 0) {
            return this.get(x, y, z);
        }
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        byte[] array = this.getOrCreateChunk(xC, yC, zC);
        int n = (x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16;
        byte by = (byte)(array[n] + v);
        array[n] = by;
        return by;
    }

    public byte binaryAnd(int x, int y, int z, byte v) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        byte[] array = this.getOrCreateChunk(xC, yC, zC);
        int n = (x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16;
        byte by = (byte)(array[n] & v);
        array[n] = by;
        return by;
    }

    public boolean min(int x, int y, int z, byte v) {
        int index;
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        byte[] array = this.getOrCreateChunk(xC, yC, zC);
        if (v < array[index = (x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16]) {
            array[index] = v;
            return true;
        }
        return false;
    }

    public void forEachEntry(EntryConsumer consumer) {
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            int cx = BlockPosition.a((long)entry.getLongKey()) * 16;
            int cy = BlockPosition.b((long)entry.getLongKey()) * 16;
            int cz = BlockPosition.c((long)entry.getLongKey()) * 16;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        byte v = ((byte[])entry.getValue())[index++];
                        if (v == this.defaultValue) continue;
                        consumer.consume(cx + x, cy + y, cz + z, v);
                    }
                }
            }
        }
    }

    public byte[] getChunk(int xC, int yC, int zC) {
        return this.getChunk(BlockPosition.a((int)xC, (int)yC, (int)zC));
    }

    public byte[] getChunk(long pos) {
        if (this.lastChunkPos != pos) {
            byte[] chunk = (byte[])this.map.get(pos);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    public byte[] getOrCreateChunk(int xC, int yC, int zC) {
        return this.getOrCreateChunk(BlockPosition.a((int)xC, (int)yC, (int)zC));
    }

    public byte[] getOrCreateChunk(long pos) {
        if (this.lastChunk == null || this.lastChunkPos != pos) {
            byte[] chunk = (byte[])this.map.computeIfAbsent(pos, this.defaultFunction);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    @FunctionalInterface
    public static interface EntryConsumer {
        public void consume(int var1, int var2, int var3, byte var4);
    }
}

