/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buffer;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdDictDecompress;
import com.moulberry.axiom.AxiomPaper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;

public record CompressedBlockEntity(int originalSize, byte compressionDict, byte[] compressed) {
    private static ZstdDictCompress zstdDictCompress = null;
    private static ZstdDictDecompress zstdDictDecompress = null;

    public static void initialize(AxiomPaper plugin) {
        try (InputStream is = Objects.requireNonNull(plugin.getResource("zstd_dictionaries/block_entities_v1.dict"));){
            byte[] bytes = is.readAllBytes();
            zstdDictCompress = new ZstdDictCompress(bytes, Zstd.defaultCompressionLevel());
            zstdDictDecompress = new ZstdDictDecompress(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CompressedBlockEntity compress(NBTTagCompound tag, ByteArrayOutputStream baos) {
        try {
            baos.reset();
            DataOutputStream dos = new DataOutputStream(baos);
            NBTCompressedStreamTools.a((NBTTagCompound)tag, (DataOutput)dos);
            byte[] uncompressed = baos.toByteArray();
            byte[] compressed = Zstd.compress(uncompressed, zstdDictCompress);
            return new CompressedBlockEntity(uncompressed.length, 0, compressed);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NBTTagCompound decompress() {
        if (this.compressionDict != 0) {
            throw new UnsupportedOperationException("Unknown compression dict: " + this.compressionDict);
        }
        try {
            byte[] nbt = Zstd.decompress(this.compressed, zstdDictDecompress, this.originalSize);
            return NBTCompressedStreamTools.a((DataInput)new DataInputStream(new ByteArrayInputStream(nbt)), (NBTReadLimiter)AxiomPaper.PLUGIN.createNbtAccounter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompressedBlockEntity read(PacketDataSerializer friendlyByteBuf) {
        int originalSize = friendlyByteBuf.m();
        byte compressionDict = friendlyByteBuf.readByte();
        byte[] compressed = friendlyByteBuf.b();
        return new CompressedBlockEntity(originalSize, compressionDict, compressed);
    }

    public void write(PacketDataSerializer friendlyByteBuf) {
        friendlyByteBuf.d(this.originalSize);
        friendlyByteBuf.writeByte((int)this.compressionDict);
        friendlyByteBuf.a(this.compressed);
    }
}

