/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buffer;

import com.mojang.serialization.Codec;
import com.moulberry.axiom.AxiomConstants;
import com.moulberry.axiom.buffer.CompressedBlockEntity;
import com.moulberry.axiom.viaversion.UnknownVersionHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class BlockBuffer {
    public static final IBlockData EMPTY_STATE = Blocks.nb.n();
    private static final Map<IBlockData, Codec<DataPaletteBlock<IBlockData>>> BLOCK_STATE_CODECS = new HashMap<IBlockData, Codec<DataPaletteBlock<IBlockData>>>();
    private static final Map<IBlockData, Registry<IBlockData>> ID_MAPPERS = new HashMap<IBlockData, Registry<IBlockData>>();
    private final Long2ObjectMap<DataPaletteBlock<IBlockData>> values;
    private RegistryBlockID<IBlockData> registry;
    private DataPaletteBlock<IBlockData> last = null;
    private long lastId = AxiomConstants.MIN_POSITION_LONG;
    private final Long2ObjectMap<Short2ObjectMap<CompressedBlockEntity>> blockEntities = new Long2ObjectOpenHashMap();
    private long totalBlockEntities = 0L;
    private long totalBlockEntityBytes = 0L;

    public static DataPaletteBlock<IBlockData> createPalettedContainerForEmptyBlockState(IBlockData emptyBlockState) {
        return new DataPaletteBlock(BlockBuffer.getIdMapForEmptyBlockState(emptyBlockState), (Object)EMPTY_STATE, DataPaletteBlock.d.d);
    }

    public static Registry<IBlockData> getIdMapForEmptyBlockState(IBlockData empty) {
        if (empty == EMPTY_STATE) {
            return Block.o;
        }
        return ID_MAPPERS.computeIfAbsent(empty, emptyState -> {
            RegistryBlockID mapper = new RegistryBlockID(Block.o.b());
            for (IBlockData blockState : Block.o) {
                mapper.a((Object)blockState, Block.o.a((Object)blockState));
            }
            mapper.a((Object)EMPTY_STATE, Block.o.a(emptyState));
            mapper.a((Object)EMPTY_STATE, Block.o.a((Object)EMPTY_STATE));
            return mapper;
        });
    }

    public static Codec<DataPaletteBlock<IBlockData>> getCodecForEmptyBlockState(IBlockData empty) {
        return BLOCK_STATE_CODECS.computeIfAbsent(empty, emptyState -> {
            Codec blockStateCodec;
            Registry<IBlockData> mapping = BlockBuffer.getIdMapForEmptyBlockState(emptyState);
            if (emptyState == EMPTY_STATE) {
                blockStateCodec = IBlockData.b;
            } else {
                Function<IBlockData, IBlockData> mapFunction = blockState -> {
                    if (blockState == emptyState) {
                        return EMPTY_STATE;
                    }
                    return blockState;
                };
                blockStateCodec = IBlockData.b.xmap(mapFunction, mapFunction);
            }
            return DataPaletteBlock.a(mapping, (Codec)blockStateCodec, (DataPaletteBlock.d)DataPaletteBlock.d.d, (Object)EMPTY_STATE);
        });
    }

    public BlockBuffer(RegistryBlockID<IBlockData> registry) {
        this.values = new Long2ObjectOpenHashMap();
        this.registry = registry;
    }

    public static BlockBuffer load(PacketDataSerializer friendlyByteBuf, RegistryBlockID<IBlockData> registry, Player player) {
        long index;
        BlockBuffer buffer = new BlockBuffer(registry);
        long totalBlockEntities = 0L;
        long totalBlockEntityBytes = 0L;
        while ((index = friendlyByteBuf.readLong()) != AxiomConstants.MIN_POSITION_LONG) {
            DataPaletteBlock<IBlockData> palettedContainer = buffer.getOrCreateSection(index);
            UnknownVersionHelper.readPalettedContainerUnknown(friendlyByteBuf, palettedContainer, player);
            int blockEntitySize = Math.min(4096, friendlyByteBuf.m());
            if (blockEntitySize <= 0) continue;
            Short2ObjectOpenHashMap map = new Short2ObjectOpenHashMap(blockEntitySize);
            int startIndex = friendlyByteBuf.readerIndex();
            for (int i = 0; i < blockEntitySize; ++i) {
                short offset = friendlyByteBuf.readShort();
                CompressedBlockEntity blockEntity = CompressedBlockEntity.read(friendlyByteBuf);
                map.put(offset, (Object)blockEntity);
            }
            buffer.blockEntities.put(index, (Object)map);
            totalBlockEntities += (long)blockEntitySize;
            totalBlockEntityBytes += (long)(friendlyByteBuf.readerIndex() - startIndex);
        }
        buffer.totalBlockEntities = totalBlockEntities;
        buffer.totalBlockEntityBytes = totalBlockEntityBytes;
        return buffer;
    }

    public long getTotalBlockEntities() {
        return this.totalBlockEntities;
    }

    public long getTotalBlockEntityBytes() {
        return this.totalBlockEntityBytes;
    }

    @Nullable
    public Short2ObjectMap<CompressedBlockEntity> getBlockEntityChunkMap(long cpos) {
        return (Short2ObjectMap)this.blockEntities.get(cpos);
    }

    public IBlockData get(int x, int y, int z) {
        DataPaletteBlock<IBlockData> container = this.getSectionForCoord(x, y, z);
        if (container == null) {
            return null;
        }
        IBlockData state = (IBlockData)container.a(x & 0xF, y & 0xF, z & 0xF);
        if (state == EMPTY_STATE) {
            return null;
        }
        return state;
    }

    public int getSectionCount() {
        return this.values.size();
    }

    public void set(int x, int y, int z, IBlockData state) {
        DataPaletteBlock<IBlockData> container = this.getOrCreateSectionForCoord(x, y, z);
        IBlockData old = (IBlockData)container.a(x & 0xF, y & 0xF, z & 0xF, (Object)state);
    }

    public void set(int cx, int cy, int cz, int lx, int ly, int lz, IBlockData state) {
        DataPaletteBlock<IBlockData> container = this.getOrCreateSection(BlockPosition.a((int)cx, (int)cy, (int)cz));
        IBlockData old = (IBlockData)container.a(lx, ly, lz, (Object)state);
    }

    public IBlockData remove(int x, int y, int z) {
        DataPaletteBlock<IBlockData> container = this.getSectionForCoord(x, y, z);
        if (container == null) {
            return null;
        }
        IBlockData state = (IBlockData)container.a(x & 0xF, y & 0xF, z & 0xF);
        if (state == EMPTY_STATE) {
            return null;
        }
        container.c(x & 0xF, y & 0xF, z & 0xF, (Object)EMPTY_STATE);
        return state;
    }

    public ObjectSet<Long2ObjectMap.Entry<DataPaletteBlock<IBlockData>>> entrySet() {
        return this.values.long2ObjectEntrySet();
    }

    public DataPaletteBlock<IBlockData> getSectionForCoord(int x, int y, int z) {
        long id = BlockPosition.a((int)(x >> 4), (int)(y >> 4), (int)(z >> 4));
        if (id != this.lastId) {
            this.lastId = id;
            this.last = (DataPaletteBlock)this.values.get(id);
        }
        return this.last;
    }

    public DataPaletteBlock<IBlockData> getOrCreateSectionForCoord(int x, int y, int z) {
        long id = BlockPosition.a((int)(x >> 4), (int)(y >> 4), (int)(z >> 4));
        return this.getOrCreateSection(id);
    }

    public DataPaletteBlock<IBlockData> getOrCreateSection(long id) {
        if (this.last == null || id != this.lastId) {
            this.lastId = id;
            this.last = (DataPaletteBlock)this.values.computeIfAbsent(id, k -> new DataPaletteBlock(this.registry, (Object)EMPTY_STATE, DataPaletteBlock.d.d));
        }
        return this.last;
    }
}

