/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buffer;

import com.moulberry.axiom.buffer.Position2ByteMap;
import com.moulberry.axiom.buffer.PositionConsumer;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;

public class BiomeBuffer {
    public final Position2ByteMap map;
    private final ResourceKey<BiomeBase>[] palette;
    private final Object2ByteMap<ResourceKey<BiomeBase>> paletteReverse;
    private int paletteSize = 0;

    public BiomeBuffer() {
        this.map = new Position2ByteMap();
        this.palette = new ResourceKey[255];
        this.paletteReverse = new Object2ByteOpenHashMap();
    }

    private BiomeBuffer(Position2ByteMap map, ResourceKey<BiomeBase>[] palette, Object2ByteMap<ResourceKey<BiomeBase>> paletteReverse) {
        this.map = map;
        this.palette = palette;
        this.paletteReverse = paletteReverse;
        this.paletteSize = this.paletteReverse.size();
    }

    public int getSectionCount() {
        return this.map.size();
    }

    public void save(PacketDataSerializer friendlyByteBuf) {
        friendlyByteBuf.writeByte(this.paletteSize);
        for (int i = 0; i < this.paletteSize; ++i) {
            friendlyByteBuf.b(this.palette[i]);
        }
        this.map.save(friendlyByteBuf);
    }

    public static BiomeBuffer load(PacketDataSerializer friendlyByteBuf) {
        int paletteSize = friendlyByteBuf.readByte();
        ResourceKey[] palette = new ResourceKey[255];
        Object2ByteOpenHashMap paletteReverse = new Object2ByteOpenHashMap();
        for (int i = 0; i < paletteSize; ++i) {
            ResourceKey key;
            palette[i] = key = friendlyByteBuf.a(Registries.ap);
            paletteReverse.put((Object)key, (byte)(i + 1));
        }
        Position2ByteMap map = Position2ByteMap.load(friendlyByteBuf);
        return new BiomeBuffer(map, palette, (Object2ByteMap<ResourceKey<BiomeBase>>)paletteReverse);
    }

    public void clear() {
        this.map.clear();
    }

    public void forEachEntry(PositionConsumer<ResourceKey<BiomeBase>> consumer) {
        this.map.forEachEntry((int x, int y, int z, byte v) -> {
            if (v != 0) {
                consumer.accept(x, y, z, this.palette[(v & 0xFF) - 1]);
            }
        });
    }

    public ResourceKey<BiomeBase> get(int quartX, int quartY, int quartZ) {
        int index = this.map.get(quartX, quartY, quartZ) & 0xFF;
        if (index == 0) {
            return null;
        }
        return this.palette[index - 1];
    }

    private int getPaletteIndex(ResourceKey<BiomeBase> biome) {
        int index = this.paletteReverse.getOrDefault(biome, (byte)0) & 0xFF;
        if (index != 0) {
            return index;
        }
        if ((index = this.paletteSize++) >= this.palette.length) {
            throw new UnsupportedOperationException("Too many biomes! :(");
        }
        this.palette[index] = biome;
        this.paletteReverse.put(biome, (byte)(index + 1));
        return index + 1;
    }

    public void set(int quartX, int quartY, int quartZ, ResourceKey<BiomeBase> biome) {
        this.map.put(quartX, quartY, quartZ, (byte)this.getPaletteIndex(biome));
    }
}

