/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.blueprint;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.blueprint.BlockEntityMap;
import com.moulberry.axiom.blueprint.BlueprintHeader;
import com.moulberry.axiom.blueprint.DFUHelper;
import com.moulberry.axiom.blueprint.RawBlueprint;
import com.moulberry.axiom.buffer.BlockBuffer;
import com.moulberry.axiom.buffer.CompressedBlockEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.DataPaletteBlock;

public class BlueprintIo {
    private static final int MAGIC = 182827830;
    private static final IOException NOT_VALID_BLUEPRINT = new IOException("Not a valid Blueprint");

    public static BlueprintHeader readHeader(InputStream inputStream) throws IOException {
        if (inputStream.available() < 4) {
            throw NOT_VALID_BLUEPRINT;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int magic = dataInputStream.readInt();
        if (magic != 182827830) {
            throw NOT_VALID_BLUEPRINT;
        }
        dataInputStream.readInt();
        NBTTagCompound headerTag = NBTCompressedStreamTools.a((DataInput)dataInputStream);
        return BlueprintHeader.load(headerTag);
    }

    public static RawBlueprint readRawBlueprint(InputStream inputStream) throws IOException {
        if (inputStream.available() < 4) {
            throw NOT_VALID_BLUEPRINT;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int magic = dataInputStream.readInt();
        if (magic != 182827830) {
            throw NOT_VALID_BLUEPRINT;
        }
        dataInputStream.readInt();
        NBTTagCompound headerTag = NBTCompressedStreamTools.a((DataInput)dataInputStream);
        BlueprintHeader header = BlueprintHeader.load(headerTag);
        int thumbnailLength = dataInputStream.readInt();
        byte[] thumbnailBytes = dataInputStream.readNBytes(thumbnailLength);
        if (thumbnailBytes.length < thumbnailLength) {
            throw NOT_VALID_BLUEPRINT;
        }
        int currentDataVersion = SharedConstants.b().d().c();
        dataInputStream.readInt();
        NBTTagCompound blockDataTag = NBTCompressedStreamTools.a((InputStream)dataInputStream);
        int blueprintDataVersion = blockDataTag.h("DataVersion");
        if (blueprintDataVersion == 0) {
            blueprintDataVersion = currentDataVersion;
        }
        NBTTagList listTag = blockDataTag.c("BlockRegion", 10);
        Long2ObjectMap<DataPaletteBlock<IBlockData>> blockMap = BlueprintIo.readBlocks(listTag, blueprintDataVersion, header.emptyBlockState());
        NBTTagList blockEntitiesTag = blockDataTag.c("BlockEntities", 10);
        Long2ObjectOpenHashMap blockEntities = new Long2ObjectOpenHashMap();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (NBTBase tag : blockEntitiesTag) {
            DataPaletteBlock container;
            IBlockData blockState;
            NBTTagCompound blockEntityCompound = (NBTTagCompound)tag;
            if (blueprintDataVersion != currentDataVersion) {
                Dynamic dynamic = new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)blockEntityCompound);
                Dynamic output = DataConverterRegistry.a().update(DataConverterTypes.l, dynamic, blueprintDataVersion, currentDataVersion);
                blockEntityCompound = (NBTTagCompound)output.getValue();
            }
            BlockPosition blockPos = TileEntity.c((NBTTagCompound)blockEntityCompound);
            long pos = blockPos.a();
            String id = blockEntityCompound.l("id");
            TileEntityTypes type = (TileEntityTypes)BuiltInRegistries.l.a(VersionHelper.createResourceLocation(id));
            if (type == null || !type.a(blockState = (IBlockData)(container = (DataPaletteBlock)blockMap.get(BlockPosition.a((int)(blockPos.u() >> 4), (int)(blockPos.v() >> 4), (int)(blockPos.w() >> 4)))).a(blockPos.u() & 0xF, blockPos.v() & 0xF, blockPos.w() & 0xF))) continue;
            NBTTagCompound newTag = blockEntityCompound.h();
            newTag.r("x");
            newTag.r("y");
            newTag.r("z");
            newTag.r("id");
            CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(newTag, baos);
            blockEntities.put(pos, (Object)compressedBlockEntity);
        }
        NBTTagList entitiesTag = blockDataTag.c("Entities", 10);
        ArrayList<NBTTagCompound> entities = new ArrayList<NBTTagCompound>();
        for (NBTBase tag : entitiesTag) {
            NBTTagCompound entityCompound = (NBTTagCompound)tag;
            if (blueprintDataVersion != currentDataVersion) {
                Dynamic dynamic = new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)entityCompound);
                Dynamic output = DataConverterRegistry.a().update(DataConverterTypes.q, dynamic, blueprintDataVersion, currentDataVersion);
                entityCompound = (NBTTagCompound)output.getValue();
            }
            entities.add(entityCompound);
        }
        return new RawBlueprint(header, thumbnailBytes, blockMap, (Long2ObjectMap<CompressedBlockEntity>)blockEntities, entities);
    }

    public static Long2ObjectMap<DataPaletteBlock<IBlockData>> readBlocks(NBTTagList list, int dataVersion, IBlockData empty) {
        Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
        Codec<DataPaletteBlock<IBlockData>> containerCodec = BlockBuffer.getCodecForEmptyBlockState(empty);
        for (NBTBase tag : list) {
            if (!(tag instanceof NBTTagCompound)) continue;
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            int cx = compoundTag.h("X");
            int cy = compoundTag.h("Y");
            int cz = compoundTag.h("Z");
            NBTTagCompound blockStates = compoundTag.p("BlockStates");
            blockStates = DFUHelper.updatePalettedContainer(blockStates, dataVersion);
            DataPaletteBlock container = (DataPaletteBlock)containerCodec.parse((DynamicOps)DynamicOpsNBT.a, (Object)blockStates).getOrThrow(false, err -> {});
            map.put(BlockPosition.a((int)cx, (int)cy, (int)cz), (Object)container);
        }
        return map;
    }

    public static void writeRaw(OutputStream outputStream, RawBlueprint rawBlueprint) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(182827830);
        NBTTagCompound headerTag = rawBlueprint.header().save(new NBTTagCompound());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream os = new DataOutputStream(baos);){
            NBTCompressedStreamTools.a((NBTTagCompound)headerTag, (DataOutput)os);
        }
        dataOutputStream.writeInt(baos.size());
        baos.writeTo(dataOutputStream);
        dataOutputStream.writeInt(rawBlueprint.thumbnail().length);
        dataOutputStream.write(rawBlueprint.thumbnail());
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList savedBlockRegions = new NBTTagList();
        Codec<DataPaletteBlock<IBlockData>> blockStateCodec = BlockBuffer.getCodecForEmptyBlockState(rawBlueprint.header().emptyBlockState());
        for (Long2ObjectMap.Entry entry : rawBlueprint.blocks().long2ObjectEntrySet()) {
            long pos2 = entry.getLongKey();
            DataPaletteBlock container = (DataPaletteBlock)entry.getValue();
            int cx = BlockPosition.a((long)pos2);
            int cy = BlockPosition.b((long)pos2);
            int cz = BlockPosition.c((long)pos2);
            NBTTagCompound tag = new NBTTagCompound();
            tag.a("X", cx);
            tag.a("Y", cy);
            tag.a("Z", cz);
            NBTBase encoded = (NBTBase)blockStateCodec.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)container).getOrThrow(false, err -> {});
            tag.a("BlockStates", encoded);
            savedBlockRegions.add((Object)tag);
        }
        compound.a("DataVersion", SharedConstants.b().d().c());
        compound.a("BlockRegion", (NBTBase)savedBlockRegions);
        NBTTagList blockEntitiesTag = new NBTTagList();
        rawBlueprint.blockEntities().forEach((pos, compressedBlockEntity) -> {
            int x = BlockPosition.a((long)pos);
            int y = BlockPosition.b((long)pos);
            int z = BlockPosition.c((long)pos);
            DataPaletteBlock container = (DataPaletteBlock)rawBlueprint.blocks().get(BlockPosition.a((int)(x >> 4), (int)(y >> 4), (int)(z >> 4)));
            IBlockData blockState = (IBlockData)container.a(x & 0xF, y & 0xF, z & 0xF);
            TileEntityTypes<?> type = BlockEntityMap.get(blockState.b());
            if (type == null) {
                return;
            }
            MinecraftKey resourceLocation = TileEntityTypes.a(type);
            if (resourceLocation != null) {
                NBTTagCompound tag = compressedBlockEntity.decompress();
                tag.a("x", x);
                tag.a("y", y);
                tag.a("z", z);
                tag.a("id", resourceLocation.toString());
                blockEntitiesTag.add((Object)tag);
            }
        });
        compound.a("BlockEntities", (NBTBase)blockEntitiesTag);
        NBTTagList entitiesTag = new NBTTagList();
        entitiesTag.addAll(rawBlueprint.entities());
        compound.a("Entities", (NBTBase)entitiesTag);
        baos.reset();
        NBTCompressedStreamTools.a((NBTTagCompound)compound, (OutputStream)baos);
        dataOutputStream.writeInt(baos.size());
        baos.writeTo(dataOutputStream);
    }
}

