/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.blueprint;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public record BlueprintHeader(int version, String name, String author, List<String> tags, float thumbnailYaw, float thumbnailPitch, boolean lockedThumbnail, int blockCount, boolean containsAir) {
    public static final int CURRENT_VERSION = 2;

    public IBlockData emptyBlockState() {
        if (this.version <= 1) {
            return Blocks.kN.n();
        }
        return Blocks.nb.n();
    }

    public void write(PacketDataSerializer friendlyByteBuf) {
        friendlyByteBuf.d(2);
        friendlyByteBuf.a(this.name);
        friendlyByteBuf.a(this.author);
        friendlyByteBuf.a(this.tags, PacketDataSerializer::a);
        friendlyByteBuf.writeInt(this.blockCount);
        friendlyByteBuf.writeBoolean(this.containsAir);
    }

    public static BlueprintHeader read(PacketDataSerializer friendlyByteBuf) {
        int version = friendlyByteBuf.m();
        String name = friendlyByteBuf.s();
        String author = friendlyByteBuf.s();
        List tags = friendlyByteBuf.a(PacketDataSerializer::s);
        int blockCount = friendlyByteBuf.readInt();
        boolean containsAir = friendlyByteBuf.readBoolean();
        return new BlueprintHeader(version, name, author, tags, 0.0f, 0.0f, true, blockCount, containsAir);
    }

    public static BlueprintHeader load(NBTTagCompound tag) {
        int version = tag.h("Version");
        String name = tag.l("Name");
        String author = tag.l("Author");
        float thumbnailYaw = tag.b("ThumbnailYaw", 5) ? tag.j("ThumbnailYaw") : 135.0f;
        float thumbnailPitch = tag.b("ThumbnailPitch", 5) ? tag.j("ThumbnailPitch") : 30.0f;
        boolean lockedThumbnail = tag.q("LockedThumbnail");
        int blockCount = tag.h("BlockCount");
        boolean containsAir = tag.q("ContainsAir");
        ArrayList<String> tags = new ArrayList<String>();
        for (NBTBase string : tag.c("Tags", 8)) {
            tags.add(string.m_());
        }
        return new BlueprintHeader(version, name, author, tags, thumbnailYaw, thumbnailPitch, lockedThumbnail, blockCount, containsAir);
    }

    public NBTTagCompound save(NBTTagCompound tag) {
        NBTTagList listTag = new NBTTagList();
        for (String string : this.tags) {
            listTag.add((Object)NBTTagString.a((String)string));
        }
        tag.a("Version", 2);
        tag.a("Name", this.name);
        tag.a("Author", this.author);
        tag.a("Tags", (NBTBase)listTag);
        tag.a("ThumbnailYaw", this.thumbnailYaw);
        tag.a("ThumbnailPitch", this.thumbnailPitch);
        tag.a("LockedThumbnail", this.lockedThumbnail);
        tag.a("BlockCount", this.blockCount);
        tag.a("ContainsAir", this.containsAir);
        return tag;
    }
}

