/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.annotations.data;

import com.moulberry.axiom.annotations.data.AnnotationData;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.PacketDataSerializer;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record ImageAnnotationData(String imageUrl, Vector3f position, Quaternionf rotation, EnumDirection direction, float fallbackYaw, float width, float opacity, int billboardMode) implements AnnotationData
{
    @Override
    public void setPosition(Vector3f position) {
        this.position.set((Vector3fc)position);
    }

    @Override
    public void setRotation(Quaternionf rotation) {
        this.rotation.set((Quaternionfc)rotation);
    }

    @Override
    public void write(PacketDataSerializer friendlyByteBuf) {
        friendlyByteBuf.writeByte(2);
        friendlyByteBuf.a(this.imageUrl);
        friendlyByteBuf.writeFloat(this.position.x);
        friendlyByteBuf.writeFloat(this.position.y);
        friendlyByteBuf.writeFloat(this.position.z);
        friendlyByteBuf.writeFloat(this.rotation.x);
        friendlyByteBuf.writeFloat(this.rotation.y);
        friendlyByteBuf.writeFloat(this.rotation.z);
        friendlyByteBuf.writeFloat(this.rotation.w);
        friendlyByteBuf.writeByte(this.direction.d());
        friendlyByteBuf.writeFloat(this.fallbackYaw);
        friendlyByteBuf.writeFloat(this.width);
        friendlyByteBuf.writeFloat(this.opacity);
        friendlyByteBuf.writeByte(this.billboardMode);
    }

    public static ImageAnnotationData read(PacketDataSerializer friendlyByteBuf) {
        String imageUrl = friendlyByteBuf.s();
        float x = friendlyByteBuf.readFloat();
        float y = friendlyByteBuf.readFloat();
        float z = friendlyByteBuf.readFloat();
        float rotX = friendlyByteBuf.readFloat();
        float rotY = friendlyByteBuf.readFloat();
        float rotZ = friendlyByteBuf.readFloat();
        float rotW = friendlyByteBuf.readFloat();
        EnumDirection direction = EnumDirection.a((int)friendlyByteBuf.readByte());
        float fallbackYaw = friendlyByteBuf.readFloat();
        float width = friendlyByteBuf.readFloat();
        float opacity = friendlyByteBuf.readFloat();
        byte billboardMode = friendlyByteBuf.readByte();
        return new ImageAnnotationData(imageUrl, new Vector3f(x, y, z), new Quaternionf(rotX, rotY, rotZ, rotW), direction, fallbackYaw, width, opacity, billboardMode);
    }
}

