/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.annotations;

import com.moulberry.axiom.annotations.data.AnnotationData;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface AnnotationUpdateAction {
    public void write(PacketDataSerializer var1);

    public static AnnotationUpdateAction read(PacketDataSerializer friendlyByteBuf) {
        byte type = friendlyByteBuf.readByte();
        if (type == 0) {
            UUID uuid = friendlyByteBuf.o();
            AnnotationData annotationData = AnnotationData.read(friendlyByteBuf);
            if (annotationData == null) {
                return null;
            }
            return new CreateAnnotation(uuid, annotationData);
        }
        if (type == 1) {
            return new DeleteAnnotation(friendlyByteBuf.o());
        }
        if (type == 2) {
            return new MoveAnnotation(friendlyByteBuf.o(), new Vector3f(friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat()));
        }
        if (type == 3) {
            return new ClearAllAnnotations();
        }
        if (type == 4) {
            return new RotateAnnotation(friendlyByteBuf.o(), new Quaternionf(friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat()));
        }
        return null;
    }

    public record CreateAnnotation(UUID uuid, AnnotationData annotationData) implements AnnotationUpdateAction
    {
        @Override
        public void write(PacketDataSerializer friendlyByteBuf) {
            friendlyByteBuf.writeByte(0);
            friendlyByteBuf.a(this.uuid);
            this.annotationData.write(friendlyByteBuf);
        }
    }

    public record DeleteAnnotation(UUID uuid) implements AnnotationUpdateAction
    {
        @Override
        public void write(PacketDataSerializer friendlyByteBuf) {
            friendlyByteBuf.writeByte(1);
            friendlyByteBuf.a(this.uuid);
        }
    }

    public record MoveAnnotation(UUID uuid, Vector3f to) implements AnnotationUpdateAction
    {
        @Override
        public void write(PacketDataSerializer friendlyByteBuf) {
            friendlyByteBuf.writeByte(2);
            friendlyByteBuf.a(this.uuid);
            friendlyByteBuf.writeFloat(this.to.x);
            friendlyByteBuf.writeFloat(this.to.y);
            friendlyByteBuf.writeFloat(this.to.z);
        }
    }

    public record ClearAllAnnotations() implements AnnotationUpdateAction
    {
        @Override
        public void write(PacketDataSerializer friendlyByteBuf) {
            friendlyByteBuf.writeByte(3);
        }
    }

    public record RotateAnnotation(UUID uuid, Quaternionf to) implements AnnotationUpdateAction
    {
        @Override
        public void write(PacketDataSerializer friendlyByteBuf) {
            friendlyByteBuf.writeByte(4);
            friendlyByteBuf.a(this.uuid);
            friendlyByteBuf.writeFloat(this.to.x);
            friendlyByteBuf.writeFloat(this.to.y);
            friendlyByteBuf.writeFloat(this.to.z);
            friendlyByteBuf.writeFloat(this.to.w);
        }
    }
}

