/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.annotations.ServerAnnotations;
import com.moulberry.axiom.marker.MarkerData;
import com.moulberry.axiom.paperapi.entity.ImplAxiomHiddenEntities;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class WorldExtension {
    private static final Map<ResourceKey<World>, WorldExtension> extensions = new HashMap<ResourceKey<World>, WorldExtension>();
    private WorldServer level;
    private final LongSet pendingChunksToSend = new LongOpenHashSet();
    private final LongSet pendingChunksToLight = new LongOpenHashSet();
    private final Map<UUID, MarkerData> previousMarkerData = new HashMap<UUID, MarkerData>();

    public static WorldExtension get(WorldServer serverLevel) {
        WorldExtension extension = extensions.computeIfAbsent((ResourceKey<World>)serverLevel.ac(), k -> new WorldExtension());
        extension.level = serverLevel;
        return extension;
    }

    public static void onPlayerJoin(org.bukkit.World world, Player player) {
        WorldServer level = ((CraftWorld)world).getHandle();
        WorldExtension.get(level).onPlayerJoin(player);
        if (AxiomPaper.PLUGIN.canUseAxiom(player)) {
            ServerAnnotations.sendAll(world, ((CraftPlayer)player).getHandle());
        }
    }

    public static void tick(MinecraftServer server, boolean sendMarkers, int maxChunkRelightsPerTick, int maxChunkSendsPerTick) {
        extensions.keySet().retainAll(server.E());
        for (WorldServer level : server.F()) {
            WorldExtension.get(level).tick(sendMarkers, maxChunkRelightsPerTick, maxChunkSendsPerTick);
        }
    }

    public void sendChunk(int cx, int cz) {
        this.pendingChunksToSend.add(ChunkCoordIntPair.c((int)cx, (int)cz));
    }

    public void lightChunk(int cx, int cz) {
        this.pendingChunksToLight.add(ChunkCoordIntPair.c((int)cx, (int)cz));
    }

    public void onPlayerJoin(Player player) {
        if (!this.previousMarkerData.isEmpty()) {
            ArrayList<MarkerData> markerData = new ArrayList<MarkerData>(this.previousMarkerData.values());
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.a(markerData, MarkerData::write);
            buf.a(Set.of(), (buffer, uuid) -> buffer.a(uuid));
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
            VersionHelper.sendCustomPayload(player, "axiom:marker_data", bytes);
        }
        try {
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            if (this.level.chunkPacketBlockController.shouldModify(serverPlayer, this.level.getChunkIfLoaded(serverPlayer.di()))) {
                TextComponent text = Component.text((String)"Axiom: Warning, anti-xray is enabled. This will cause issues when copying blocks. Please turn anti-xray off");
                player.sendMessage(text.color((TextColor)NamedTextColor.RED));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void tick(boolean sendMarkers, int maxChunkRelightsPerTick, int maxChunkSendsPerTick) {
        if (sendMarkers) {
            this.tickMarkers();
        }
        this.tickChunkRelight(maxChunkRelightsPerTick, maxChunkSendsPerTick);
    }

    private void tickMarkers() {
        ArrayList<MarkerData> changedData = new ArrayList<MarkerData>();
        HashSet<UUID> allMarkers = new HashSet<UUID>();
        for (Entity entity : this.level.E().a()) {
            MarkerData previousData;
            Marker marker;
            if (!(entity instanceof Marker) || ImplAxiomHiddenEntities.isMarkerHidden((org.bukkit.entity.Marker)(marker = (Marker)entity).getBukkitEntity())) continue;
            MarkerData currentData = MarkerData.createFrom(marker);
            if (!Objects.equals(currentData, previousData = this.previousMarkerData.get(marker.ct()))) {
                this.previousMarkerData.put(marker.ct(), currentData);
                changedData.add(currentData);
            }
            allMarkers.add(marker.ct());
        }
        HashSet<UUID> missingUuids = new HashSet<UUID>(this.previousMarkerData.keySet());
        missingUuids.removeAll(allMarkers);
        this.previousMarkerData.keySet().removeAll(missingUuids);
        if (!changedData.isEmpty() || !missingUuids.isEmpty()) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.a(changedData, MarkerData::write);
            buf.a(missingUuids, (buffer, uuid) -> buffer.a(uuid));
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
            ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
            for (EntityPlayer player : this.level.v()) {
                if (!AxiomPaper.PLUGIN.canUseAxiom((Player)player.getBukkitEntity())) continue;
                players.add(player);
            }
            VersionHelper.sendCustomPayloadToAll(players, "axiom:marker_data", bytes);
        }
    }

    private void tickChunkRelight(int maxChunkRelightsPerTick, int maxChunkSendsPerTick) {
        PlayerChunkMap chunkMap = this.level.k().a;
        boolean sendAll = maxChunkSendsPerTick <= 0;
        LongIterator longIterator = this.pendingChunksToSend.longIterator();
        while (longIterator.hasNext()) {
            List players;
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(longIterator.nextLong());
            Chunk chunk = this.level.getChunkIfLoaded(chunkPos.e, chunkPos.f);
            if (chunk == null || (players = chunkMap.a(chunkPos, false)).isEmpty()) continue;
            ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(chunk, this.level.s_(), null, null, false);
            for (EntityPlayer player : players) {
                player.c.a((Packet)packet);
            }
            if (sendAll) continue;
            longIterator.remove();
            if (--maxChunkSendsPerTick > 0) continue;
            break;
        }
        if (sendAll) {
            this.pendingChunksToSend.clear();
        }
        HashSet<ChunkCoordIntPair> chunkSet = new HashSet<ChunkCoordIntPair>();
        longIterator = this.pendingChunksToLight.longIterator();
        if (maxChunkRelightsPerTick <= 0) {
            while (longIterator.hasNext()) {
                chunkSet.add(new ChunkCoordIntPair(longIterator.nextLong()));
            }
            this.pendingChunksToLight.clear();
        } else {
            while (longIterator.hasNext()) {
                chunkSet.add(new ChunkCoordIntPair(longIterator.nextLong()));
                longIterator.remove();
                if (--maxChunkRelightsPerTick > 0) continue;
            }
        }
        this.level.k().a().relight(chunkSet, pos -> {}, count -> {});
    }
}

