/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.network.PacketDataSerializer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class ServerHeightmaps {
    private static List<NamedImage> heightmaps = new ArrayList<NamedImage>();

    public static void load(Path path) {
        heightmaps.clear();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path imagePath : directoryStream) {
                try {
                    BufferedImage image = ImageIO.read(Files.newInputStream(imagePath, new OpenOption[0]));
                    if (image == null) continue;
                    byte[] allBytes = Files.readAllBytes(imagePath);
                    if (allBytes.length > 2000000) {
                        Path relative = path.relativize(imagePath);
                        AxiomPaper.PLUGIN.getLogger().info("Heightmap " + relative + " skipped because it's over 2mb");
                        continue;
                    }
                    heightmaps.add(new NamedImage(imagePath.getFileName().toString(), allBytes));
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendTo(Player player) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        for (NamedImage heightmap : heightmaps) {
            buf.a(heightmap.name);
            buf.a(heightmap.imageBytes);
            byte[] packetBytes = ByteBufUtil.getBytes((ByteBuf)buf);
            VersionHelper.sendCustomPayload(((CraftPlayer)player).getHandle(), "axiom:add_server_heightmap", packetBytes);
            buf.clear();
        }
    }

    private record NamedImage(String name, byte[] imageBytes) {
    }
}

