/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.AxiomReflection;
import com.moulberry.axiom.DisallowedBlocks;
import com.moulberry.axiom.ServerHeightmaps;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.WorldExtension;
import com.moulberry.axiom.blueprint.ServerBlueprintManager;
import com.moulberry.axiom.buffer.CompressedBlockEntity;
import com.moulberry.axiom.commands.AxiomDebugCommand;
import com.moulberry.axiom.commands.AxiomMigrateCommand;
import com.moulberry.axiom.event.AxiomCreateWorldPropertiesEvent;
import com.moulberry.axiom.event.AxiomModifyWorldEvent;
import com.moulberry.axiom.integration.coreprotect.CoreProtectIntegration;
import com.moulberry.axiom.integration.plotsquared.PlotSquaredIntegration;
import com.moulberry.axiom.listener.LuckPermsListener;
import com.moulberry.axiom.listener.NoPhysicalTriggerListener;
import com.moulberry.axiom.operations.OperationQueue;
import com.moulberry.axiom.operations.PendingOperation;
import com.moulberry.axiom.packet.AxiomBigPayloadHandler;
import com.moulberry.axiom.packet.DummyPacketListener;
import com.moulberry.axiom.packet.PacketHandler;
import com.moulberry.axiom.packet.WrapperPacketListener;
import com.moulberry.axiom.packet.impl.BlueprintRequestPacketListener;
import com.moulberry.axiom.packet.impl.DeleteEntityPacketListener;
import com.moulberry.axiom.packet.impl.HelloPacketListener;
import com.moulberry.axiom.packet.impl.ManipulateEntityPacketListener;
import com.moulberry.axiom.packet.impl.MarkerNbtRequestPacketListener;
import com.moulberry.axiom.packet.impl.RequestChunkDataPacketListener;
import com.moulberry.axiom.packet.impl.RequestEntityDataPacketListener;
import com.moulberry.axiom.packet.impl.SetBlockBufferPacketListener;
import com.moulberry.axiom.packet.impl.SetBlockPacketListener;
import com.moulberry.axiom.packet.impl.SetFlySpeedPacketListener;
import com.moulberry.axiom.packet.impl.SetGamemodePacketListener;
import com.moulberry.axiom.packet.impl.SetNoPhysicalTriggerPacketListener;
import com.moulberry.axiom.packet.impl.SetTimePacketListener;
import com.moulberry.axiom.packet.impl.SetWorldPropertyListener;
import com.moulberry.axiom.packet.impl.SpawnEntityPacketListener;
import com.moulberry.axiom.packet.impl.TeleportPacketListener;
import com.moulberry.axiom.packet.impl.UpdateAnnotationPacketListener;
import com.moulberry.axiom.packet.impl.UploadBlueprintPacketListener;
import com.moulberry.axiom.paperapi.block.ImplServerCustomBlocks;
import com.moulberry.axiom.paperapi.display.ImplServerCustomDisplays;
import com.moulberry.axiom.paperapi.entity.ImplAxiomHiddenEntities;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.restrictions.AxiomPermissionSet;
import com.moulberry.axiom.restrictions.Restrictions;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertiesRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.papermc.paper.event.player.PlayerFailMoveEvent;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import io.papermc.paper.network.ChannelInitializeListener;
import io.papermc.paper.network.ChannelInitializeListenerHolder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntFunction;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.TriState;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.game.PacketPlayInCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.jetbrains.annotations.Nullable;

public class AxiomPaper
extends JavaPlugin
implements Listener {
    public static AxiomPaper PLUGIN;
    public final Set<UUID> activeAxiomPlayers = Collections.newSetFromMap(new ConcurrentHashMap());
    public final Set<UUID> failedPermissionAxiomPlayers = Collections.newSetFromMap(new ConcurrentHashMap());
    public final Map<UUID, Restrictions> playerRestrictions = new ConcurrentHashMap<UUID, Restrictions>();
    public final Map<UUID, RegistryBlockID<IBlockData>> playerBlockRegistry = new ConcurrentHashMap<UUID, RegistryBlockID<IBlockData>>();
    public final Map<UUID, Integer> playerProtocolVersion = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, AxiomPermissionSet> playerPermissions = new HashMap<UUID, AxiomPermissionSet>();
    private final Map<UUID, PlotSquaredIntegration.PlotBounds> lastPlotBoundsForPlayers = new HashMap<UUID, PlotSquaredIntegration.PlotBounds>();
    private final Set<UUID> noPhysicalTriggerPlayers = new HashSet<UUID>();
    private final OperationQueue operationQueue = new OperationQueue();
    private final Object2IntOpenHashMap<UUID> availableDispatchSends = new Object2IntOpenHashMap();
    public Configuration configuration;
    public RegistryBlockID<IBlockData> allowedBlockRegistry = null;
    private boolean logLargeBlockBufferChanges = false;
    private int packetCollectionReadLimit = 1024;
    private long maxNbtDecompressLimit = 131072L;
    private final Set<EntityTypes<?>> whitelistedEntities = new HashSet();
    private final Set<EntityTypes<?>> blacklistedEntities = new HashSet();
    private int defaultAllowedDispatchSendsPerSecond = 1024;
    private LinkedHashMap<String, Integer> allowedDispatchSendOverrides = new LinkedHashMap();
    private boolean registeredNoPhysicalTriggerListener = false;
    public boolean logCoreProtectChanges = true;
    public Path blueprintFolder = null;
    public boolean allowAnnotations = false;
    private int infiniteReachLimit = -1;
    private boolean sendMarkers = false;
    private int maxChunkRelightsPerTick = 0;
    private int maxChunkSendsPerTick = 0;
    private int maxChunkLoadDistance = 256;
    public int configRemovedEntries = 0;
    public int configAddedEntries = 0;
    private boolean clearCachedPermissionsOnTick = true;
    private int checkAxiomEnableDisableTimer = 0;
    private final WeakHashMap<World, ServerWorldPropertiesRegistry> worldProperties = new WeakHashMap();

    public void onEnable() {
        ConfigurationSection limits;
        PLUGIN = this;
        AxiomReflection.init();
        this.saveDefaultConfig();
        this.configuration = this.getConfig();
        Set<String> validResolutions = Set.of("kick", "warn", "ignore");
        if (!validResolutions.contains(this.configuration.getString("incompatible-data-version"))) {
            this.getLogger().warning("Invalid value for incompatible-data-version, expected 'kick', 'warn' or 'ignore'");
        }
        if (!validResolutions.contains(this.configuration.getString("unsupported-axiom-version"))) {
            this.getLogger().warning("Invalid value for unsupported-axiom-version, expected 'kick', 'warn' or 'ignore'");
        }
        this.checkOutdatedConfig();
        this.logLargeBlockBufferChanges = this.configuration.getBoolean("log-large-block-buffer-changes");
        if (this.configuration.getBoolean("allow-large-payload-for-all-packets")) {
            this.packetCollectionReadLimit = Short.MAX_VALUE;
            this.maxNbtDecompressLimit = Long.MAX_VALUE;
        }
        this.whitelistedEntities.clear();
        this.blacklistedEntities.clear();
        for (String whitelistedEntity : this.configuration.getStringList("whitelist-entities")) {
            EntityTypes.a((String)whitelistedEntity).ifPresent(this.whitelistedEntities::add);
        }
        for (String blacklistedEntity : this.configuration.getStringList("blacklist-entities")) {
            EntityTypes.a((String)blacklistedEntity).ifPresent(this.blacklistedEntities::add);
        }
        List disallowedBlocks = this.configuration.getStringList("disallowed-blocks");
        this.allowedBlockRegistry = DisallowedBlocks.createAllowedBlockRegistry(disallowedBlocks);
        this.allowAnnotations = this.configuration.getBoolean("allow-annotations");
        boolean allowServerBlueprints = this.configuration.getBoolean("blueprint-sharing");
        this.infiniteReachLimit = this.configuration.getInt("infinite-reach-limit");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        CompressedBlockEntity.initialize(this);
        Messenger msg = Bukkit.getMessenger();
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:enable");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:response_chunk_data");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:register_world_properties");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:set_world_property");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:ack_world_properties");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:restrictions");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:marker_data");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:marker_nbt_response");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:annotation_update");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:add_server_heightmap");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:custom_blocks");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:register_custom_block_v2");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:ignore_display_entities");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:register_custom_items");
        final HashMap<String, PacketHandler> largePayloadHandlers = new HashMap<String, PacketHandler>();
        this.registerPacketHandler("hello", new HelloPacketListener(this), msg, LargePayloadBehaviour.FORCE_SMALL, largePayloadHandlers);
        this.registerPacketHandler("set_gamemode", new SetGamemodePacketListener(this), msg, LargePayloadBehaviour.FORCE_SMALL, largePayloadHandlers);
        this.registerPacketHandler("set_fly_speed", new SetFlySpeedPacketListener(this), msg, LargePayloadBehaviour.FORCE_SMALL, largePayloadHandlers);
        this.registerPacketHandler("teleport", new TeleportPacketListener(this), msg, LargePayloadBehaviour.FORCE_SMALL, largePayloadHandlers);
        this.registerPacketHandler("set_world_time", new SetTimePacketListener(this), msg, LargePayloadBehaviour.FORCE_SMALL, largePayloadHandlers);
        this.registerPacketHandler("set_no_physical_trigger", new SetNoPhysicalTriggerPacketListener(this), msg, LargePayloadBehaviour.FORCE_SMALL, largePayloadHandlers);
        this.registerPacketHandler("set_world_property", new SetWorldPropertyListener(this), msg, LargePayloadBehaviour.FORCE_SMALL, largePayloadHandlers);
        this.registerPacketHandler("request_chunk_data", new RequestChunkDataPacketListener(this), msg, this.configuration.getBoolean("allow-large-chunk-data-request") ? LargePayloadBehaviour.FORCE_LARGE : LargePayloadBehaviour.DEFAULT, largePayloadHandlers);
        this.registerPacketHandler("request_entity_data", new RequestEntityDataPacketListener(this), msg, this.configuration.getBoolean("allow-large-chunk-data-request") ? LargePayloadBehaviour.FORCE_LARGE : LargePayloadBehaviour.DEFAULT, largePayloadHandlers);
        this.registerPacketHandler("spawn_entity", new SpawnEntityPacketListener(this), msg, LargePayloadBehaviour.DEFAULT, largePayloadHandlers);
        this.registerPacketHandler("manipulate_entity", new ManipulateEntityPacketListener(this), msg, LargePayloadBehaviour.DEFAULT, largePayloadHandlers);
        this.registerPacketHandler("delete_entity", new DeleteEntityPacketListener(this), msg, LargePayloadBehaviour.DEFAULT, largePayloadHandlers);
        this.registerPacketHandler("marker_nbt_request", new MarkerNbtRequestPacketListener(this), msg, LargePayloadBehaviour.FORCE_SMALL, largePayloadHandlers);
        this.registerPacketHandler("set_block", new SetBlockPacketListener(this), msg, LargePayloadBehaviour.DEFAULT, largePayloadHandlers);
        this.registerPacketHandler("set_buffer", new SetBlockBufferPacketListener(this), msg, LargePayloadBehaviour.FORCE_LARGE, largePayloadHandlers);
        if (allowServerBlueprints) {
            this.registerPacketHandler("upload_blueprint", new UploadBlueprintPacketListener(this), msg, LargePayloadBehaviour.FORCE_LARGE, largePayloadHandlers);
            this.registerPacketHandler("request_blueprint", new BlueprintRequestPacketListener(this), msg, LargePayloadBehaviour.FORCE_SMALL, largePayloadHandlers);
        }
        if (this.allowAnnotations) {
            this.registerPacketHandler("annotation_update", new UpdateAnnotationPacketListener(this), msg, LargePayloadBehaviour.FORCE_LARGE, largePayloadHandlers);
        }
        if (!largePayloadHandlers.isEmpty()) {
            ChannelInitializeListenerHolder.addListener((Key)Key.key((String)"axiom:handle_big_payload"), (ChannelInitializeListener)new ChannelInitializeListener(){

                public void afterInitChannel(@NonNull Channel channel) {
                    Int2ObjectMap packets = EnumProtocol.b.b(EnumProtocolDirection.a);
                    int payloadId = -1;
                    for (Map.Entry entry : packets.entrySet()) {
                        if (entry.getValue() != PacketPlayInCustomPayload.class) continue;
                        payloadId = (Integer)entry.getKey();
                        break;
                    }
                    if (payloadId < 0) {
                        throw new RuntimeException("Failed to find ServerboundCustomPayloadPacket id");
                    }
                    NetworkManager connection = (NetworkManager)channel.pipeline().get("packet_handler");
                    AxiomBigPayloadHandler.apply(channel.pipeline(), new AxiomBigPayloadHandler(payloadId, connection, largePayloadHandlers, true));
                }
            });
        }
        if (allowServerBlueprints) {
            this.blueprintFolder = this.getDataFolder().toPath().resolve("blueprints");
            try {
                Files.createDirectories(this.blueprintFolder, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ServerBlueprintManager.initialize(this.blueprintFolder);
        }
        Path heightmapsPath = this.getDataFolder().toPath().resolve("heightmaps");
        try {
            Files.createDirectories(heightmapsPath, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ServerHeightmaps.load(heightmapsPath);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::tick, 1L, 1L);
        this.sendMarkers = this.configuration.getBoolean("send-markers");
        this.maxChunkRelightsPerTick = this.configuration.getInt("max-chunk-relights-per-tick");
        this.maxChunkSendsPerTick = this.configuration.getInt("max-chunk-sends-per-tick");
        this.maxChunkLoadDistance = this.configuration.getInt("max-chunk-load-distance");
        this.logCoreProtectChanges = this.configuration.getBoolean("log-core-protect-changes");
        this.defaultAllowedDispatchSendsPerSecond = this.configuration.getInt("block-buffer-rate-limit");
        if (this.defaultAllowedDispatchSendsPerSecond <= 0) {
            this.defaultAllowedDispatchSendsPerSecond = 1024;
        }
        if ((limits = this.configuration.getConfigurationSection("limits")) != null) {
            for (String key : limits.getKeys(false)) {
                int allowedDispatchSends;
                ConfigurationSection values = limits.getConfigurationSection(key);
                if (values == null || (allowedDispatchSends = values.getInt("block-buffer-rate-limit")) <= 0) continue;
                this.allowedDispatchSendOverrides.put(key, allowedDispatchSends);
            }
        }
        try {
            LegacyPaperCommandManager<CommandSender> manager = LegacyPaperCommandManager.createNative((Plugin)this, ExecutionCoordinator.simpleCoordinator());
            if (manager.hasCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
                manager.registerBrigadier();
            }
            AxiomDebugCommand.register(this, manager);
            AxiomMigrateCommand.register(manager);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Bukkit.getPluginManager().isPluginEnabled("LuckPerms")) {
            this.getLogger().info("LuckPerms integration enabled");
            this.clearCachedPermissionsOnTick = false;
            LuckPermsListener.register(this);
        }
        if (CoreProtectIntegration.isEnabled()) {
            this.getLogger().info("CoreProtect integration enabled");
        }
    }

    private void checkOutdatedConfig() {
        this.configAddedEntries = 0;
        this.configRemovedEntries = 0;
        Configuration defaultConfig = this.configuration.getDefaults();
        if (defaultConfig == null) {
            return;
        }
        Set defaultKeys = defaultConfig.getKeys(false);
        Set currentKeys = this.configuration.getKeys(false);
        HashSet a2 = new HashSet(defaultKeys);
        a2.removeAll(currentKeys);
        this.configAddedEntries = a2.size();
        HashSet b2 = new HashSet(currentKeys);
        b2.removeAll(defaultKeys);
        this.configRemovedEntries = b2.size();
    }

    public void migrateConfig(CommandSender commandSender) {
        if (this.configAddedEntries == 0 && this.configRemovedEntries == 0) {
            commandSender.sendMessage(Component.text((String)"No migration necessary").color((TextColor)NamedTextColor.YELLOW));
            return;
        }
        this.configAddedEntries = 0;
        this.configRemovedEntries = 0;
        Configuration defaultConfig = this.configuration.getDefaults();
        if (!(defaultConfig instanceof FileConfiguration)) {
            commandSender.sendMessage(Component.text((String)"Internal error: Default config doesn't implement FileConfiguration").color((TextColor)NamedTextColor.RED));
            return;
        }
        FileConfiguration fileConfiguration = (FileConfiguration)defaultConfig;
        Path dataFolder = this.getDataFolder().toPath();
        Path configPath = dataFolder.resolve("config.yml");
        Path backupPath = dataFolder.resolve("config.yml.bak");
        if (!Files.exists(configPath, new LinkOption[0])) {
            commandSender.sendMessage(Component.text((String)"Internal error: config.yml doesn't exist").color((TextColor)NamedTextColor.RED));
            return;
        }
        try {
            Files.copy(configPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
            commandSender.sendMessage(Component.text((String)"Internal error: couldn't backup existing config").color((TextColor)NamedTextColor.RED));
            return;
        }
        commandSender.sendMessage(Component.text((String)"Successfully backed up current config to config.yml.bak").color((TextColor)NamedTextColor.GREEN));
        Set keys = defaultConfig.getKeys(false);
        for (String key : keys) {
            Object object = this.configuration.get(key);
            if (object == null) continue;
            fileConfiguration.set(key, object);
        }
        try {
            fileConfiguration.save(configPath.toFile());
        }
        catch (IOException e) {
            commandSender.sendMessage(Component.text((String)"Internal error: failed to save migrated config.yml").color((TextColor)NamedTextColor.RED));
            e.printStackTrace();
        }
        commandSender.sendMessage(Component.text((String)"Successfully migrated config.yml").color((TextColor)NamedTextColor.GREEN));
    }

    public int getMaxChunkLoadDistance(World world) {
        int maxChunkLoadDistance = this.maxChunkLoadDistance;
        if (PlotSquaredIntegration.isPlotWorld(world)) {
            maxChunkLoadDistance = 0;
        }
        return maxChunkLoadDistance;
    }

    public void clearCachedPermissionsFor(UUID uuid) {
        this.playerPermissions.remove(uuid);
    }

    private void tick() {
        if (this.clearCachedPermissionsOnTick) {
            this.playerPermissions.clear();
        }
        ++this.checkAxiomEnableDisableTimer;
        if (this.checkAxiomEnableDisableTimer >= 20) {
            this.checkAxiomEnableDisableTimer = 0;
            HashSet<UUID> stillActiveAxiomPlayers = new HashSet<UUID>();
            HashSet<UUID> stillFailedAxiomPlayers = new HashSet<UUID>();
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                UUID uuid = player.getUniqueId();
                if (this.activeAxiomPlayers.contains(uuid)) {
                    if (!this.hasPermission(player, AxiomPermission.USE)) {
                        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
                        buf.writeBoolean(false);
                        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
                        VersionHelper.sendCustomPayload(player, "axiom:enable", bytes);
                        this.failedPermissionAxiomPlayers.add(uuid);
                        stillFailedAxiomPlayers.add(uuid);
                        continue;
                    }
                    stillActiveAxiomPlayers.add(uuid);
                    this.tickPlayer(player, true);
                    continue;
                }
                if (!this.failedPermissionAxiomPlayers.contains(uuid)) continue;
                if (this.hasPermission(player, AxiomPermission.USE)) {
                    VersionHelper.sendCustomPayload(player, "axiom:redo_handshake", new byte[0]);
                    this.failedPermissionAxiomPlayers.remove(uuid);
                    continue;
                }
                stillFailedAxiomPlayers.add(uuid);
            }
            this.activeAxiomPlayers.retainAll(stillActiveAxiomPlayers);
            this.availableDispatchSends.keySet().retainAll(stillActiveAxiomPlayers);
            this.playerRestrictions.keySet().retainAll(stillActiveAxiomPlayers);
            this.playerBlockRegistry.keySet().retainAll(stillActiveAxiomPlayers);
            this.playerProtocolVersion.keySet().retainAll(stillActiveAxiomPlayers);
            this.lastPlotBoundsForPlayers.keySet().retainAll(stillActiveAxiomPlayers);
            this.noPhysicalTriggerPlayers.retainAll(stillActiveAxiomPlayers);
            this.failedPermissionAxiomPlayers.retainAll(stillFailedAxiomPlayers);
        } else {
            for (UUID uuid : this.activeAxiomPlayers) {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) continue;
                this.tickPlayer(player, false);
            }
        }
        this.operationQueue.tick();
        WorldExtension.tick(MinecraftServer.getServer(), this.sendMarkers, this.maxChunkRelightsPerTick, this.maxChunkSendsPerTick);
        ImplServerCustomBlocks.tick();
        ImplServerCustomDisplays.tick();
        ImplAxiomHiddenEntities.tick();
    }

    public void addPendingOperation(WorldServer level, PendingOperation operation) {
        this.operationQueue.add(level, operation);
    }

    private int getAllowedDispatchSendsPerSecond(Player player) {
        for (Map.Entry<String, Integer> entry : this.allowedDispatchSendOverrides.entrySet()) {
            if (!player.hasPermission("axiomlimits." + entry.getKey())) continue;
            return entry.getValue();
        }
        return this.defaultAllowedDispatchSendsPerSecond;
    }

    public boolean consumeDispatchSends(Player player, int sends, int clientAvailableDispatchSends) {
        int allowedDispatchSendsPerSecond = this.getAllowedDispatchSendsPerSecond(player);
        int currentSends = this.availableDispatchSends.getOrDefault((Object)player.getUniqueId(), allowedDispatchSendsPerSecond * 20);
        currentSends -= sends * 20;
        currentSends = Math.min(currentSends, clientAvailableDispatchSends * 20);
        this.availableDispatchSends.put((Object)player.getUniqueId(), currentSends);
        if (currentSends < -allowedDispatchSendsPerSecond * 20) {
            player.kick((Component)Component.text((String)"You are sending updates too fast!"));
            return false;
        }
        return true;
    }

    public void onAxiomActive(Player player) {
        this.activeAxiomPlayers.add(player.getUniqueId());
        this.failedPermissionAxiomPlayers.remove(player.getUniqueId());
        this.playerPermissions.remove(player.getUniqueId());
        this.playerRestrictions.remove(player.getUniqueId());
        this.tickPlayer(player, true);
    }

    private void tickPlayer(Player player, boolean updateRestrictions) {
        int allowedDispatchSendsPerSecond = this.getAllowedDispatchSendsPerSecond(player);
        if (!this.availableDispatchSends.containsKey((Object)player.getUniqueId())) {
            this.availableDispatchSends.put((Object)player.getUniqueId(), allowedDispatchSendsPerSecond * 20);
            this.sendUpdateAvailableDispatchSends(player, allowedDispatchSendsPerSecond, allowedDispatchSendsPerSecond);
        } else {
            int previousAllowed20 = this.availableDispatchSends.getInt((Object)player.getUniqueId());
            int newAllowed20 = Math.min(allowedDispatchSendsPerSecond * 20, previousAllowed20 + allowedDispatchSendsPerSecond);
            this.availableDispatchSends.put((Object)player.getUniqueId(), newAllowed20);
            int previousAllowed = previousAllowed20 / 20;
            int newAllowed = newAllowed20 / 20;
            if (previousAllowed != newAllowed) {
                this.sendUpdateAvailableDispatchSends(player, newAllowed - previousAllowed, allowedDispatchSendsPerSecond);
            }
        }
        if (updateRestrictions) {
            Restrictions oldRestrictions;
            Restrictions restrictions = this.calculateRestrictions(player);
            boolean restrictionsChanged = this.playerRestrictions.containsKey(player.getUniqueId()) ? !Objects.equals(restrictions, oldRestrictions = this.playerRestrictions.get(player.getUniqueId())) : true;
            if (restrictionsChanged) {
                restrictions.send(player);
                this.playerRestrictions.put(player.getUniqueId(), restrictions);
            }
        }
    }

    private void sendUpdateAvailableDispatchSends(Player player, int add, int max) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.d(add);
        buf.d(max);
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
        VersionHelper.sendCustomPayload(player, "axiom:update_available_dispatch_sends", bytes);
    }

    private Restrictions calculateRestrictions(Player player) {
        if (player.isOp() || player.hasPermission("axiom.all")) {
            Restrictions restrictions = new Restrictions();
            restrictions.allowedPermissions = EnumSet.of(AxiomPermission.ALL);
            restrictions.infiniteReachLimit = this.infiniteReachLimit;
            return restrictions;
        }
        AxiomPermissionSet permissionSet = this.getPermissions(player);
        if (permissionSet.contains(AxiomPermission.ALL)) {
            Restrictions restrictions = new Restrictions();
            restrictions.allowedPermissions = EnumSet.of(AxiomPermission.ALL);
            restrictions.infiniteReachLimit = this.infiniteReachLimit;
            return restrictions;
        }
        Set<Object> bounds = Set.of();
        if (!permissionSet.contains(AxiomPermission.ALLOW_COPYING_OTHER_PLOTS)) {
            if (PlotSquaredIntegration.isPlotWorld(player.getWorld())) {
                PlotSquaredIntegration.PlotBounds editable = PlotSquaredIntegration.getCurrentEditablePlot(player);
                if (editable != null) {
                    this.lastPlotBoundsForPlayers.put(player.getUniqueId(), editable);
                    bounds = editable.boxes();
                } else {
                    PlotSquaredIntegration.PlotBounds lastPlotBounds = this.lastPlotBoundsForPlayers.get(player.getUniqueId());
                    bounds = lastPlotBounds != null && lastPlotBounds.worldName().equals(player.getWorld().getName()) ? lastPlotBounds.boxes() : Set.of(new PlotSquaredIntegration.PlotBox(BlockPosition.b, BlockPosition.b));
                }
            }
            if (bounds.size() == 1) {
                PlotSquaredIntegration.PlotBox plotBounds = (PlotSquaredIntegration.PlotBox)bounds.iterator().next();
                int min = Integer.MIN_VALUE;
                int max = Integer.MAX_VALUE;
                if (plotBounds.min().u() == min && plotBounds.min().v() == min && plotBounds.min().w() == min && plotBounds.max().u() == max && plotBounds.max().v() == max && plotBounds.max().w() == max) {
                    bounds = Set.of();
                }
            }
        }
        EnumSet<AxiomPermission> allowed = EnumSet.noneOf(AxiomPermission.class);
        EnumSet<AxiomPermission> denied = EnumSet.noneOf(AxiomPermission.class);
        for (AxiomPermission permission : permissionSet.explicitlyAllowed) {
            if (permission.parent != null && permissionSet.explicitlyAllowed.contains((Object)permission.parent)) continue;
            allowed.add(permission);
        }
        for (AxiomPermission permission : permissionSet.explicitlyDenied) {
            if (permission.parent != null && permissionSet.explicitlyDenied.contains((Object)permission.parent)) continue;
            denied.add(permission);
        }
        Restrictions restrictions = new Restrictions();
        restrictions.allowedPermissions = allowed;
        restrictions.deniedPermissions = denied;
        restrictions.infiniteReachLimit = this.infiniteReachLimit;
        restrictions.bounds = bounds;
        return restrictions;
    }

    private void registerPacketHandler(String name, PacketHandler handler, Messenger messenger, LargePayloadBehaviour behaviour, Map<String, PacketHandler> largePayloadHandlers) {
        boolean isLargePayload;
        switch (behaviour) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DEFAULT: {
                boolean bl = this.configuration.getBoolean("allow-large-payload-for-all-packets");
                break;
            }
            case FORCE_LARGE: {
                boolean bl = true;
                break;
            }
            case FORCE_SMALL: {
                boolean bl = isLargePayload = false;
            }
        }
        if (isLargePayload) {
            largePayloadHandlers.put("axiom:" + name, handler);
            messenger.registerIncomingPluginChannel((Plugin)this, "axiom:" + name, (PluginMessageListener)new DummyPacketListener());
        } else {
            messenger.registerIncomingPluginChannel((Plugin)this, "axiom:" + name, (PluginMessageListener)new WrapperPacketListener(handler));
        }
    }

    public <T> IntFunction<T> limitCollection(IntFunction<T> applier) {
        return PacketDataSerializer.a(applier, (int)this.packetCollectionReadLimit);
    }

    public NBTReadLimiter createNbtAccounter() {
        return new NBTReadLimiter(this.maxNbtDecompressLimit);
    }

    public boolean logLargeBlockBufferChanges() {
        return this.logLargeBlockBufferChanges;
    }

    public boolean canUseAxiom(Player player) {
        return this.activeAxiomPlayers.contains(player.getUniqueId());
    }

    public boolean canUseAxiom(Player player, AxiomPermission axiomPermission) {
        return this.activeAxiomPlayers.contains(player.getUniqueId()) && this.hasPermission(player, axiomPermission);
    }

    public AxiomPermissionSet getPermissions(Player player) {
        return this.playerPermissions.computeIfAbsent(player.getUniqueId(), uuid -> this.calculatePermissions(player));
    }

    public boolean hasPermission(Player player, AxiomPermission axiomPermission) {
        if (player.isOp()) {
            return true;
        }
        return this.getPermissions(player).contains(axiomPermission);
    }

    private AxiomPermissionSet calculatePermissions(Player player) {
        if (player.isOp()) {
            return AxiomPermissionSet.NONE;
        }
        EnumSet<AxiomPermission> allowed = EnumSet.noneOf(AxiomPermission.class);
        EnumSet<AxiomPermission> denied = EnumSet.noneOf(AxiomPermission.class);
        block5: for (AxiomPermission permission : AxiomPermission.values()) {
            TriState value = player.permissionValue(permission.getPermissionNode());
            switch (value) {
                case FALSE: {
                    denied.add(permission);
                    continue block5;
                }
                case NOT_SET: {
                    continue block5;
                }
                case TRUE: {
                    allowed.add(permission);
                }
            }
        }
        return new AxiomPermissionSet(allowed, denied);
    }

    public boolean canEntityBeManipulated(EntityTypes<?> entityType) {
        if (entityType == EntityTypes.bt) {
            return false;
        }
        if (!this.whitelistedEntities.isEmpty() && !this.whitelistedEntities.contains(entityType)) {
            return false;
        }
        return !this.blacklistedEntities.contains(entityType);
    }

    public boolean isNoPhysicalTrigger(UUID uuid) {
        return this.noPhysicalTriggerPlayers.contains(uuid);
    }

    public void setNoPhysicalTrigger(UUID uuid, boolean noPhysicalTrigger) {
        if (noPhysicalTrigger) {
            if (!this.registeredNoPhysicalTriggerListener) {
                this.registeredNoPhysicalTriggerListener = true;
                Bukkit.getPluginManager().registerEvents((Listener)new NoPhysicalTriggerListener(this), (Plugin)this);
            }
            this.noPhysicalTriggerPlayers.add(uuid);
        } else {
            this.noPhysicalTriggerPlayers.remove(uuid);
        }
    }

    public boolean isMismatchedDataVersion(UUID uuid) {
        return this.playerProtocolVersion.containsKey(uuid);
    }

    public int getProtocolVersionFor(UUID uuid) {
        return this.playerProtocolVersion.getOrDefault(uuid, SharedConstants.c());
    }

    public RegistryBlockID<IBlockData> getBlockRegistry(UUID uuid) {
        return this.playerBlockRegistry.getOrDefault(uuid, this.allowedBlockRegistry);
    }

    @Nullable
    public ServerWorldPropertiesRegistry getWorldPropertiesIfPresent(World world) {
        return this.worldProperties.get(world);
    }

    @Nullable
    public ServerWorldPropertiesRegistry getOrCreateWorldProperties(World world) {
        if (this.worldProperties.containsKey(world)) {
            return this.worldProperties.get(world);
        }
        ServerWorldPropertiesRegistry properties = this.createWorldProperties(world);
        this.worldProperties.put(world, properties);
        return properties;
    }

    public boolean canModifyWorld(Player player, World world) {
        String whitelist = this.configuration.getString("whitelist-world-regex");
        if (whitelist != null && !whitelist.isBlank() && !world.getName().matches(whitelist)) {
            return false;
        }
        String blacklist = this.configuration.getString("blacklist-world-regex");
        if (blacklist != null && !blacklist.isBlank() && world.getName().matches(blacklist)) {
            return false;
        }
        AxiomModifyWorldEvent modifyWorldEvent = new AxiomModifyWorldEvent(player, world);
        Bukkit.getPluginManager().callEvent((Event)modifyWorldEvent);
        return !modifyWorldEvent.isCancelled();
    }

    @EventHandler
    public void onPluginUnload(PluginDisableEvent disableEvent) {
        ImplServerCustomBlocks.unregisterAll(disableEvent.getPlugin());
        ImplServerCustomDisplays.unregisterAll(disableEvent.getPlugin());
    }

    @EventHandler
    public void onFailMove(PlayerFailMoveEvent event) {
        if (!this.canUseAxiom(event.getPlayer(), AxiomPermission.PLAYER_BYPASS_MOVEMENT_RESTRICTIONS)) {
            return;
        }
        if (event.getFailReason() == PlayerFailMoveEvent.FailReason.MOVED_INTO_UNLOADED_CHUNK) {
            return;
        }
        if (!event.getPlayer().getWorld().isChunkLoaded(event.getTo().getBlockX() >> 4, event.getTo().getBlockZ() >> 4)) {
            return;
        }
        if (event.getFailReason() == PlayerFailMoveEvent.FailReason.MOVED_TOO_QUICKLY) {
            event.setAllowed(true);
        } else if (event.getPlayer().isFlying()) {
            event.setAllowed(true);
        }
    }

    @EventHandler
    public void onChangedWorld(PlayerChangedWorldEvent event) {
        this.clearCachedPermissionsFor(event.getPlayer().getUniqueId());
        if (!this.activeAxiomPlayers.contains(event.getPlayer().getUniqueId())) {
            return;
        }
        World world = event.getPlayer().getWorld();
        ServerWorldPropertiesRegistry properties = this.getOrCreateWorldProperties(world);
        if (properties == null) {
            VersionHelper.sendCustomPayload(event.getPlayer(), "axiom:register_world_properties", new byte[]{0});
        } else {
            properties.registerFor((Plugin)this, event.getPlayer());
        }
        WorldExtension.onPlayerJoin(world, event.getPlayer());
    }

    @EventHandler
    public void onGameRuleChanged(WorldGameRuleChangeEvent event) {
        if (event.getGameRule() == GameRule.DO_WEATHER_CYCLE) {
            ServerWorldPropertiesRegistry.PAUSE_WEATHER.setValue(event.getWorld(), !Boolean.parseBoolean(event.getValue()));
        }
    }

    private ServerWorldPropertiesRegistry createWorldProperties(World world) {
        ServerWorldPropertiesRegistry registry = new ServerWorldPropertiesRegistry(new WeakReference<World>(world));
        AxiomCreateWorldPropertiesEvent createEvent = new AxiomCreateWorldPropertiesEvent(world, registry);
        Bukkit.getPluginManager().callEvent((Event)createEvent);
        if (createEvent.isCancelled()) {
            return null;
        }
        return registry;
    }

    private static enum LargePayloadBehaviour {
        DEFAULT,
        FORCE_LARGE,
        FORCE_SMALL;

    }
}

