/*
 * Decompiled with CFR 0.152.
 */
package at.helpch.placeholderapi.expansion.vault;

import at.helpch.placeholderapi.expansion.vault.EconomyHook;
import at.helpch.placeholderapi.expansion.vault.PermissionHook;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import me.clip.placeholderapi.expansion.Cacheable;
import me.clip.placeholderapi.expansion.Configurable;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaultExpansion
extends PlaceholderExpansion
implements Cacheable,
Configurable {
    private EconomyHook economyHook;
    private PermissionHook permissionHook;

    @NotNull
    public String getIdentifier() {
        return "vault";
    }

    @NotNull
    public String getAuthor() {
        return "HelpChat";
    }

    @NotNull
    public String getVersion() {
        return "1.8.3";
    }

    @Nullable
    public String getRequiredPlugin() {
        return "Vault";
    }

    public void clear() {
        this.economyHook = null;
        this.permissionHook = null;
    }

    public Map<String, Object> getDefaults() {
        return ImmutableMap.builder().put((Object)"formatting.thousands", (Object)"k").put((Object)"formatting.millions", (Object)"M").put((Object)"formatting.billions", (Object)"B").put((Object)"formatting.trillions", (Object)"T").put((Object)"formatting.quadrillions", (Object)"Q").build();
    }

    public boolean canRegister() {
        this.economyHook = new EconomyHook(this);
        this.permissionHook = new PermissionHook(this);
        return this.economyHook.isReady() || this.permissionHook.isReady();
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (player == null) {
            return "";
        }
        if (this.economyHook.isReady() && params.startsWith("eco_")) {
            return this.economyHook.onRequest(player, params.replace("eco_", ""));
        }
        return this.permissionHook.isReady() ? this.permissionHook.onRequest(player, params) : null;
    }
}

