/*
 * Decompiled with CFR 0.152.
 */
package at.helpch.placeholderapi.expansion.vault;

import at.helpch.placeholderapi.expansion.vault.VaultExpansion;
import at.helpch.placeholderapi.expansion.vault.VaultHook;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionHook
extends VaultHook {
    private Permission permission;
    private Chat chat;

    public PermissionHook(VaultExpansion expansion) {
        super(expansion);
        this.setup();
    }

    @NotNull
    private String[] getPlayerGroups(@NotNull OfflinePlayer player) {
        String[] groups = this.permission.getPlayerGroups(null, player);
        return groups == null ? new String[]{} : groups;
    }

    @NotNull
    private Optional<String> getPrimaryGroup(@NotNull OfflinePlayer player) {
        return Optional.ofNullable(this.permission.getPrimaryGroup(null, player));
    }

    @NotNull
    private Optional<String> getGroupMeta(@NotNull String group, boolean isPrefix) {
        if (group.isEmpty()) {
            return Optional.empty();
        }
        String meta = isPrefix ? this.chat.getGroupPrefix((World)null, group) : this.chat.getGroupSuffix((World)null, group);
        return Optional.ofNullable(meta);
    }

    @NotNull
    private Optional<String> getPlayerMeta(@NotNull OfflinePlayer player, boolean isPrefix) {
        String meta = isPrefix ? this.chat.getPlayerPrefix(null, player) : this.chat.getPlayerSuffix(null, player);
        return Optional.ofNullable(meta);
    }

    @NotNull
    private String getGroupMeta(@NotNull OfflinePlayer player, int startIndex, boolean isPrefix) {
        String[] groups = this.getPlayerGroups(player);
        if (startIndex > groups.length) {
            return "";
        }
        for (int i = startIndex - 1; i < groups.length; ++i) {
            Optional<String> meta = this.getGroupMeta(groups[i], isPrefix);
            if (!meta.isPresent()) continue;
            return meta.get();
        }
        return "";
    }

    @NotNull
    private String capitalize(@NotNull String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1).toLowerCase();
    }

    @NotNull
    private String bool(boolean bool) {
        return bool ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }

    @Override
    public void setup() {
        this.permission = this.getService(Permission.class);
        this.chat = this.getService(Chat.class);
    }

    @Override
    public boolean isReady() {
        return this.permission != null && this.chat != null;
    }

    @Override
    @Nullable
    public String onRequest(@Nullable OfflinePlayer player, @NotNull String params) {
        if (player == null) {
            return "";
        }
        if (params.startsWith("rankprefix_") || params.startsWith("groupprefix_") || params.startsWith("ranksuffix_") || params.startsWith("groupsuffix_")) {
            String[] parts = params.split("_", 2);
            Integer index = Ints.tryParse((String)parts[1]);
            if (index == null || index < 0) {
                return "Invalid number " + parts[1];
            }
            return this.getGroupMeta(player, index, parts[0].contains("prefix"));
        }
        if (params.startsWith("hasgroup_")) {
            String group = params.substring("hasgroup_".length());
            return this.bool(this.permission.playerInGroup(null, player, group));
        }
        if (params.startsWith("inprimarygroup_")) {
            String group = params.substring("inprimarygroup_".length());
            return this.getPrimaryGroup(player).map(group::equals).map(this::bool).orElseGet(() -> this.bool(false));
        }
        switch (params) {
            case "group": 
            case "rank": {
                return this.getPrimaryGroup(player).orElse("");
            }
            case "group_capital": 
            case "rank_capital": {
                return this.getPrimaryGroup(player).map(this::capitalize).orElse("");
            }
            case "groups": 
            case "ranks": {
                return String.join((CharSequence)", ", this.getPlayerGroups(player));
            }
            case "groups_capital": 
            case "ranks_capital": {
                return Arrays.stream(this.getPlayerGroups(player)).map(this::capitalize).collect(Collectors.joining(", "));
            }
            case "prefix": {
                return this.getPlayerMeta(player, true).orElse("");
            }
            case "suffix": {
                return this.getPlayerMeta(player, false).orElse("");
            }
            case "groupprefix": 
            case "rankprefix": {
                return this.getPrimaryGroup(player).map(primaryGroup -> this.getGroupMeta((String)primaryGroup, true).orElse("")).orElse("");
            }
            case "groupsuffix": 
            case "ranksuffix": {
                return this.getPrimaryGroup(player).map(primaryGroup -> this.getGroupMeta((String)primaryGroup, false).orElse("")).orElse("");
            }
        }
        return null;
    }
}

