/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplusplus.warnings;

import java.util.ArrayList;
import java.util.List;
import net.shortninja.staffplusplus.common.ISqlFilter;
import net.shortninja.staffplusplus.common.SqlFilter;
import net.shortninja.staffplusplus.common.SqlFilters;
import net.shortninja.staffplusplus.session.SppPlayer;

public class WarningFilters
extends SqlFilters {
    private WarningFilters(List<ISqlFilter> warningFilters) {
        super(warningFilters);
    }

    public static class WarningFiltersBuilder {
        private List<ISqlFilter> warningFilters = new ArrayList<ISqlFilter>();

        public WarningFiltersBuilder id(int id) {
            this.warningFilters.add(new SqlFilter<Integer>(id, 4, "w.id"));
            return this;
        }

        public WarningFiltersBuilder severity(String severity) {
            this.warningFilters.add(new SqlFilter<String>(severity, 12, "w.severity"));
            return this;
        }

        public WarningFiltersBuilder anyOfSeverity(List<String> severities) {
            this.warningFilters.add(new SqlFilter<List<String>>(severities, 12, "w.severity"));
            return this;
        }

        public WarningFiltersBuilder culprit(SppPlayer culprit) {
            this.warningFilters.add(new SqlFilter<String>(culprit.getId().toString(), 12, "w.player_uuid"));
            return this;
        }

        public WarningFiltersBuilder culpritName(String culpritName) {
            this.warningFilters.add(new SqlFilter<String>(culpritName, 12, "w.player_name"));
            return this;
        }

        public WarningFiltersBuilder warnerName(String reporterName) {
            this.warningFilters.add(new SqlFilter<String>(reporterName, 12, "w.warner_name"));
            return this;
        }

        public WarningFiltersBuilder warner(SppPlayer assignee) {
            this.warningFilters.add(new SqlFilter<String>(assignee.getId().toString(), 12, "w.Warner_UUID"));
            return this;
        }

        public WarningFiltersBuilder reason(String reason) {
            this.warningFilters.add(new SqlFilter<String>(reason, 12, "w.Reason"));
            return this;
        }

        public WarningFiltersBuilder server(String server) {
            this.warningFilters.add(new SqlFilter<String>(server, 12, "w.server_name"));
            return this;
        }

        public WarningFiltersBuilder createdAfter(long timestamp) {
            this.warningFilters.add(new SqlFilter<Long>(timestamp, -5, "w.timestamp", ">="));
            return this;
        }

        public WarningFiltersBuilder expired(boolean expired) {
            this.warningFilters.add(new SqlFilter<Boolean>(expired, 16, "w.is_expired", "="));
            return this;
        }

        public WarningFilters build() {
            return new WarningFilters(this.warningFilters);
        }
    }
}

