/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplusplus.session;

import java.util.UUID;
import net.shortninja.staffplusplus.session.SppInteractor;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SppPlayer
extends SppInteractor {
    private final boolean online;
    private Player player;
    private OfflinePlayer offlinePlayer;

    public SppPlayer(UUID id, String username, OfflinePlayer offlinePlayer) {
        super(id, username);
        this.online = false;
        this.offlinePlayer = offlinePlayer;
    }

    public SppPlayer(UUID id, String username, Player player) {
        super(id, username, (CommandSender)player);
        this.online = true;
        this.player = player;
        this.offlinePlayer = player;
    }

    public boolean isOnline() {
        return this.online;
    }

    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public Player getPlayer() {
        if (!this.online) {
            throw new RuntimeException("Cannot retrieve bukkit player. Player is offline");
        }
        return this.player;
    }

    public void turnNightVisionOn() {
        this.player.removePotionEffect(PotionEffectType.NIGHT_VISION);
        this.player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 128, false, false));
    }

    public void turnNightVisionOff() {
        this.player.removePotionEffect(PotionEffectType.NIGHT_VISION);
    }

    public void setGameMode(GameMode gameMode) {
        this.player.setGameMode(gameMode);
    }
}

