/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplusplus.reports;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.shortninja.staffplusplus.common.ISqlFilter;
import net.shortninja.staffplusplus.common.SqlFilter;
import net.shortninja.staffplusplus.common.SqlFilters;
import net.shortninja.staffplusplus.reports.ReportStatus;
import net.shortninja.staffplusplus.session.SppPlayer;

public class ReportFilters
extends SqlFilters {
    public ReportFilters(List<ISqlFilter> sqlFilters) {
        super(sqlFilters);
    }

    public static class ReportFiltersBuilder {
        private List<ISqlFilter> sqlFilters = new ArrayList<ISqlFilter>();

        public ReportFiltersBuilder id(int id) {
            this.sqlFilters.add(new SqlFilter<Integer>(id, 4, "sp_reports.id"));
            return this;
        }

        public ReportFiltersBuilder reportStatus(ReportStatus reportStatus) {
            this.sqlFilters.add(new SqlFilter<String>(reportStatus.name(), 12, "sp_reports.status"));
            return this;
        }

        public ReportFiltersBuilder anyOfReportStatus(List<ReportStatus> reportStatuses) {
            this.sqlFilters.add(new SqlFilter(reportStatuses.stream().map(Enum::name).collect(Collectors.toList()), 12, "sp_reports.status"));
            return this;
        }

        public ReportFiltersBuilder culprit(SppPlayer culprit) {
            this.sqlFilters.add(new SqlFilter<String>(culprit.getId().toString(), 12, "sp_reports.player_uuid"));
            return this;
        }

        public ReportFiltersBuilder reporter(SppPlayer reporter) {
            this.sqlFilters.add(new SqlFilter<String>(reporter.getId().toString(), 12, "sp_reports.reporter_uuid"));
            return this;
        }

        public ReportFiltersBuilder reportName(String reporterName) {
            this.sqlFilters.add(new SqlFilter<String>(reporterName, 12, "sp_reports.reporter_name"));
            return this;
        }

        public ReportFiltersBuilder assignee(SppPlayer assignee) {
            this.sqlFilters.add(new SqlFilter<String>(assignee.getId().toString(), 12, "sp_reports.staff_uuid"));
            return this;
        }

        public ReportFiltersBuilder assigneeName(String assignee) {
            this.sqlFilters.add(new SqlFilter<String>(assignee, 12, "sp_reports.staff_name"));
            return this;
        }

        public ReportFiltersBuilder type(String type) {
            this.sqlFilters.add(new SqlFilter<String>(type, 12, "sp_reports.type"));
            return this;
        }

        public ReportFiltersBuilder server(String server) {
            this.sqlFilters.add(new SqlFilter<String>(server, 12, "sp_reports.server_name"));
            return this;
        }

        public ReportFiltersBuilder culpritName(String culpritName) {
            this.sqlFilters.add(new SqlFilter<String>(culpritName, 12, "sp_reports.player_name"));
            return this;
        }

        public ReportFiltersBuilder createdAfter(long timestamp) {
            this.sqlFilters.add(new SqlFilter<Long>(timestamp, -5, "sp_reports.timestamp", ">="));
            return this;
        }

        public ReportFilters build() {
            return new ReportFilters(this.sqlFilters);
        }
    }
}

