/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplusplus.playernotes;

import java.util.ArrayList;
import java.util.List;
import net.shortninja.staffplusplus.common.ISqlFilter;
import net.shortninja.staffplusplus.common.SqlFilter;
import net.shortninja.staffplusplus.common.SqlFilters;
import net.shortninja.staffplusplus.session.SppPlayer;

public class PlayerNoteFilters
extends SqlFilters {
    public PlayerNoteFilters(List<ISqlFilter> sqlFilters) {
        super(sqlFilters);
    }

    public static class PlayerNoteFiltersBuilder {
        private List<ISqlFilter> sqlFilters = new ArrayList<ISqlFilter>();

        public PlayerNoteFiltersBuilder id(int id) {
            this.sqlFilters.add(new SqlFilter<Integer>(id, 4, "sp_player_notes.id"));
            return this;
        }

        public PlayerNoteFiltersBuilder isPrivate() {
            this.sqlFilters.add(new SqlFilter<Boolean>(true, 16, "sp_player_notes.is_private_note"));
            return this;
        }

        public PlayerNoteFiltersBuilder isPublic() {
            this.sqlFilters.add(new SqlFilter<Boolean>(false, 16, "sp_player_notes.is_private_note"));
            return this;
        }

        public PlayerNoteFiltersBuilder target(SppPlayer target) {
            this.sqlFilters.add(new SqlFilter<String>(target.getId().toString(), 12, "sp_player_notes.target_uuid"));
            return this;
        }

        public PlayerNoteFiltersBuilder notedByName(String notedByName) {
            this.sqlFilters.add(new SqlFilter<String>(notedByName, 12, "sp_player_notes.noted_by_name"));
            return this;
        }

        public PlayerNoteFiltersBuilder note(String note) {
            this.sqlFilters.add(new SqlFilter<String>("%" + note + "%", 12, "sp_player_notes.note", " LIKE "));
            return this;
        }

        public PlayerNoteFiltersBuilder server(String server) {
            this.sqlFilters.add(new SqlFilter<String>(server, 12, "sp_player_notes.server_name"));
            return this;
        }

        public PlayerNoteFiltersBuilder createdAfter(long timestamp) {
            this.sqlFilters.add(new SqlFilter<Long>(timestamp, -5, "sp_player_notes.creation_timestamp", ">="));
            return this;
        }

        public PlayerNoteFilters build() {
            return new PlayerNoteFilters(this.sqlFilters);
        }
    }
}

