/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplusplus.mute;

import java.util.ArrayList;
import java.util.List;
import net.shortninja.staffplusplus.common.ISqlFilter;
import net.shortninja.staffplusplus.common.OrSqlFilter;
import net.shortninja.staffplusplus.common.SqlFilter;
import net.shortninja.staffplusplus.common.SqlFilters;
import net.shortninja.staffplusplus.session.SppPlayer;

public class MuteFilters
extends SqlFilters {
    public MuteFilters(List<ISqlFilter> sqlFilters) {
        super(sqlFilters);
    }

    public static class MuteFiltersBuilder {
        private final List<ISqlFilter> sqlFilters = new ArrayList<ISqlFilter>();

        public MuteFiltersBuilder id(int id) {
            this.sqlFilters.add(new SqlFilter<Integer>(id, 4, "sp_muted_players.ID"));
            return this;
        }

        public MuteFiltersBuilder active() {
            this.sqlFilters.add(new OrSqlFilter<Object, Long>(new SqlFilter<Object>(null, -5, "sp_muted_players.end_timestamp"), new SqlFilter<Long>(System.currentTimeMillis(), -5, "sp_muted_players.end_timestamp", ">")));
            return this;
        }

        public MuteFiltersBuilder notActive() {
            this.sqlFilters.add(new SqlFilter<Long>(System.currentTimeMillis(), -5, "sp_muted_players.end_timestamp", "<="));
            return this;
        }

        public MuteFiltersBuilder target(SppPlayer target) {
            this.sqlFilters.add(new SqlFilter<String>(target.getId().toString(), 12, "sp_muted_players.player_uuid"));
            return this;
        }

        public MuteFiltersBuilder targetName(String targetName) {
            this.sqlFilters.add(new SqlFilter<String>(targetName, 12, "sp_muted_players.player_name"));
            return this;
        }

        public MuteFiltersBuilder issuer(SppPlayer issuer) {
            this.sqlFilters.add(new SqlFilter<String>(issuer.getId().toString(), 12, "sp_muted_players.issuer_uuid"));
            return this;
        }

        public MuteFiltersBuilder issuerName(String issuerName) {
            this.sqlFilters.add(new SqlFilter<String>(issuerName, 12, "sp_muted_players.issuer_name"));
            return this;
        }

        public MuteFiltersBuilder server(String server) {
            this.sqlFilters.add(new SqlFilter<String>(server, 12, "sp_muted_players.server_name"));
            return this;
        }

        public MuteFiltersBuilder reason(String reason) {
            this.sqlFilters.add(new SqlFilter<String>(reason, 12, "sp_muted_players.reason"));
            return this;
        }

        public MuteFiltersBuilder createdAfter(long timestamp) {
            this.sqlFilters.add(new SqlFilter<Long>(timestamp, -5, "sp_muted_players.creation_timestamp", ">="));
            return this;
        }

        public MuteFilters build() {
            return new MuteFilters(this.sqlFilters);
        }
    }
}

