/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplusplus.ban;

import java.util.ArrayList;
import java.util.List;
import net.shortninja.staffplusplus.common.ISqlFilter;
import net.shortninja.staffplusplus.common.OrSqlFilter;
import net.shortninja.staffplusplus.common.SqlFilter;
import net.shortninja.staffplusplus.common.SqlFilters;
import net.shortninja.staffplusplus.session.SppPlayer;

public class BanFilters
extends SqlFilters {
    public BanFilters(List<ISqlFilter> sqlFilters) {
        super(sqlFilters);
    }

    public static class BanFiltersBuilder {
        private final List<ISqlFilter> sqlFilters = new ArrayList<ISqlFilter>();

        public BanFiltersBuilder id(int id) {
            this.sqlFilters.add(new SqlFilter<Integer>(id, 4, "sp_banned_players.ID"));
            return this;
        }

        public BanFiltersBuilder active() {
            this.sqlFilters.add(new OrSqlFilter<Object, Long>(new SqlFilter<Object>(null, -5, "sp_banned_players.end_timestamp"), new SqlFilter<Long>(System.currentTimeMillis(), -5, "sp_banned_players.end_timestamp", ">")));
            return this;
        }

        public BanFiltersBuilder notActive() {
            this.sqlFilters.add(new SqlFilter<Long>(System.currentTimeMillis(), -5, "sp_banned_players.end_timestamp", "<="));
            return this;
        }

        public BanFiltersBuilder target(SppPlayer target) {
            this.sqlFilters.add(new SqlFilter<String>(target.getId().toString(), 12, "sp_banned_players.player_uuid"));
            return this;
        }

        public BanFiltersBuilder targetName(String targetName) {
            this.sqlFilters.add(new SqlFilter<String>(targetName, 12, "sp_banned_players.player_name"));
            return this;
        }

        public BanFiltersBuilder issuer(SppPlayer issuer) {
            this.sqlFilters.add(new SqlFilter<String>(issuer.getId().toString(), 12, "sp_banned_players.issuer_uuid"));
            return this;
        }

        public BanFiltersBuilder issuerName(String issuerName) {
            this.sqlFilters.add(new SqlFilter<String>(issuerName, 12, "sp_banned_players.issuer_name"));
            return this;
        }

        public BanFiltersBuilder server(String server) {
            this.sqlFilters.add(new SqlFilter<String>(server, 12, "sp_banned_players.server_name"));
            return this;
        }

        public BanFiltersBuilder reason(String reason) {
            this.sqlFilters.add(new SqlFilter<String>(reason, 12, "sp_banned_players.reason"));
            return this;
        }

        public BanFiltersBuilder createdAfter(long timestamp) {
            this.sqlFilters.add(new SqlFilter<Long>(timestamp, -5, "sp_banned_players.creation_timestamp", ">="));
            return this;
        }

        public BanFilters build() {
            return new BanFilters(this.sqlFilters);
        }
    }
}

