/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.server.compatibility.v1_1x;

import be.garagepoort.staffplusplus.craftbukkit.common.IProtocol;
import be.garagepoort.staffplusplus.craftbukkit.common.json.JsonMessage;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_16_R3.ChatMessageType;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutChat;
import net.minecraft.server.v1_16_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.shortninja.staffplus.server.compatibility.v1_1x.PacketHandler_v1_16_R3;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.command.CraftCommandMap;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Protocol_v1_16_R3
implements IProtocol {
    @Override
    public ItemStack addNbtString(ItemStack item, String value) {
        net.minecraft.server.v1_16_R3.ItemStack craftItem = CraftItemStack.asNMSCopy((ItemStack)item);
        NBTTagCompound nbtCompound = craftItem.getTag() == null ? new NBTTagCompound() : craftItem.getTag();
        nbtCompound.setString("StaffPlus", value);
        craftItem.setTag(nbtCompound);
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_16_R3.ItemStack)craftItem);
    }

    @Override
    public String getNbtString(ItemStack item) {
        net.minecraft.server.v1_16_R3.ItemStack craftItem = CraftItemStack.asNMSCopy((ItemStack)item);
        if (craftItem == null) {
            return "";
        }
        NBTTagCompound nbtCompound = craftItem.getTag() == null ? new NBTTagCompound() : craftItem.getTag();
        return nbtCompound.getString("StaffPlus");
    }

    @Override
    public void unregisterCommand(String match, Command command) {
        CraftCommandMap commandMap = (CraftCommandMap)((CraftServer)Bukkit.getServer()).getCommandMap();
        command.unregister((CommandMap)commandMap);
        String commandName = command.getLabel().toLowerCase();
        if (commandMap.getKnownCommands().get(commandName) == command) {
            commandMap.getKnownCommands().remove(commandName);
        }
        String commandNameWithPrefix = match.toLowerCase() + ":" + commandName;
        if (commandMap.getKnownCommands().get(commandNameWithPrefix) == command) {
            commandMap.getKnownCommands().remove(commandNameWithPrefix);
        }
        for (String alias : command.getAliases()) {
            String aliasName = alias.toLowerCase();
            String aliasNameWithPrefix = match.toLowerCase() + ":" + aliasName;
            if (commandMap.getKnownCommands().get(aliasName) == command) {
                commandMap.getKnownCommands().remove(aliasName);
            }
            if (commandMap.getKnownCommands().get(aliasNameWithPrefix) != command) continue;
            commandMap.getKnownCommands().remove(aliasNameWithPrefix);
        }
    }

    @Override
    public void registerCommand(String match, Command command) {
        ((CraftServer)Bukkit.getServer()).getCommandMap().register(match, command);
    }

    @Override
    public void listVanish(Player player, boolean shouldEnable) {
        PacketPlayOutPlayerInfo packet = null;
        packet = shouldEnable ? new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{((CraftPlayer)player).getHandle()}) : new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{((CraftPlayer)player).getHandle()});
        this.sendToAllButMe((Packet<?>)packet, player);
    }

    @Override
    public void sendHoverableJsonMessage(Set<Player> players, String message, String hoverMessage) {
        JsonMessage json = new JsonMessage().append(message).setHoverAsTooltip(hoverMessage).save();
        PacketPlayOutChat packet = new PacketPlayOutChat((IChatBaseComponent)IChatBaseComponent.ChatSerializer.a((String)json.getMessage()), ChatMessageType.CHAT, UUID.randomUUID());
        for (Player player : players) {
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
        }
    }

    private void sendToAllButMe(Packet<?> packet, Player me) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (me.getUniqueId().equals(player.getUniqueId())) continue;
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket(packet);
        }
    }

    @Override
    public String getSound(Object object) {
        try {
            return object instanceof SoundEffect ? this.getSoundName((SoundEffect)object) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getSoundName(SoundEffect sound) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String soundName = "";
        MinecraftKey minecraftKey = this.getMinecraftKey(sound);
        if (minecraftKey != null) {
            soundName = minecraftKey.getNamespace();
        }
        return soundName;
    }

    private MinecraftKey getMinecraftKey(SoundEffect sound) {
        MinecraftKey minecraftKey = null;
        Field field = null;
        try {
            field = SoundEffect.class.getDeclaredField("a");
            field.setAccessible(true);
            minecraftKey = (MinecraftKey)field.get(sound);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
        }
        return minecraftKey;
    }

    @Override
    public void inject(Player player) {
        ChannelPipeline pipeline = ((CraftPlayer)player).getHandle().playerConnection.networkManager.channel.pipeline();
        pipeline.addBefore("packet_handler", "staffplusplus_" + player.getUniqueId().toString(), (ChannelHandler)new PacketHandler_v1_16_R3(player));
    }

    @Override
    public void uninject(Player player) {
        Channel channel = ((CraftPlayer)player).getHandle().playerConnection.networkManager.channel;
        channel.eventLoop().submit(() -> channel.pipeline().remove(player.getUniqueId().toString()));
    }
}

