/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.server.compatibility.v1_12_R1;

import be.garagepoort.staffplusplus.craftbukkit.common.IProtocol;
import be.garagepoort.staffplusplus.craftbukkit.common.json.JsonMessage;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.MinecraftKey;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketPlayOutChat;
import net.minecraft.server.v1_12_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_12_R1.SoundEffect;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Protocol_v1_12_R1
implements IProtocol {
    @Override
    public ItemStack addNbtString(ItemStack item, String value) {
        net.minecraft.server.v1_12_R1.ItemStack craftItem = CraftItemStack.asNMSCopy((ItemStack)item);
        NBTTagCompound nbtCompound = craftItem.getTag() == null ? new NBTTagCompound() : craftItem.getTag();
        nbtCompound.setString("StaffPlus", value);
        craftItem.setTag(nbtCompound);
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_12_R1.ItemStack)craftItem);
    }

    @Override
    public String getNbtString(ItemStack item) {
        net.minecraft.server.v1_12_R1.ItemStack craftItem = CraftItemStack.asNMSCopy((ItemStack)item);
        if (craftItem == null) {
            return "";
        }
        NBTTagCompound nbtCompound = craftItem.getTag() == null ? new NBTTagCompound() : craftItem.getTag();
        return nbtCompound.getString("StaffPlus");
    }

    @Override
    public void unregisterCommand(String match, Command command) {
        SimpleCommandMap commandMap = ((CraftServer)Bukkit.getServer()).getCommandMap();
        command.unregister((CommandMap)commandMap);
        try {
            String commandNameWithPrefix;
            Field knownCommands = commandMap.getClass().getDeclaredField("knownCommands");
            knownCommands.setAccessible(true);
            Map cmds = (Map)knownCommands.get(commandMap);
            String commandName = command.getLabel().toLowerCase();
            if (cmds.get(commandName) == command) {
                cmds.remove(commandName);
            }
            if (cmds.get(commandNameWithPrefix = match.toLowerCase() + ":" + commandName) == command) {
                cmds.remove(commandNameWithPrefix);
            }
            for (String alias : command.getAliases()) {
                String aliasName = alias.toLowerCase();
                String aliasNameWithPrefix = match.toLowerCase() + ":" + aliasName;
                if (cmds.get(aliasName) == command) {
                    cmds.remove(aliasName);
                }
                if (cmds.get(aliasNameWithPrefix) != command) continue;
                cmds.remove(aliasNameWithPrefix);
            }
            knownCommands.set(commandMap, cmds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void registerCommand(String match, Command command) {
        ((CraftServer)Bukkit.getServer()).getCommandMap().register(match, command);
    }

    @Override
    public void listVanish(Player player, boolean shouldEnable) {
        PacketPlayOutPlayerInfo packet = null;
        packet = shouldEnable ? new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{((CraftPlayer)player).getHandle()}) : new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{((CraftPlayer)player).getHandle()});
        this.sendToAllButMe((Packet<?>)packet, player);
    }

    @Override
    public void sendHoverableJsonMessage(Set<Player> players, String message, String hoverMessage) {
        JsonMessage json = new JsonMessage().append(message).setHoverAsTooltip(hoverMessage).save();
        PacketPlayOutChat packet = new PacketPlayOutChat(IChatBaseComponent.ChatSerializer.a((String)json.getMessage()));
        for (Player player : players) {
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
        }
    }

    private void sendToAllButMe(Packet<?> packet, Player me) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (me.getUniqueId().equals(player.getUniqueId())) continue;
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket(packet);
        }
    }

    @Override
    public String getSound(Object object) {
        try {
            return object instanceof SoundEffect ? this.getSoundName((SoundEffect)object) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void inject(Player player) {
        ChannelPipeline pipeline = this.getChannel(player).pipeline();
    }

    @Override
    public void uninject(Player player) {
        Channel channel = this.getChannel(player);
        channel.eventLoop().submit(() -> channel.pipeline().remove(player.getUniqueId().toString()));
    }

    private Channel getChannel(Player player) {
        return ((CraftPlayer)player).getHandle().playerConnection.networkManager.channel;
    }

    private String getSoundName(SoundEffect sound) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String soundName = "";
        MinecraftKey minecraftKey = this.getMinecraftKey(sound);
        if (minecraftKey != null) {
            soundName = minecraftKey.b();
        }
        return soundName;
    }

    private MinecraftKey getMinecraftKey(SoundEffect sound) {
        MinecraftKey minecraftKey = null;
        Field field = null;
        try {
            field = SoundEffect.class.getDeclaredField("b");
            field.setAccessible(true);
            minecraftKey = (MinecraftKey)field.get(sound);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
        }
        return minecraftKey;
    }
}

