/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.libs.retrofit2.converter.gson;

import java.io.IOException;
import net.shortninja.staffplus.libs.com.google.gson.Gson;
import net.shortninja.staffplus.libs.com.google.gson.JsonIOException;
import net.shortninja.staffplus.libs.com.google.gson.TypeAdapter;
import net.shortninja.staffplus.libs.com.google.gson.stream.JsonReader;
import net.shortninja.staffplus.libs.com.google.gson.stream.JsonToken;
import net.shortninja.staffplus.libs.okhttp3.ResponseBody;
import net.shortninja.staffplus.libs.retrofit2.Converter;

final class GsonResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private final Gson gson;
    private final TypeAdapter<T> adapter;

    GsonResponseBodyConverter(Gson gson, TypeAdapter<T> adapter) {
        this.gson = gson;
        this.adapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T convert(ResponseBody value) throws IOException {
        JsonReader jsonReader = this.gson.newJsonReader(value.charStream());
        try {
            T result = this.adapter.read(jsonReader);
            if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
            T t = result;
            return t;
        }
        finally {
            value.close();
        }
    }
}

