/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.libs.retrofit2.converter.gson;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import net.shortninja.staffplus.libs.com.google.gson.Gson;
import net.shortninja.staffplus.libs.com.google.gson.TypeAdapter;
import net.shortninja.staffplus.libs.com.google.gson.reflect.TypeToken;
import net.shortninja.staffplus.libs.okhttp3.RequestBody;
import net.shortninja.staffplus.libs.okhttp3.ResponseBody;
import net.shortninja.staffplus.libs.retrofit2.Converter;
import net.shortninja.staffplus.libs.retrofit2.Retrofit;
import net.shortninja.staffplus.libs.retrofit2.converter.gson.GsonRequestBodyConverter;
import net.shortninja.staffplus.libs.retrofit2.converter.gson.GsonResponseBodyConverter;

public final class GsonConverterFactory
extends Converter.Factory {
    private final Gson gson;

    public static GsonConverterFactory create() {
        return GsonConverterFactory.create(new Gson());
    }

    public static GsonConverterFactory create(Gson gson) {
        if (gson == null) {
            throw new NullPointerException("gson == null");
        }
        return new GsonConverterFactory(gson);
    }

    private GsonConverterFactory(Gson gson) {
        this.gson = gson;
    }

    @Override
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        TypeAdapter<?> adapter = this.gson.getAdapter(TypeToken.get(type));
        return new GsonResponseBodyConverter(this.gson, adapter);
    }

    @Override
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        TypeAdapter<?> adapter = this.gson.getAdapter(TypeToken.get(type));
        return new GsonRequestBodyConverter(this.gson, adapter);
    }
}

