/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.libs.inet.ipaddr.format;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;
import net.shortninja.staffplus.libs.inet.ipaddr.AddressComponent;
import net.shortninja.staffplus.libs.inet.ipaddr.format.AddressItem;
import net.shortninja.staffplus.libs.inet.ipaddr.format.AddressItemRange;
import net.shortninja.staffplus.libs.inet.ipaddr.format.util.AddressComponentRangeSpliterator;

public interface AddressComponentRange
extends AddressItem,
AddressItemRange {
    public AddressComponent getLower();

    public AddressComponent getUpper();

    public Iterable<? extends AddressComponent> getIterable();

    public Iterator<? extends AddressComponent> iterator();

    public AddressComponentRangeSpliterator<? extends AddressComponentRange, ? extends AddressComponent> spliterator();

    public Stream<? extends AddressComponent> stream();

    @SafeVarargs
    public static <T extends AddressComponent> Stream<T> stream(Function<T, Stream<? extends T>> addrStreamFunc, T ... components) {
        return Arrays.stream(components).map(addrStreamFunc).flatMap(s -> s);
    }

    public static <T extends AddressComponent> Stream<T> stream(Function<T, Stream<? extends T>> addrStreamFunc, Collection<? extends T> components) {
        return components.stream().map(addrStreamFunc).flatMap(s -> s);
    }
}

