/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.libs.inet.ipaddr;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.function.Function;
import net.shortninja.staffplus.libs.inet.ipaddr.AddressStringException;
import net.shortninja.staffplus.libs.inet.ipaddr.HostIdentifierString;
import net.shortninja.staffplus.libs.inet.ipaddr.HostNameException;
import net.shortninja.staffplus.libs.inet.ipaddr.HostNameParameters;
import net.shortninja.staffplus.libs.inet.ipaddr.IPAddress;
import net.shortninja.staffplus.libs.inet.ipaddr.IPAddressNetwork;
import net.shortninja.staffplus.libs.inet.ipaddr.IPAddressSegment;
import net.shortninja.staffplus.libs.inet.ipaddr.IPAddressString;
import net.shortninja.staffplus.libs.inet.ipaddr.IPAddressStringParameters;
import net.shortninja.staffplus.libs.inet.ipaddr.format.validate.HostIdentifierStringValidator;
import net.shortninja.staffplus.libs.inet.ipaddr.format.validate.ParsedHost;
import net.shortninja.staffplus.libs.inet.ipaddr.format.validate.ParsedHostIdentifierStringQualifier;
import net.shortninja.staffplus.libs.inet.ipaddr.format.validate.Validator;
import net.shortninja.staffplus.libs.inet.ipaddr.ipv6.IPv6Address;

public class HostName
implements HostIdentifierString,
Comparable<HostName> {
    private static final long serialVersionUID = 4L;
    public static final char LABEL_SEPARATOR = '.';
    public static final char IPV6_START_BRACKET = '[';
    public static final char IPV6_END_BRACKET = ']';
    public static final char PORT_SEPARATOR = ':';
    public static final HostNameParameters DEFAULT_VALIDATION_OPTIONS = new HostNameParameters.Builder().toParams();
    private final String host;
    private transient String normalizedString;
    private transient String normalizedWildcardString;
    private ParsedHost parsedHost;
    private HostNameException validationException;
    IPAddress resolvedAddress;
    private boolean resolvedIsNull;
    final HostNameParameters validationOptions;

    public HostName(IPAddress addr) {
        this.host = addr.toNormalizedString();
        this.parsedHost = new ParsedHost(this.host, addr.getProvider());
        this.validationOptions = null;
    }

    public HostName(IPAddress addr, int port) {
        ParsedHostIdentifierStringQualifier qualifier = new ParsedHostIdentifierStringQualifier(null, port);
        this.host = HostName.toNormalizedString(addr, port);
        this.parsedHost = new ParsedHost(this.host, addr.getProvider(), qualifier);
        this.validationOptions = null;
    }

    public HostName(InetSocketAddress inetSocketAddr) {
        if (!inetSocketAddr.isUnresolved()) {
            this.resolvedAddress = HostName.toIPAddress(inetSocketAddr.getAddress(), IPAddressString.DEFAULT_VALIDATION_OPTIONS);
        }
        this.host = inetSocketAddr.getHostString().trim() + ':' + inetSocketAddr.getPort();
        this.validationOptions = DEFAULT_VALIDATION_OPTIONS;
    }

    public HostName(InetAddress inetAddr, Integer prefixLength) {
        this(HostName.toIPAddress(inetAddr, IPAddressString.DEFAULT_VALIDATION_OPTIONS, prefixLength));
    }

    public HostName(InterfaceAddress interfaceAddr) {
        this(interfaceAddr.getAddress(), IPAddressNetwork.cacheBits(interfaceAddr.getNetworkPrefixLength()));
    }

    public HostName(InetAddress inetAddr) {
        this(inetAddr, IPAddressString.DEFAULT_VALIDATION_OPTIONS);
    }

    public HostName(InetAddress inetAddr, IPAddressStringParameters addressOptions) {
        this(HostName.toIPAddress(inetAddr, addressOptions));
    }

    private static IPAddress toIPAddress(InetAddress inetAddr, IPAddressStringParameters addressOptions) {
        return inetAddr instanceof Inet4Address ? addressOptions.getIPv4Parameters().getNetwork().getAddressCreator().createAddress((Inet4Address)inetAddr) : addressOptions.getIPv6Parameters().getNetwork().getAddressCreator().createAddress((Inet6Address)inetAddr);
    }

    private static IPAddress toIPAddress(InetAddress inetAddr, IPAddressStringParameters addressOptions, Integer prefixLength) {
        return inetAddr instanceof Inet4Address ? addressOptions.getIPv4Parameters().getNetwork().getAddressCreator().createAddress((Inet4Address)inetAddr, prefixLength) : addressOptions.getIPv6Parameters().getNetwork().getAddressCreator().createAddress((Inet6Address)inetAddr, prefixLength);
    }

    HostName(String hostStr, ParsedHost parsed) {
        this.host = hostStr;
        this.parsedHost = parsed;
        this.validationOptions = null;
    }

    public HostName(String host) {
        this(host, DEFAULT_VALIDATION_OPTIONS);
    }

    public HostName(String host, HostNameParameters options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.validationOptions = options;
        this.host = host == null ? "" : host.trim();
    }

    void cacheAddress(IPAddress addr) {
        if (this.parsedHost == null) {
            this.parsedHost = new ParsedHost(this.host, addr.getProvider());
        }
    }

    public HostNameParameters getValidationOptions() {
        return this.validationOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate() throws HostNameException {
        if (this.parsedHost != null) {
            return;
        }
        if (this.validationException != null) {
            throw this.validationException;
        }
        HostName hostName = this;
        synchronized (hostName) {
            if (this.parsedHost != null) {
                return;
            }
            if (this.validationException != null) {
                throw this.validationException;
            }
            try {
                this.parsedHost = this.getValidator().validateHost(this);
            }
            catch (HostNameException e) {
                this.validationException = e;
                throw e;
            }
        }
    }

    protected HostIdentifierStringValidator getValidator() {
        return Validator.VALIDATOR;
    }

    public boolean isValid() {
        if (this.parsedHost != null) {
            return true;
        }
        if (this.validationException != null) {
            return false;
        }
        try {
            this.validate();
            return true;
        }
        catch (HostNameException e) {
            return false;
        }
    }

    public boolean resolvesToSelf() {
        return this.isSelf() || this.getAddress() != null && this.resolvedAddress.isLoopback();
    }

    public boolean isSelf() {
        return this.isLocalHost() || this.isLoopback();
    }

    public boolean isLocalHost() {
        return this.isValid() && this.host.equalsIgnoreCase("localhost");
    }

    public boolean isLoopback() {
        return this.isAddress() && this.asAddress().isLoopback();
    }

    public InetAddress toInetAddress() throws HostNameException, UnknownHostException {
        this.validate();
        return this.toAddress().toInetAddress();
    }

    @Override
    public String toNormalizedString() {
        String result = this.normalizedString;
        if (result == null) {
            this.normalizedString = result = this.toNormalizedString(false);
        }
        return result;
    }

    private String toNormalizedWildcardString() {
        String result = this.normalizedWildcardString;
        if (result == null) {
            this.normalizedWildcardString = result = this.toNormalizedString(true);
        }
        return result;
    }

    private static CharSequence translateReserved(IPv6Address addr, String str) {
        if (!addr.hasZone()) {
            return str;
        }
        int index = str.indexOf(37);
        StringBuilder translated = new StringBuilder((str.length() - index) * 3 + index);
        translated.append(str, 0, index);
        translated.append("%25");
        for (int i = index + 1; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Validator.isReserved(c)) {
                translated.append('%');
                IPAddressSegment.toUnsignedString(c, 16, translated);
                continue;
            }
            translated.append(c);
        }
        return translated;
    }

    private static String toNormalizedString(IPAddress addr, int port) {
        StringBuilder builder = new StringBuilder();
        HostName.toNormalizedString(addr, false, builder);
        HostName.toNormalizedString(port, builder);
        return builder.toString();
    }

    private String toNormalizedString(boolean wildcard) {
        if (this.isValid()) {
            StringBuilder builder = new StringBuilder();
            if (this.isAddress()) {
                HostName.toNormalizedString(this.asAddress(), wildcard, builder);
            } else if (this.isAddressString()) {
                builder.append(this.asAddressString().toNormalizedString());
            } else {
                builder.append(this.parsedHost.getHost());
                Integer networkPrefixLength = this.parsedHost.getEquivalentPrefixLength();
                if (networkPrefixLength != null) {
                    builder.append('/').append(networkPrefixLength);
                } else {
                    IPAddress mask = this.parsedHost.getMask();
                    if (mask != null) {
                        builder.append('/').append(mask.toNormalizedString());
                    }
                }
            }
            Integer port = this.parsedHost.getPort();
            if (port != null) {
                HostName.toNormalizedString(port, builder);
            } else {
                String service = this.parsedHost.getService();
                if (service != null) {
                    builder.append(':').append(service);
                }
            }
            return builder.toString();
        }
        return this.host;
    }

    private static void toNormalizedString(int port, StringBuilder builder) {
        builder.append(':').append(port);
    }

    private static void toNormalizedString(IPAddress addr, boolean wildcard, StringBuilder builder) {
        if (addr.isIPv6()) {
            if (!wildcard && addr.isPrefixed()) {
                String normalized = addr.toNormalizedString();
                int index = normalized.indexOf(47);
                CharSequence translated = HostName.translateReserved(addr.toIPv6(), normalized.substring(0, index));
                builder.append('[').append(translated).append(']').append(normalized.substring(index));
            } else {
                String normalized = addr.toNormalizedWildcardString();
                CharSequence translated = HostName.translateReserved(addr.toIPv6(), normalized);
                builder.append('[').append(translated).append(']');
            }
        } else {
            builder.append(wildcard ? addr.toNormalizedWildcardString() : addr.toNormalizedString());
        }
    }

    public boolean equals(Object o) {
        return o instanceof HostName && this.matches((HostName)o);
    }

    public int hashCode() {
        return this.toNormalizedWildcardString().hashCode();
    }

    public String[] getNormalizedLabels() {
        if (this.isValid()) {
            return this.parsedHost.getNormalizedLabels();
        }
        if (this.host.length() == 0) {
            return new String[0];
        }
        return new String[]{this.host};
    }

    public String getHost() {
        if (this.isValid()) {
            return this.parsedHost.getHost();
        }
        return null;
    }

    public boolean matches(HostName host) {
        if (this == host) {
            return true;
        }
        if (this.isValid()) {
            if (host.isValid()) {
                String otherHost;
                if (this.isAddressString()) {
                    return host.isAddressString() && this.asAddressString().equals(host.asAddressString()) && Objects.equals(this.getPort(), host.getPort()) && Objects.equals(this.getService(), host.getService());
                }
                if (host.isAddressString()) {
                    return false;
                }
                String thisHost = this.parsedHost.getHost();
                if (!thisHost.equals(otherHost = host.parsedHost.getHost())) {
                    return false;
                }
                return Objects.equals(this.parsedHost.getEquivalentPrefixLength(), host.parsedHost.getEquivalentPrefixLength()) && Objects.equals(this.parsedHost.getMask(), host.parsedHost.getMask()) && Objects.equals(this.parsedHost.getPort(), host.parsedHost.getPort()) && Objects.equals(this.parsedHost.getService(), host.parsedHost.getService());
            }
            return false;
        }
        return !host.isValid() && this.toString().equals(host.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(HostName other) {
        if (this.isValid()) {
            if (!other.isValid()) return 1;
            if (this.isAddressString()) {
                if (!other.isAddressString()) return -1;
                int result = this.asAddressString().compareTo(other.asAddressString());
                if (result != 0) {
                    return result;
                }
            } else {
                if (other.isAddressString()) {
                    return 1;
                }
                String[] normalizedLabels = this.parsedHost.getNormalizedLabels();
                String[] otherNormalizedLabels = other.parsedHost.getNormalizedLabels();
                int oneLen = normalizedLabels.length;
                int twoLen = otherNormalizedLabels.length;
                int minLen = Math.min(oneLen, twoLen);
                for (int i = 1; i <= minLen; ++i) {
                    String one = normalizedLabels[oneLen - i];
                    String two = otherNormalizedLabels[twoLen - i];
                    int result = one.compareTo(two);
                    if (result == 0) continue;
                    return result;
                }
                if (oneLen != twoLen) {
                    return oneLen - twoLen;
                }
                Integer networkPrefixLength = this.parsedHost.getEquivalentPrefixLength();
                Integer otherPrefixLength = other.parsedHost.getEquivalentPrefixLength();
                if (networkPrefixLength != null) {
                    if (otherPrefixLength == null) return 1;
                    if (networkPrefixLength.intValue() != otherPrefixLength.intValue()) {
                        return otherPrefixLength - networkPrefixLength;
                    }
                } else {
                    if (otherPrefixLength != null) {
                        return -1;
                    }
                    IPAddress mask = this.parsedHost.getMask();
                    IPAddress otherMask = other.parsedHost.getMask();
                    if (mask != null) {
                        if (otherMask == null) return 1;
                        int ret = mask.compareTo(otherMask);
                        if (ret != 0) {
                            return ret;
                        }
                    } else if (otherMask != null) {
                        return -1;
                    }
                }
            }
            Integer portOne = this.parsedHost.getPort();
            Integer portTwo = other.parsedHost.getPort();
            if (portOne != null) {
                if (portTwo == null) return 1;
                int ret = portOne - portTwo;
                if (ret != 0) {
                    return ret;
                }
            } else if (portTwo != null) {
                return -1;
            }
            String serviceOne = this.parsedHost.getService();
            String serviceTwo = other.parsedHost.getService();
            if (serviceOne != null) {
                if (serviceTwo == null) return 1;
                int ret = serviceOne.compareTo(serviceTwo);
                if (ret == 0) return 0;
                return ret;
            }
            if (serviceTwo == null) return 0;
            return -1;
        }
        if (!other.isValid()) return this.toString().compareTo(other.toString());
        return -1;
    }

    public boolean isAddress(IPAddress.IPVersion version) {
        return this.isValid() && this.parsedHost.isAddressString() && this.parsedHost.asAddress(version) != null;
    }

    public boolean isAddress() {
        return this.isAddressString() && this.parsedHost.asAddress() != null;
    }

    public boolean isAddressString() {
        return this.isValid() && this.parsedHost.isAddressString();
    }

    public boolean isAllAddresses() {
        return this.isAddressString() && this.parsedHost.getAddressProvider().isProvidingAllAddresses();
    }

    public boolean isPrefixOnly() {
        return this.isAddressString() && this.parsedHost.getAddressProvider().isProvidingPrefixOnly();
    }

    public boolean isEmpty() {
        return this.isAddressString() && this.parsedHost.getAddressProvider().isProvidingEmpty();
    }

    public Integer getPort() {
        return this.isValid() ? this.parsedHost.getPort() : null;
    }

    public String getService() {
        return this.isValid() ? this.parsedHost.getService() : null;
    }

    public AddressStringException getAddressStringException() {
        if (this.isValid()) {
            return this.parsedHost.getAddressStringException();
        }
        return null;
    }

    public boolean isUNCIPv6Literal() {
        return this.isValid() && this.parsedHost.isUNCIPv6Literal();
    }

    public boolean isReverseDNS() {
        return this.isValid() && this.parsedHost.isReverseDNS();
    }

    public IPAddressString asAddressString() {
        if (this.isAddressString()) {
            return this.parsedHost.asGenericAddressString();
        }
        return null;
    }

    public IPAddress asAddress() {
        if (this.isAddress()) {
            return this.parsedHost.asAddress();
        }
        return null;
    }

    public IPAddress asAddress(IPAddress.IPVersion version) {
        if (this.isAddress(version)) {
            return this.parsedHost.asAddress(version);
        }
        return null;
    }

    public Integer getNetworkPrefixLength() {
        if (this.isAddress()) {
            return this.parsedHost.asAddress().getNetworkPrefixLength();
        }
        if (this.isAddressString()) {
            return this.parsedHost.asGenericAddressString().getNetworkPrefixLength();
        }
        return this.isValid() ? this.parsedHost.getEquivalentPrefixLength() : null;
    }

    public IPAddress getMask() {
        if (this.isValid()) {
            if (this.parsedHost.isAddressString()) {
                return this.parsedHost.getAddressProvider().getProviderMask();
            }
            return this.parsedHost.getMask();
        }
        return null;
    }

    public InetAddress asInetAddress() {
        IPAddress ipAddr;
        if (this.isValid() && this.isAddressString() && (ipAddr = this.asAddress()) != null) {
            return ipAddr.toInetAddress();
        }
        return null;
    }

    public InetSocketAddress asInetSocketAddress(Function<String, Integer> serviceMapper) {
        if (this.isValid()) {
            String service;
            Integer port = this.getPort();
            if (port == null && serviceMapper != null && (service = this.getService()) != null) {
                port = serviceMapper.apply(service);
            }
            if (port != null) {
                IPAddress ipAddr;
                if (this.isAddressString() && (ipAddr = this.asAddress()) != null) {
                    return new InetSocketAddress(ipAddr.toInetAddress(), (int)port);
                }
                return new InetSocketAddress(this.getHost(), (int)port);
            }
        }
        return null;
    }

    public InetSocketAddress asInetSocketAddress() {
        return this.asInetSocketAddress(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPAddress toAddress() throws UnknownHostException, HostNameException {
        IPAddress addr = this.resolvedAddress;
        if (addr == null && !this.resolvedIsNull) {
            this.validate();
            HostName hostName = this;
            synchronized (hostName) {
                addr = this.resolvedAddress;
                if (addr == null && !this.resolvedIsNull) {
                    if (this.parsedHost.isAddressString()) {
                        addr = this.parsedHost.asAddress();
                        this.resolvedIsNull = addr == null;
                    } else {
                        String strHost = this.parsedHost.getHost();
                        if (strHost.length() == 0 && !this.validationOptions.emptyIsLoopback) {
                            addr = null;
                            this.resolvedIsNull = true;
                        } else {
                            IPAddressNetwork.IPAddressCreator creator;
                            IPAddress mask;
                            InetAddress inetAddress = InetAddress.getByName(strHost);
                            byte[] bytes = inetAddress.getAddress();
                            Integer networkPrefixLength = this.parsedHost.getNetworkPrefixLength();
                            if (networkPrefixLength == null && (mask = this.parsedHost.getMask()) != null) {
                                byte[] maskBytes = mask.getBytes();
                                if (maskBytes.length != bytes.length) {
                                    throw new HostNameException(this.host, "ipaddress.error.ipMismatch");
                                }
                                for (int i = 0; i < bytes.length; ++i) {
                                    int n = i;
                                    bytes[n] = (byte)(bytes[n] & maskBytes[i]);
                                }
                                networkPrefixLength = mask.getBlockMaskPrefixLength(true);
                            }
                            IPAddressStringParameters addressParams = this.validationOptions.addressOptions;
                            if (bytes.length == 16) {
                                creator = addressParams.getIPv6Parameters().getNetwork().getAddressCreator();
                                addr = creator.createAddressInternal(bytes, networkPrefixLength, null, this);
                            } else {
                                creator = addressParams.getIPv4Parameters().getNetwork().getAddressCreator();
                                addr = creator.createAddressInternal(bytes, networkPrefixLength, this);
                            }
                        }
                    }
                    this.resolvedAddress = addr;
                }
            }
        }
        return addr;
    }

    @Override
    public IPAddress getAddress() {
        try {
            return this.toAddress();
        }
        catch (UnknownHostException | HostNameException exception) {
            return null;
        }
    }

    @Override
    public String toString() {
        return this.host;
    }
}

